/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managepaymentreferencecode;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.fenixframework.FenixFramework;

@Component(value="org.fenixedu.treasury.ui.administration.payments.sibs.managePaymentReferenceCode")
@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.payments.sibs.managePaymentReferenceCode", accessGroup="treasuryFrontOffice")
@RequestMapping(value={"/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode"})
public class PaymentReferenceCodeController
extends TreasuryBaseController {
    private static final int MAX_SEARCH = 500;
    public static final String CONTROLLER_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/read/";

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/";
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="referencecode", required=false) String referenceCode, @RequestParam(value="state", required=false) PaymentReferenceCodeStateType state, Model model) {
        List<Object> searchpaymentreferencecodeResultsDataSet = this.filterSearchPaymentReferenceCode(referenceCode, state);
        if (searchpaymentreferencecodeResultsDataSet.size() > 500) {
            searchpaymentreferencecodeResultsDataSet = searchpaymentreferencecodeResultsDataSet.subList(0, 500);
        }
        model.addAttribute("searchpaymentreferencecodeResultsDataSet", searchpaymentreferencecodeResultsDataSet);
        model.addAttribute("stateValues", (Object)PaymentReferenceCodeStateType.values());
        return "treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/search";
    }

    private List<Object> filterSearchPaymentReferenceCode(String referenceCode, PaymentReferenceCodeStateType state) {
        ArrayList<Object> result = new ArrayList<Object>();
        SibsReferenceCode.findAll().filter(p -> p.isInCreatedState()).filter(p -> StringUtils.isEmpty((CharSequence)referenceCode) || p.getReferenceCode().toLowerCase().contains(referenceCode.toLowerCase())).filter(p -> state == null || state.equals((Object)p.getState())).collect(Collectors.toCollection(() -> result));
        SibsPaymentRequest.findAll().filter(p -> StringUtils.isEmpty((CharSequence)referenceCode) || p.getReferenceCode().toLowerCase().contains(referenceCode.toLowerCase())).filter(p -> state == null || state.equals((Object)p.getState())).collect(Collectors.toCollection(() -> result));
        return result;
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") PaymentRequest paymentReferenceCode, Model model) {
        model.addAttribute("paymentReferenceCode", (Object)paymentReferenceCode);
        model.addAttribute("sibsTransactionDetails", (Object)paymentReferenceCode.getPaymentTransactionsSet());
        return "treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/read";
    }

    @RequestMapping(value={"/read/{oid}/anull"}, method={RequestMethod.POST})
    public String processReadToAnull(@PathVariable(value="oid") SibsPaymentRequest paymentReferenceCode, Model model, RedirectAttributes redirectAttributes) {
        try {
            FenixFramework.atomic(() -> paymentReferenceCode.anull());
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.update", (String[])new String[0]), model);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + paymentReferenceCode.getExternalId(), model, redirectAttributes);
    }
}

