/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.groups;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.CustomGroup;
import org.fenixedu.treasury.domain.accesscontrol.PersistentTreasuryFrontOfficeGroup;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;

@GroupOperator(value="treasuryFrontOffice")
public class TreasuryFrontOfficeGroup
extends CustomGroup {
    private static final long serialVersionUID = 1L;
    private static final TreasuryFrontOfficeGroup INSTANCE = new TreasuryFrontOfficeGroup();

    private TreasuryFrontOfficeGroup() {
    }

    public static TreasuryFrontOfficeGroup get() {
        return INSTANCE;
    }

    public Stream<User> getMembers() {
        HashSet result = Sets.newHashSet();
        for (String username : TreasuryAccessControlAPI.getFrontOfficeMemberUsernames()) {
            User user = User.findByUsername((String)username);
            if (user == null) continue;
            result.add(user);
        }
        return result.stream();
    }

    public Stream<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public String getPresentationName() {
        return TreasuryConstants.treasuryBundle((String)"label.TreasuryFrontOfficeGroup.description", (String[])new String[0]);
    }

    public boolean isMember(User user) {
        return this.getMembers().anyMatch(u -> u == user);
    }

    public boolean isMember(User user, DateTime when) {
        return this.getMembers().anyMatch(u -> u == user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentTreasuryFrontOfficeGroup.getInstance();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{TreasuryFrontOfficeGroup.class});
    }

    public boolean equals(Object obj) {
        return obj instanceof TreasuryFrontOfficeGroup;
    }
}

