/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managesibsreportfile;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.payments.sibs.managesibsreportfile.SibsReportFileController$callable$deleteSibsReportFile;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.payments.sibs.manageSibsReportFile", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile"})
public class SibsReportFileController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/delete/";
    private static final String _DOWNLOAD_URI = "/read/download/";
    public static final String DOWNLOAD_URL = "/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/read/download/";
    public static final Advice advice$deleteSibsReportFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/";
    }

    private SibsReportFile getSibsReportFile(Model model) {
        return (SibsReportFile)model.asMap().get("sibsReportFile");
    }

    private void setSibsReportFile(SibsReportFile sibsReportFile, Model model) {
        model.addAttribute("sibsReportFile", (Object)sibsReportFile);
    }

    public void deleteSibsReportFile(SibsReportFile sibsReportFile) {
        Object object = advice$deleteSibsReportFile.perform((Callable)new SibsReportFileController$callable$deleteSibsReportFile(this, sibsReportFile));
    }

    static /* synthetic */ void advised$deleteSibsReportFile(SibsReportFileController this_, SibsReportFile sibsReportFile) {
        sibsReportFile.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="whenprocessedbysibs", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate whenProcessedBySibs, @RequestParam(value="transactionstotalamount", required=false) BigDecimal transactionsTotalAmount, @RequestParam(value="totalcost", required=false) BigDecimal totalCost, Model model) {
        List<SibsReportFile> searchsibsreportfileResultsDataSet = this.filterSearchSibsReportFile(whenProcessedBySibs, transactionsTotalAmount, totalCost);
        model.addAttribute("searchsibsreportfileResultsDataSet", searchsibsreportfileResultsDataSet);
        return "treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/search";
    }

    private Stream<SibsReportFile> getSearchUniverseSearchSibsReportFileDataSet() {
        return SibsReportFile.findAll();
    }

    private List<SibsReportFile> filterSearchSibsReportFile(LocalDate whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost) {
        return this.getSearchUniverseSearchSibsReportFileDataSet().filter(sibsReportFile -> whenProcessedBySibs == null || whenProcessedBySibs.equals((Object)sibsReportFile.getWhenProcessedBySibs())).filter(sibsReportFile -> transactionsTotalAmount == null || transactionsTotalAmount.equals(sibsReportFile.getTransactionsTotalAmount())).filter(sibsReportFile -> totalCost == null || totalCost.equals(sibsReportFile.getTotalCost())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") SibsReportFile sibsReportFile, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + sibsReportFile.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") SibsReportFile sibsReportFile, Model model) {
        this.setSibsReportFile(sibsReportFile, model);
        return "treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") SibsReportFile sibsReportFile, Model model, RedirectAttributes redirectAttributes) {
        this.setSibsReportFile(sibsReportFile, model);
        try {
            this.assertUserIsFrontOfficeMember(model);
            this.deleteSibsReportFile(sibsReportFile);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getSibsReportFile(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/download/{oid}"}, method={RequestMethod.GET})
    public void processReadToDownloadFile(@PathVariable(value="oid") SibsReportFile sibsReportFile, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setSibsReportFile(sibsReportFile, model);
        try {
            this.assertUserIsFrontOfficeMember(model);
            response.setContentType(sibsReportFile.getContentType());
            String filename = sibsReportFile.getFilename();
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(sibsReportFile.getContent());
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + this.getSibsReportFile(model).getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

