/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.ReportGenerationException;
import java.lang.annotation.Annotation;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.ERPCustomerFieldsBean;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.fenixedu.treasury.services.reports.DocumentPrinter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.ui.accounting.managecustomer.DebtAccountController$callable$deleteDebtAccount;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/accounting/managecustomer/debtaccount"})
public class DebtAccountController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/accounting/managecustomer/debtaccount";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/accounting/managecustomer/debtaccount/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/accounting/managecustomer/debtaccount/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/accounting/managecustomer/debtaccount/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/accounting/managecustomer/debtaccount/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/accounting/managecustomer/debtaccount/delete/";
    private static final String _SEARCHOPENDEBTACCOUNTS_URI = "/searchopendebtaccounts";
    public static final String SEARCHOPENDEBTACCOUNTS_URL = "/treasury/accounting/managecustomer/debtaccount/searchopendebtaccounts";
    private static final String _SEARCHOPENDEBTACCOUNTS_TO_VIEW_ACTION_URI = "/searchopendebtaccounts/view/";
    public static final String SEARCHOPENDEBTACCOUNTS_TO_VIEW_ACTION_URL = "/treasury/accounting/managecustomer/debtaccount/searchopendebtaccounts/view/";
    private static final String _TRANSFERBALANCE_URI = "/transferbalance";
    public static final String TRANSFERBALANCE_URL = "/treasury/accounting/managecustomer/debtaccount/transferbalance";
    public static final Advice advice$deleteDebtAccount = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/accounting/managecustomer/customer/";
    }

    private DebtAccount getDebtAccount(Model model) {
        return (DebtAccount)model.asMap().get("debtAccount");
    }

    private void setDebtAccount(DebtAccount debtAccount, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
    }

    public void deleteDebtAccount(DebtAccount debtAccount) {
        Object object = advice$deleteDebtAccount.perform((Callable)new DebtAccountController$callable$deleteDebtAccount(this, debtAccount));
    }

    static /* synthetic */ void advised$deleteDebtAccount(DebtAccountController this_, DebtAccount debtAccount) {
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        boolean filterAnnuledValue = false;
        this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
        this.setDebtAccount(debtAccount, model);
        this.checkFinantialInstitutionData(model);
        ArrayList allInvoiceEntries = new ArrayList();
        List<Object> paymentEntries = new ArrayList();
        ArrayList exemptionEntries = new ArrayList();
        ArrayList pendingInvoiceEntries = new ArrayList();
        allInvoiceEntries.addAll(debtAccount.getInvoiceEntrySet().stream().collect(Collectors.toList()));
        paymentEntries = SettlementNote.findByDebtAccount((DebtAccount)debtAccount).collect(Collectors.toList());
        exemptionEntries.addAll(TreasuryExemption.findByDebtAccount((DebtAccount)debtAccount).collect(Collectors.toList()));
        pendingInvoiceEntries.addAll(debtAccount.getPendingInvoiceEntriesSet());
        model.addAttribute("pendingDocumentsDataSet", pendingInvoiceEntries.stream().sorted(InvoiceEntry.COMPARE_BY_ENTRY_DATE.reversed().thenComparing(InvoiceEntry.COMPARE_BY_DUE_DATE.reversed())).collect(Collectors.toList()));
        model.addAttribute("allDocumentsDataSet", allInvoiceEntries.stream().sorted(InvoiceEntry.COMPARE_BY_ENTRY_DATE.reversed().thenComparing(InvoiceEntry.COMPARE_BY_DUE_DATE.reversed())).collect(Collectors.toList()));
        model.addAttribute("paymentsDataSet", paymentEntries.stream().sorted((x, y) -> y.getDocumentDate().compareTo((ReadableInstant)x.getDocumentDate())).collect(Collectors.toList()));
        model.addAttribute("exemptionDataSet", exemptionEntries);
        HashSet usedPaymentCodeTargets = Sets.newHashSet();
        pendingInvoiceEntries.stream().filter(InvoiceEntry::isDebitNoteEntry).map(DebitEntry.class::cast).flatMap(i -> i.getPaymentRequestsSet().stream()).filter(i -> i instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast).filter(SibsPaymentRequest::isInRequestedState).collect(Collectors.toCollection(() -> usedPaymentCodeTargets));
        this.checkIncompleteAddress(debtAccount, model);
        model.addAttribute("usedPaymentCodeTargets", (Object)usedPaymentCodeTargets);
        model.addAttribute("invalidFiscalCode", (Object)this.isInvalidFiscalCode(debtAccount));
        if (DebtAccountController.findUniqueActiveForForwardPaymentService(debtAccount.getFinantialInstitution()).isPresent()) {
            model.addAttribute("forwardPaymentService", (Object)DebtAccountController.findUniqueActiveForForwardPaymentService(debtAccount.getFinantialInstitution()).get());
        }
        if (DebtAccountController.findUniqueActiveForMbwayService(debtAccount.getFinantialInstitution()).isPresent()) {
            model.addAttribute("mbwayService", (Object)DebtAccountController.findUniqueActiveForMbwayService(debtAccount.getFinantialInstitution()).get());
        }
        return "treasury/accounting/managecustomer/debtaccount/read";
    }

    private void checkIncompleteAddress(DebtAccount debtAccount, Model model) {
        ArrayList errorMessages = Lists.newArrayList();
        boolean validAddress = ERPCustomerFieldsBean.checkIncompleteAddressForDebtAccountAndPayors((DebtAccount)debtAccount, (List)errorMessages);
        model.addAttribute("validAddress", (Object)validAddress);
        model.addAttribute("addressErrorMessages", (Object)errorMessages);
    }

    private boolean isInvalidFiscalCode(DebtAccount debtAccount) {
        Customer customer = debtAccount.getCustomer();
        return !customer.isFiscalCodeValid();
    }

    @RequestMapping(value={"/read/{oid}/createreimbursement"})
    public String processReadToCreateReimbursement(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        this.setDebtAccount(debtAccount, model);
        return this.redirect("/treasury/document/managepayments/settlementnote/chooseInvoiceEntries/" + this.getDebtAccount(model).getExternalId() + SEARCH_URI + true, model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/createpayment"})
    public String processReadToCreatePayment(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        this.setDebtAccount(debtAccount, model);
        return this.redirect("/treasury/document/managepayments/settlementnote/chooseInvoiceEntries/" + this.getDebtAccount(model).getExternalId() + SEARCH_URI + false, model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/forwardpayment/{digitalPaymentPlatformId}"})
    public String processReadToForwardPayment(@PathVariable(value="oid") DebtAccount debtAccount, @PathVariable(value="digitalPaymentPlatformId") DigitalPaymentPlatform digitalPaymentPlatform, Model model, RedirectAttributes redirectAttributes) {
        this.setDebtAccount(debtAccount, model);
        return this.redirect(String.format("%s%s/%s", "/treasury/document/forwardpayments/forwardpayment/chooseInvoiceEntries/", this.getDebtAccount(model).getExternalId(), digitalPaymentPlatform.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/createdebtentry"})
    public String processReadToCreateDebtEntry(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        this.setDebtAccount(debtAccount, model);
        return this.redirect("/treasury/document/manageinvoice/debitentry/create/" + this.getDebtAccount(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/createdebitnote"})
    public String processReadToCreateDebitNote(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        this.setDebtAccount(debtAccount, model);
        return this.redirect("/treasury/document/manageinvoice/debitnote/create?debtaccount=" + this.getDebtAccount(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/createcreditnote"})
    public String processReadToCreateCreditNote(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        this.setDebtAccount(debtAccount, model);
        return this.redirect("/treasury/document/manageinvoice/creditnote/create?debtaccount=" + this.getDebtAccount(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/readevent"})
    public String processReadToReadEvent(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        this.setDebtAccount(debtAccount, model);
        return this.redirect("/treasury/accounting/managecustomer/treasuryevent/?debtaccount=" + this.getDebtAccount(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/autocompletehelper"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<List<TreasuryTupleDataSourceBean>> processReadToReadEvent(@RequestParam(value="q", required=true) String searchField, Model model, RedirectAttributes redirectAttributes) {
        String searchFieldDecoded = URLDecoder.decode(searchField).trim();
        ArrayList<TreasuryTupleDataSourceBean> bean = new ArrayList<TreasuryTupleDataSourceBean>();
        List debtAccounts = DebtAccount.findAll().filter(x -> x.getCustomer().matchesMultiFilter(searchFieldDecoded)).sorted((x, y) -> x.getCustomer().getName().compareToIgnoreCase(y.getCustomer().getName())).collect(Collectors.toList());
        for (DebtAccount debt : debtAccounts) {
            bean.add(new TreasuryTupleDataSourceBean(debt.getExternalId(), debt.getCustomer().getName() + " [" + debt.getFinantialInstitution().getCode() + "] (#" + debt.getCustomer().getBusinessIdentification() + ") (" + debt.getCustomer().getIdentificationNumber() + ")"));
        }
        return new ResponseEntity(bean, HttpStatus.OK);
    }

    @RequestMapping(value={"/searchopendebtaccounts"})
    public String searchOpenDebtAccounts(Model model) {
        List<DebtAccount> searchopendebtaccountsResultsDataSet = this.filterSearchOpenDebtAccounts();
        this.checkFinantialInstitutionData(model);
        model.addAttribute("searchopendebtaccountsResultsDataSet", searchopendebtaccountsResultsDataSet);
        return "treasury/accounting/managecustomer/debtaccount/searchopendebtaccounts";
    }

    private Stream<DebtAccount> getSearchUniverseSearchOpenDebtAccountsDataSet() {
        return DebtAccount.findAll().filter(x -> !x.getPendingInvoiceEntriesSet().isEmpty());
    }

    private List<DebtAccount> filterSearchOpenDebtAccounts() {
        return this.getSearchUniverseSearchOpenDebtAccountsDataSet().collect(Collectors.toList());
    }

    @RequestMapping(value={"/searchopendebtaccounts/view/{oid}"})
    public String processSearchOpenDebtAccountsToViewAction(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + debtAccount.getExternalId(), model, redirectAttributes);
    }

    private void checkFinantialInstitutionData(Model model) {
        LocalDate now = new LocalDate();
        if (GlobalInterestRate.findByYear((int)now.getYear()).count() == 0L) {
            this.addWarningMessage(TreasuryConstants.treasuryBundle((String)"warning.GlobalInterestRate.no.interest.rate.for.current.year", (String[])new String[0]), model);
        }
        if (now.getMonthOfYear() == 12 && now.getDayOfMonth() >= 15 && GlobalInterestRate.findByYear((int)(now.getYear() + 1)).count() == 0L) {
            this.addWarningMessage(TreasuryConstants.treasuryBundle((String)"warning.GlobalInterestRate.no.interest.rate.for.next.year", (String[])new String[0]), model);
        }
    }

    @RequestMapping(value={"/read/{oid}/exportintegrationonline"})
    public String processReadToExportIntegrationOnline(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
            throw new TreasuryDomainException("Desactivado", new String[0]);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.integration.erp.exportoperation.error", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            return this.read(debtAccount, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/read/{oid}/printpaymentplan"}, produces={"application/pdf"})
    public Object processReadToPrintDocument(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
            byte[] report = DocumentPrinter.printDebtAccountPaymentPlan((DebtAccount)debtAccount, (String)"application/pdf");
            return new ResponseEntity((Object)report, HttpStatus.OK);
        }
        catch (ReportGenerationException rex) {
            this.addErrorMessage(rex.getLocalizedMessage(), model);
            this.addErrorMessage(rex.getCause().getLocalizedMessage(), model);
            return this.redirect(READ_URL + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(READ_URL + debtAccount.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/transferbalance/{oid}"})
    public String transferbalance(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (debtAccount.getCustomer().isActive()) {
                throw new TreasuryDomainException("error.DebtAccount.transfer.from.must.not.be.active", new String[0]);
            }
            debtAccount.transferBalanceForActiveDebtAccount();
            return this.redirect(READ_URL + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.read(debtAccount, model, redirectAttributes);
        }
    }

    public static Optional<? extends DigitalPaymentPlatform> findUniqueActiveForForwardPaymentService(FinantialInstitution finantialInstitution) {
        return DigitalPaymentPlatform.findForForwardPaymentService((FinantialInstitution)finantialInstitution, (boolean)true).sorted((o1, o2) -> o1.getName().compareTo(o2.getName()) * 10 + o1.getExternalId().compareTo(o2.getExternalId())).findFirst();
    }

    public static Optional<? extends DigitalPaymentPlatform> findUniqueActiveForMbwayService(FinantialInstitution finantialInstitution) {
        return DigitalPaymentPlatform.find((FinantialInstitution)finantialInstitution).filter(DigitalPaymentPlatform::isActive).filter(d -> d.isMbwayServiceSupported()).sorted((o1, o2) -> o1.getName().compareTo(o2.getName()) * 10 + o1.getExternalId().compareTo(o2.getExternalId())).findFirst();
    }
}

