/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.managefinantialinstitution;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialEntityController$callable$createFinantialEntity;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialEntityController$callable$deleteFinantialEntity;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialEntityController$callable$updateFinantialEntity;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Component(value="org.fenixedu.treasury.ui.administration.manageFinantialInstitution")
@BennuSpringController(value=FinantialInstitutionController.class)
@RequestMapping(value={"/treasury/administration/managefinantialinstitution/finantialentity"})
public class FinantialEntityController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/managefinantialinstitution/finantialentity";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/managefinantialinstitution/finantialentity/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/managefinantialinstitution/finantialentity/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/managefinantialinstitution/finantialentity/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/managefinantialinstitution/finantialentity/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/managefinantialinstitution/finantialentity/delete/";
    public static final Advice advice$deleteFinantialEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createFinantialEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateFinantialEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        if (model.containsAttribute("finantialInstitutionId")) {
            return "forward:/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + model.asMap().get("finantialInstitutionId");
        }
        return "forward:/treasury/administration/managefinantialinstitution/finantialinstitution/";
    }

    private FinantialEntity getFinantialEntity(Model model) {
        return (FinantialEntity)model.asMap().get("finantialEntity");
    }

    private void setFinantialEntity(FinantialEntity finantialEntity, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
    }

    public void deleteFinantialEntity(FinantialEntity finantialEntity) {
        Object object = advice$deleteFinantialEntity.perform((Callable)new FinantialEntityController$callable$deleteFinantialEntity(this, finantialEntity));
    }

    static /* synthetic */ void advised$deleteFinantialEntity(FinantialEntityController this_, FinantialEntity finantialEntity) {
        finantialEntity.delete();
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") FinantialEntity finantialEntity, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + finantialEntity.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") FinantialEntity finantialEntity, Model model) {
        this.setFinantialEntity(finantialEntity, model);
        return "treasury/administration/managefinantialinstitution/finantialentity/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") FinantialEntity finantialEntity, Model model, RedirectAttributes redirectAttributes) {
        this.setFinantialEntity(finantialEntity, model);
        try {
            FinantialInstitution finantialInstitution = finantialEntity.getFinantialInstitution();
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.deleteFinantialEntity(finantialEntity);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + finantialInstitution.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getFinantialEntity(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(@RequestParam(value="finantialInstitutionId", required=false) FinantialInstitution finantialInstitution, Model model) {
        model.addAttribute("finantialInstitutionId", (Object)finantialInstitution.getExternalId());
        return "treasury/administration/managefinantialinstitution/finantialentity/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="finantialInstitutionId", required=false) FinantialInstitution finantialInstitution, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            FinantialEntity finantialEntity = this.createFinantialEntity(finantialInstitution, code, name);
            model.addAttribute("finantialEntity", (Object)finantialEntity);
            return this.redirect(READ_URL + this.getFinantialEntity(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(finantialInstitution, model);
    }

    public FinantialEntity createFinantialEntity(FinantialInstitution finantialInstitution, String string, LocalizedString localizedString) {
        return (FinantialEntity)advice$createFinantialEntity.perform((Callable)new FinantialEntityController$callable$createFinantialEntity(this, finantialInstitution, string, localizedString));
    }

    static /* synthetic */ FinantialEntity advised$createFinantialEntity(FinantialEntityController this_, FinantialInstitution finantialInstitution, String code, LocalizedString name) {
        FinantialEntity finantialEntity = FinantialEntity.create((FinantialInstitution)finantialInstitution, (String)code, (LocalizedString)name);
        return finantialEntity;
    }

    @RequestMapping(value={"/search/edit/{oid}"})
    public String processSearchToEditAction(@PathVariable(value="oid") FinantialEntity finantialEntity, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(UPDATE_URL + finantialEntity.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") FinantialEntity finantialEntity, Model model) {
        this.setFinantialEntity(finantialEntity, model);
        return "treasury/administration/managefinantialinstitution/finantialentity/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") FinantialEntity finantialEntity, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        this.setFinantialEntity(finantialEntity, model);
        try {
            this.assertUserIsFrontOfficeMember(finantialEntity.getFinantialInstitution(), model);
            this.updateFinantialEntity(code, name, model);
            return this.redirect(READ_URL + this.getFinantialEntity(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(finantialEntity, model);
    }

    public void updateFinantialEntity(String string, LocalizedString localizedString, Model model) {
        Object object = advice$updateFinantialEntity.perform((Callable)new FinantialEntityController$callable$updateFinantialEntity(this, string, localizedString, model));
    }

    static /* synthetic */ void advised$updateFinantialEntity(FinantialEntityController this_, String code, LocalizedString name, Model model) {
        this_.getFinantialEntity(model).edit(code, name);
    }
}

