/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.standards.geographic;

import java.util.stream.Stream;
import pt.ist.standards.geographic.Country;
import pt.ist.standards.geographic.Place;
import pt.ist.standards.geographic.Planet;

public class TreasuryGeographicInfoLoader {
    public static final String PRT = "PRT";
    private static TreasuryGeographicInfoLoader geographicInfoLoader = new TreasuryGeographicInfoLoader();
    private final Planet earth = Planet.getEarth();

    private TreasuryGeographicInfoLoader() {
    }

    public Stream<Country> findAllCountries() {
        return this.earth.getPlaces().stream();
    }

    public static TreasuryGeographicInfoLoader getInstance() {
        return geographicInfoLoader;
    }

    public static boolean isDefaultCountry(Country country) {
        return country.alpha3.equals(PRT);
    }

    public Place importPlaceFromString(String placeString) {
        if (placeString == null || placeString.length() == 0) {
            return null;
        }
        return this.earth.importFrom(placeString);
    }

    public static String externalizePlace(Place place) {
        return place.exportAsString();
    }

    public static <T extends Place> T internalizePlace(String placeString) {
        TreasuryGeographicInfoLoader geographicInfoLoader = TreasuryGeographicInfoLoader.getInstance();
        return (T)geographicInfoLoader.importPlaceFromString(placeString);
    }
}

