/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentCodeTransaction_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.FenixFramework;

public class SibsPaymentCodeTransaction
extends SibsPaymentCodeTransaction_Base {
    public static final String DATE_TIME_FORMAT = "yyyyMMddHHmm";

    public SibsPaymentCodeTransaction() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setResponsibleUsername(TreasuryConstants.getAuthenticatedUsername());
        this.setCreationDate(new DateTime());
    }

    protected SibsPaymentCodeTransaction(SibsReportFile reportFile, SibsPaymentRequest sibsPaymentRequest, DateTime paymentDate, BigDecimal paidAmount, String sibsTransactionId, DateTime sibsProcessingDate, String sibsImportationFilename, Set<SettlementNote> settlementNotes) {
        this();
        String entityReferenceCode = sibsPaymentRequest.getEntityReferenceCode();
        String referenceCode = sibsPaymentRequest.getReferenceCode();
        String transactionId = String.format("%s-%s-%s", entityReferenceCode, referenceCode, paymentDate.toString(DATE_TIME_FORMAT));
        this.init((PaymentRequest)((Object)sibsPaymentRequest), transactionId, paymentDate, paidAmount, settlementNotes);
        this.setSibsEntityReferenceCode(entityReferenceCode);
        this.setSibsPaymentReferenceCode(referenceCode);
        this.setSibsTransactionId(sibsTransactionId);
        this.setSibsProcessingDate(sibsProcessingDate);
        this.setComments(sibsImportationFilename);
        this.setSibsReportFile(reportFile);
        this.checkRules();
    }

    protected SibsPaymentCodeTransaction(SibsPaymentRequest sibsPaymentRequest, DateTime paymentDate, BigDecimal paidAmount, String referenceCode, String sibsTransactionId, Set<SettlementNote> settlementNotes) {
        this();
        String entityReferenceCode = sibsPaymentRequest.getEntityReferenceCode();
        String transactionId = String.format("%s-%s-%s", entityReferenceCode, referenceCode, paymentDate.toString(DATE_TIME_FORMAT));
        this.init((PaymentRequest)((Object)sibsPaymentRequest), transactionId, paymentDate, paidAmount, settlementNotes);
        this.setSibsEntityReferenceCode(entityReferenceCode);
        this.setSibsPaymentReferenceCode(referenceCode);
        this.setSibsTransactionId(sibsTransactionId);
        this.checkRules();
    }

    public void checkRules() {
        super.checkRules();
        if (StringUtils.isEmpty((String)this.getSibsEntityReferenceCode())) {
            throw new TreasuryDomainException("error.SibsPaymentCodeTransaction.sibsEntityReferenceCode.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getSibsPaymentReferenceCode())) {
            throw new TreasuryDomainException("error.SibsPaymentCodeTransaction.sibsPaymentReferenceCode.required", new String[0]);
        }
        if (SibsPaymentCodeTransaction.find(this.getSibsEntityReferenceCode(), this.getSibsPaymentReferenceCode(), this.getPaymentDate()).count() > 1L) {
            throw new TreasuryDomainException("error.SibsPaymentCodeTransaction.transaction.duplicate", new String[]{this.getSibsEntityReferenceCode(), this.getSibsPaymentReferenceCode(), this.getPaymentDate().toString("yyyy/MM/dd HH:mm:ss")});
        }
        if (!(this.getPaymentRequest().getDigitalPaymentPlatform() instanceof SibsPaymentCodePool) && !StringUtils.isEmpty((String)this.getSibsTransactionId()) && SibsPaymentCodeTransaction.findBySibsGatewayTransactionId(this.getSibsTransactionId()).count() > 1L) {
            throw new TreasuryDomainException("error.SibsPaymentCodeTransaction.sibsTransactionId.duplicate", this.getSibsTransactionId());
        }
    }

    public boolean isSameTransactionId(String transactionId) {
        return super.isSameTransactionId(transactionId) || transactionId.equalsIgnoreCase(this.getSibsTransactionId());
    }

    public static Stream<SibsPaymentCodeTransaction> findAll() {
        return FenixFramework.getDomainRoot().getPaymentTransactionsSet().stream().filter(t -> t instanceof SibsPaymentCodeTransaction).map(SibsPaymentCodeTransaction.class::cast);
    }

    public static boolean isReferenceProcessingDuplicate(String entityReferenceCode, String referenceCode, DateTime paymentDate) {
        return SibsPaymentCodeTransaction.find(entityReferenceCode, referenceCode, paymentDate).findAny().isPresent();
    }

    private static Stream<SibsPaymentCodeTransaction> find(String entityReferenceCode, String referenceCode, DateTime paymentDate) {
        return SibsPaymentCodeTransaction.findAll().filter(x -> {
            boolean paymentDatesAreSame = paymentDate.withMillisOfSecond(0).compareTo((ReadableInstant)x.getPaymentDate().withMillisOfSecond(0)) == 0;
            return entityReferenceCode.equals(x.getSibsEntityReferenceCode()) && referenceCode.equals(x.getSibsPaymentReferenceCode()) && paymentDatesAreSame;
        });
    }

    public static Stream<SibsPaymentCodeTransaction> findBySibsGatewayTransactionId(String sibsTransactionId) {
        return SibsPaymentCodeTransaction.findAll().filter(i -> sibsTransactionId.equalsIgnoreCase(i.getSibsTransactionId()));
    }

    @Deprecated
    public static boolean isSibsGatewayReferenceProcessingDuplicate(String sibsTransactionId) {
        return SibsPaymentCodeTransaction.findAll().filter(i -> i.isSameTransactionId(sibsTransactionId)).count() > 0L;
    }

    public static SibsPaymentCodeTransaction create(SibsReportFile reportFile, SibsPaymentRequest sibsPaymentRequest, DateTime paymentDate, BigDecimal paidAmount, String sibsTransactionId, DateTime sibsProcessingDate, String sibsImportationFilename, Set<SettlementNote> settlementNotes) {
        String referenceCode;
        String entityReferenceCode = sibsPaymentRequest.getEntityReferenceCode();
        if (SibsPaymentCodeTransaction.isReferenceProcessingDuplicate(entityReferenceCode, referenceCode = sibsPaymentRequest.getReferenceCode(), paymentDate)) {
            throw new TreasuryDomainException("error.SibsPaymentCodeTransaction.transaction.duplicate", new String[]{entityReferenceCode, referenceCode, paymentDate.toString("yyyy/MM/dd HH:mm:ss")});
        }
        return new SibsPaymentCodeTransaction(reportFile, sibsPaymentRequest, paymentDate, paidAmount, sibsTransactionId, sibsProcessingDate, sibsImportationFilename, settlementNotes);
    }

    public static SibsPaymentCodeTransaction createForImportation(SibsPaymentRequest sibsPaymentRequest, DateTime paymentDate, BigDecimal paidAmount, String referenceCode, String sibsTransactionId, Set<SettlementNote> settlementNotes) {
        String entityReferenceCode = sibsPaymentRequest.getEntityReferenceCode();
        if (SibsPaymentCodeTransaction.isReferenceProcessingDuplicate(entityReferenceCode, referenceCode, paymentDate)) {
            throw new TreasuryDomainException("error.SibsPaymentCodeTransaction.transaction.duplicate", new String[]{entityReferenceCode, referenceCode, paymentDate.toString("yyyy/MM/dd HH:mm:ss")});
        }
        return new SibsPaymentCodeTransaction(sibsPaymentRequest, paymentDate, paidAmount, referenceCode, sibsTransactionId, settlementNotes);
    }
}

