/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.integration;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPExportOperation$callable$copy;
import org.fenixedu.treasury.domain.integration.ERPExportOperation$callable$create;
import org.fenixedu.treasury.domain.integration.ERPExportOperation$callable$createSaftExportOperation;
import org.fenixedu.treasury.domain.integration.ERPExportOperation$callable$delete;
import org.fenixedu.treasury.domain.integration.ERPExportOperation_Base;
import org.fenixedu.treasury.domain.integration.IntegrationOperation;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.fenixedu.treasury.services.integration.FenixEDUTreasuryPlatformDependentServices;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPExportOperation
extends ERPExportOperation_Base {
    public static final Comparator<ERPExportOperation> COMPARE_BY_VERSIONING_CREATION_DATE;
    public static final Advice advice$delete;
    public static final Advice advice$createSaftExportOperation;
    public static final Advice advice$create;
    public static final Advice advice$copy;

    protected ERPExportOperation() {
    }

    protected void init(OperationFile file, FinantialInstitution finantialInstitution, String erpOperationId, DateTime executionDate, boolean processed, boolean success, boolean corrected) {
        this.setFile(file);
        this.setFinantialInstitution(finantialInstitution);
        this.setErpOperationId(erpOperationId);
        this.setExecutionDate(executionDate);
        this.setProcessed(processed);
        this.setSuccess(success);
        this.setCorrected(corrected);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFile() == null) {
            throw new TreasuryDomainException("error.ERPExportOperation.file.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.ERPExportOperation.finantialInstitution.required", new String[0]);
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ERPExportOperation$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ERPExportOperation this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.ERPExportOperation.cannot.delete", new String[0]);
        }
        this_.setFinantialInstitution(null);
        for (FinantialDocument document : this_.getFinantialDocumentsSet()) {
            this_.removeFinantialDocuments(document);
        }
        super.delete();
    }

    public static ERPExportOperation createSaftExportOperation(byte[] byArray, FinantialInstitution finantialInstitution, DateTime dateTime) {
        return (ERPExportOperation)((Object)advice$createSaftExportOperation.perform((Callable)new ERPExportOperation$callable$createSaftExportOperation(byArray, finantialInstitution, dateTime)));
    }

    static /* synthetic */ ERPExportOperation advised$createSaftExportOperation(byte[] data, FinantialInstitution institution, DateTime when) {
        String filename = institution.getFiscalNumber() + "_" + when.toString() + ".xml";
        ERPExportOperation operation = ERPExportOperation.create(data, filename, institution, null, when, false, false, false);
        return operation;
    }

    public static ERPExportOperation create(byte[] byArray, String string, FinantialInstitution finantialInstitution, String string2, DateTime dateTime, boolean bl, boolean bl2, boolean bl3) {
        return (ERPExportOperation)((Object)advice$create.perform((Callable)new ERPExportOperation$callable$create(byArray, string, finantialInstitution, string2, dateTime, bl, bl2, bl3)));
    }

    static /* synthetic */ ERPExportOperation advised$create(byte[] data, String filename, FinantialInstitution finantialInstitution, String erpOperationId, DateTime executionDate, boolean processed, boolean success, boolean corrected) {
        ERPExportOperation eRPExportOperation = new ERPExportOperation();
        OperationFile file = data == null ? OperationFile.create(filename, new byte[0], (IntegrationOperation)((Object)eRPExportOperation)) : OperationFile.create(filename, data, (IntegrationOperation)((Object)eRPExportOperation));
        eRPExportOperation.init(file, finantialInstitution, erpOperationId, executionDate, processed, success, corrected);
        return eRPExportOperation;
    }

    public static ERPExportOperation copy(ERPExportOperation eRPExportOperation) {
        return (ERPExportOperation)((Object)advice$copy.perform((Callable)new ERPExportOperation$callable$copy(eRPExportOperation)));
    }

    static /* synthetic */ ERPExportOperation advised$copy(ERPExportOperation log2) {
        byte[] data = log2.getFile().getContent();
        String filename = log2.getFile().getFilename();
        FinantialInstitution finantialInstitution = log2.getFinantialInstitution();
        String erpOperationId = log2.getErpOperationId();
        DateTime executionDate = log2.getExecutionDate();
        boolean processed = log2.getProcessed();
        boolean success = log2.getSuccess();
        boolean corrected = log2.getCorrected();
        ERPExportOperation copy2 = ERPExportOperation.create(data, filename, finantialInstitution, erpOperationId, executionDate, processed, success, corrected);
        copy2.appendLog(log2.getErrorLog(), log2.getIntegrationLog(), log2.getSoapInboundMessage(), log2.getSoapOutboundMessage());
        copy2.getFinantialDocumentsSet().addAll(log2.getFinantialDocumentsSet());
        return copy2;
    }

    public static Stream<ERPExportOperation> findAll() {
        HashSet results = new HashSet();
        for (FinantialInstitution fi : FenixFramework.getDomainRoot().getFinantialInstitutionsSet()) {
            results.addAll(fi.getIntegrationOperationsSet().stream().filter(x -> x instanceof ERPExportOperation).map(ERPExportOperation.class::cast).collect(Collectors.toList()));
        }
        return results.stream();
    }

    public static Stream<ERPExportOperation> findByFile(FinantialInstitution finantialInstitution, OperationFile file) {
        return ERPExportOperation.findByFinantialInstitution(finantialInstitution).filter(i -> file.equals(i.getFile()));
    }

    public static Stream<ERPExportOperation> findByFinantialInstitution(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getIntegrationOperationsSet().stream().filter(x -> x instanceof ERPExportOperation).map(ERPExportOperation.class::cast);
    }

    public static Stream<ERPExportOperation> find(FinantialDocument finantialDocument) {
        return finantialDocument.getErpExportOperationsSet().stream();
    }

    public static Stream<ERPExportOperation> findByExecutionDate(FinantialInstitution finantialInstitution, DateTime executionDate) {
        return ERPExportOperation.findByFinantialInstitution(finantialInstitution).filter(i -> executionDate.equals((Object)i.getExecutionDate()));
    }

    public static Stream<ERPExportOperation> findByProcessed(FinantialInstitution finantialInstitution, boolean processed) {
        return ERPExportOperation.findByFinantialInstitution(finantialInstitution).filter(i -> processed == i.getProcessed());
    }

    public static Stream<ERPExportOperation> findBySuccess(FinantialInstitution finantialInstitution, boolean success) {
        return ERPExportOperation.findByFinantialInstitution(finantialInstitution).filter(i -> success == i.getSuccess());
    }

    public static Stream<ERPExportOperation> findByCorrected(FinantialInstitution finantialInstitution, boolean corrected) {
        return ERPExportOperation.findByFinantialInstitution(finantialInstitution).filter(i -> corrected == i.getCorrected());
    }

    public static Stream<ERPExportOperation> findByErrorLog(FinantialInstitution finantialInstitution, String errorLog) {
        return ERPExportOperation.findByFinantialInstitution(finantialInstitution).filter(i -> errorLog.equalsIgnoreCase(i.getErrorLog()));
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createSaftExportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$copy = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_VERSIONING_CREATION_DATE = new Comparator<ERPExportOperation>(){

            @Override
            public int compare(ERPExportOperation o1, ERPExportOperation o2) {
                int c = FenixEDUTreasuryPlatformDependentServices.getVersioningCreationDate(o1).compareTo((ReadableInstant)FenixEDUTreasuryPlatformDependentServices.getVersioningCreationDate(o2));
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

