/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments.payline;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.apache.commons.validator.routines.EmailValidator;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentController;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineWebServiceClient;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration$callable$advanceToPaidState;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration$callable$createForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration$callable$doWebPayment;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration$callable$postProcessPayment;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration$callable$reject;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration_Base;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineWebServiceResponse;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.services.integration.FenixEDUTreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Address;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Buyer;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Details;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.DoWebPaymentRequest;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.DoWebPaymentResponse;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.GetWebPaymentDetailsRequest;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.GetWebPaymentDetailsResponse;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Order;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.OrderDetail;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Payment;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.WebPaymentAPI;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaylineConfiguration
extends PaylineConfiguration_Base
implements IForwardPaymentPlatformService {
    private static final String TRANSACTION_APPROVED_CODE = "00000";
    private static final String TRANSACTION_PENDING_FORM_FILL = "02306";
    public static final String ACTION_RETURN_URL = "return";
    public static final String ACTION_CANCEL_URL = "cancel";
    public static final String LANG_PT = "pt";
    public static final String LANG_EN = "en";
    public static final Advice advice$postProcessPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$doWebPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$reject = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$advanceToPaidState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForwardPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PaylineConfiguration() {
    }

    protected PaylineConfiguration(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active, String paymentURL, String paylineMerchantId, String paylineMerchantAccessKey, String paylineContractNumber) {
        this();
        this.init(finantialInstitution, finantialEntity, name, active);
        this.setPaymentURL(paymentURL);
        this.setPaylineMerchantId(paylineMerchantId);
        this.setPaylineMerchantAccessKey(paylineMerchantAccessKey);
        this.setPaylineContractNumber(paylineContractNumber);
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getCreditCardPaymentMethod());
        this.checkRules();
    }

    @Override
    public IForwardPaymentController getForwardPaymentController(ForwardPaymentRequest forwardPayment) {
        return IForwardPaymentController.getForwardPaymentController((PaymentRequest)((Object)forwardPayment));
    }

    @Override
    public String getPaymentURL(ForwardPaymentRequest request) {
        throw new RuntimeException("not applied");
    }

    @Override
    public String getLogosJspPage() {
        return "implementations/payline/logos.jsp";
    }

    @Override
    public String getWarningBeforeRedirectionJspPage() {
        return "implementations/payline/warning.jsp";
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPaymentRequest forwardPayment) {
        if (!forwardPayment.getDigitalPaymentPlatform().isActive()) {
            throw new TreasuryDomainException("error.ForwardPaymentConfiguration.not.active", new String[0]);
        }
        PaylineWebServiceResponse response = this.paylineGetWebPaymentDetails(forwardPayment);
        ForwardPaymentStateType type = null;
        String authorizationNumber = null;
        DateTime authorizationDate = null;
        String transactionId = null;
        DateTime transactionDate = null;
        BigDecimal payedAmount = null;
        boolean success = TRANSACTION_APPROVED_CODE.equals(response.getResultCode());
        if (!success) {
            type = TRANSACTION_PENDING_FORM_FILL.equals(response.getResultCode()) ? ForwardPaymentStateType.REQUESTED : ForwardPaymentStateType.REJECTED;
        } else {
            authorizationNumber = response.getAuthorizationNumber();
            authorizationDate = response.getAuthorizationDate();
            transactionId = response.getTransactionId();
            payedAmount = response.getPaymentAmount();
            transactionDate = response.getTransactionDate();
            type = ForwardPaymentStateType.PAYED;
        }
        ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(true, type, response.getResultCode(), response.getResultLongMessage(), response.getJsonRequest(), response.getJsonResponse());
        bean.editAuthorizationDetails(authorizationNumber, authorizationDate);
        bean.editTransactionDetails(transactionId, transactionDate, payedAmount);
        return bean;
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPaymentRequest forwardPaymentRequest, String string, Optional<String> optional) {
        return (PostProcessPaymentStatusBean)advice$postProcessPayment.perform((Callable)new PaylineConfiguration$callable$postProcessPayment(this, forwardPaymentRequest, string, optional));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ PostProcessPaymentStatusBean advised$postProcessPayment(PaylineConfiguration this_, ForwardPaymentRequest forwardPayment, String justification, Optional specificTransactionId) {
        ForwardPaymentStateType previousState = forwardPayment.getCurrentState();
        ForwardPaymentStatusBean paymentStatusBean = forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService().paymentStatus(forwardPayment);
        if (!forwardPayment.getState().isInStateToPostProcessPayment()) {
            throw new TreasuryDomainException("error.ManageForwardPayments.forwardPayment.not.created.nor.requested", String.valueOf(forwardPayment.getOrderNumber()));
        }
        if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(paymentStatusBean.getStateType())) {
            return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, false);
        }
        boolean success = TRANSACTION_APPROVED_CODE.equals(paymentStatusBean.getStatusCode());
        if (!paymentStatusBean.isOperationSuccess()) {
            throw new TreasuryDomainException("error.ManageForwardPayments.postProcessPayment.invocation.unsucessful", String.valueOf(forwardPayment.getOrderNumber()));
        }
        if (!success) {
            forwardPayment.reject("postProcessPayment", paymentStatusBean.getStatusCode(), paymentStatusBean.getStatusMessage(), paymentStatusBean.getRequestBody(), paymentStatusBean.getResponseBody());
            return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, false);
        }
        forwardPayment.advanceToPaidState(paymentStatusBean.getStatusCode(), paymentStatusBean.getStatusMessage(), paymentStatusBean.getPayedAmount(), paymentStatusBean.getTransactionDate(), paymentStatusBean.getTransactionId(), paymentStatusBean.getAuthorizationNumber(), paymentStatusBean.getRequestBody(), paymentStatusBean.getResponseBody(), justification);
        return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, true);
    }

    public void edit(String name, boolean active, String paymentURL, String paylineMerchantId, String paylineMerchantAccessKey, String paylineContractNumber) {
        this.setName(name);
        this.setActive(active);
        this.setPaymentURL(paymentURL);
        this.setPaylineMerchantId(paylineMerchantId);
        this.setPaylineMerchantAccessKey(paylineMerchantAccessKey);
        this.setPaylineContractNumber(paylineContractNumber);
        this.checkRules();
    }

    public void delete() {
        super.delete();
        super.deleteDomainObject();
    }

    public static String getReturnURL(ForwardPaymentRequest forwardPayment, String returnControllerURL) {
        return String.format("%s%s/%s/%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), returnControllerURL, forwardPayment.getExternalId(), ACTION_RETURN_URL, forwardPayment.getReturnForwardPaymentUrlChecksum());
    }

    private void saveReturnUrlChecksum(ForwardPaymentRequest forwardPayment, String returnControllerURL, HttpSession session) {
        String returnUrlToChecksum = String.format("%s%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), returnControllerURL, forwardPayment.getExternalId());
        String urlChecksum = GenericChecksumRewriter.calculateChecksum((String)returnUrlToChecksum, (HttpSession)session);
        forwardPayment.setReturnForwardPaymentUrlChecksum(urlChecksum);
    }

    public static String getCancelURL(ForwardPaymentRequest forwardPayment, String returnControllerURL) {
        return String.format("%s%s/%s/%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), returnControllerURL, forwardPayment.getExternalId(), ACTION_CANCEL_URL, forwardPayment.getReturnForwardPaymentUrlChecksum());
    }

    public boolean isActionReturn(String action) {
        return ACTION_RETURN_URL.equals(action);
    }

    public boolean isActionCancel(String action) {
        return ACTION_CANCEL_URL.equals(action);
    }

    public boolean doWebPayment(ForwardPaymentRequest forwardPaymentRequest, String string, HttpSession httpSession) {
        return (Boolean)advice$doWebPayment.perform((Callable)new PaylineConfiguration$callable$doWebPayment(this, forwardPaymentRequest, string, httpSession));
    }

    static /* synthetic */ boolean advised$doWebPayment(PaylineConfiguration this_, ForwardPaymentRequest forwardPayment, String returnControllerURL, HttpSession session) {
        String cancelUrl;
        String returnUrl;
        if (!forwardPayment.getDigitalPaymentPlatform().isActive()) {
            throw new TreasuryDomainException("error.ForwardPaymentConfiguration.not.active", new String[0]);
        }
        if (session != null) {
            this_.saveReturnUrlChecksum(forwardPayment, returnControllerURL, session);
            returnUrl = PaylineConfiguration.getReturnURL(forwardPayment, returnControllerURL);
            cancelUrl = PaylineConfiguration.getCancelURL(forwardPayment, returnControllerURL);
        } else {
            returnUrl = forwardPayment.getForwardPaymentSuccessUrl();
            cancelUrl = forwardPayment.getForwardPaymentInsuccessUrl();
        }
        PaylineWebServiceResponse response = this_.paylineDoWebPayment(forwardPayment, returnUrl, cancelUrl);
        boolean success = TRANSACTION_APPROVED_CODE.equals(response.getResultCode());
        if (!success) {
            forwardPayment.reject("requestPayment", response.getResultCode(), response.getResultLongMessage(), response.getJsonRequest(), response.getJsonResponse());
            return false;
        }
        String code = response.getResultCode();
        String longMessage = response.getResultLongMessage();
        forwardPayment.advanceToRequestState("doWebPayment", code, longMessage, response.getJsonRequest(), response.getJsonResponse());
        forwardPayment.setCheckoutId(response.getToken());
        forwardPayment.setRedirectUrl(response.getRedirectURL());
        return true;
    }

    public boolean processPayment(ForwardPaymentRequest forwardPayment, String action) {
        if (!this.isActionReturn(action)) {
            PaylineWebServiceResponse response = this.paylineGetWebPaymentDetails(forwardPayment);
            String statusCode = response.getResultCode();
            String statusMessage = TreasuryConstants.treasuryBundle("label.PaylineImplementation.cancelled", new String[0]) + ": " + response.getResultLongMessage();
            this.reject(forwardPayment, action, statusCode, statusMessage, response.getJsonRequest(), response.getJsonResponse());
            return false;
        }
        PaylineWebServiceResponse response = this.paylineGetWebPaymentDetails(forwardPayment);
        String statusCode = response.getResultCode();
        String statusMessage = response.getResultLongMessage();
        boolean success = TRANSACTION_APPROVED_CODE.equals(statusCode);
        if (!success) {
            this.reject(forwardPayment, action, statusCode, statusMessage, response.getJsonRequest(), response.getJsonResponse());
            return false;
        }
        String transactionId = response.getTransactionId();
        String authorizationNumber = response.getAuthorizationNumber();
        DateTime transactionDate = response.getTransactionDate();
        BigDecimal paidAmount = response.getPaymentAmount();
        this.advanceToPaidState(forwardPayment, statusCode, statusMessage, paidAmount, transactionDate, transactionId, authorizationNumber, response.getJsonRequest(), response.getJsonResponse(), null);
        return true;
    }

    private PaymentRequestLog reject(ForwardPaymentRequest forwardPaymentRequest, String string, String string2, String string3, String string4, String string5) {
        return (PaymentRequestLog)((Object)advice$reject.perform((Callable)new PaylineConfiguration$callable$reject(this, forwardPaymentRequest, string, string2, string3, string4, string5)));
    }

    static /* synthetic */ PaymentRequestLog advised$reject(PaylineConfiguration this_, ForwardPaymentRequest forwardPayment, String operationCode, String statusCode, String errorMessage, String requestBody, String responseBody) {
        return forwardPayment.reject(operationCode, statusCode, errorMessage, requestBody, responseBody);
    }

    private PaymentRequestLog advanceToPaidState(ForwardPaymentRequest forwardPaymentRequest, String string, String string2, BigDecimal bigDecimal, DateTime dateTime, String string3, String string4, String string5, String string6, String string7) {
        return (PaymentRequestLog)((Object)advice$advanceToPaidState.perform((Callable)new PaylineConfiguration$callable$advanceToPaidState(this, forwardPaymentRequest, string, string2, bigDecimal, dateTime, string3, string4, string5, string6, string7)));
    }

    static /* synthetic */ PaymentRequestLog advised$advanceToPaidState(PaylineConfiguration this_, ForwardPaymentRequest forwardPayment, String statusCode, String statusMessage, BigDecimal paidAmount, DateTime transactionDate, String transactionId, String authorizationNumber, String requestBody, String responseBody, String justification) {
        return forwardPayment.advanceToPaidState(statusCode, statusMessage, paidAmount, transactionDate, transactionId, authorizationNumber, requestBody, responseBody, null);
    }

    public int getMaximumLengthForAddressStreetFieldOne() {
        return 50;
    }

    public int getMaximumLengthForAddressCity() {
        return 50;
    }

    public int getMaximumLengthForPostalCode() {
        return 16;
    }

    public static PaylineConfiguration create(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active, String paymentURL, String paylineMerchantId, String paylineMerchantAccessKey, String paylineContractNumber) {
        return new PaylineConfiguration(finantialInstitution, finantialEntity, name, active, paymentURL, paylineMerchantId, paylineMerchantAccessKey, paylineContractNumber);
    }

    public static String getPresentationName() {
        return TreasuryConstants.treasuryBundle("label.PaylineConfiguration.presentationName", new String[0]);
    }

    @Override
    public ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean bean, Function<ForwardPaymentRequest, String> successUrlFunction, Function<ForwardPaymentRequest, String> insuccessUrlFunction) {
        Set<DebitEntry> debitEntries = bean.getIncludedInvoiceEntryBeans().stream().map(ISettlementInvoiceEntryBean::getInvoiceEntry).filter(i -> i != null).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = bean.getIncludedInvoiceEntryBeans().stream().filter(i -> i instanceof InstallmentPaymenPlanBean && i.isIncluded()).map(InstallmentPaymenPlanBean.class::cast).map(ib -> ib.getInstallment()).collect(Collectors.toSet());
        ForwardPaymentRequest forwardPaymentRequest = this.createForwardPaymentRequest(bean, successUrlFunction, insuccessUrlFunction, debitEntries, installments);
        this.doWebPayment(forwardPaymentRequest, null, null);
        return forwardPaymentRequest;
    }

    private ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean settlementNoteBean, Function<ForwardPaymentRequest, String> function, Function<ForwardPaymentRequest, String> function2, Set<DebitEntry> set, Set<Installment> set2) {
        return (ForwardPaymentRequest)((Object)advice$createForwardPaymentRequest.perform((Callable)new PaylineConfiguration$callable$createForwardPaymentRequest(this, settlementNoteBean, function, function2, set, set2)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ ForwardPaymentRequest advised$createForwardPaymentRequest(PaylineConfiguration this_, SettlementNoteBean bean, Function successUrlFunction, Function insuccessUrlFunction, Set debitEntries, Set installments) {
        ForwardPaymentRequest forwardPaymentRequest = ForwardPaymentRequest.create(bean.getDigitalPaymentPlatform(), bean.getDebtAccount(), debitEntries, installments, bean.getTotalAmountToPay(), successUrlFunction, insuccessUrlFunction);
        return forwardPaymentRequest;
    }

    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String merchantTransationId) {
        return Collections.emptyList();
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPayment(ForwardPaymentRequest forwardPayment) {
        return this.postProcessPayment(forwardPayment, "", null);
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPaymentFromWebhook(PaymentRequestLog log2, DigitalPlatformResultBean bean) {
        throw new RuntimeException("not implemented");
    }

    private PaylineWebServiceResponse paylineGetWebPaymentDetails(ForwardPaymentRequest forwardPaymentRequest) {
        DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm");
        GetWebPaymentDetailsRequest request = new GetWebPaymentDetailsRequest();
        request.setToken(forwardPaymentRequest.getCheckoutId());
        GetWebPaymentDetailsResponse response = ((WebPaymentAPI)new PaylineWebServiceClient().getClient()).getWebPaymentDetails(request);
        PaylineWebServiceResponse result = new PaylineWebServiceResponse();
        if (response.getResult() != null) {
            result.setResultCode(response.getResult().getCode());
            result.setResultLongMessage(response.getResult().getLongMessage());
        }
        if (response.getAuthorization() != null) {
            result.setAuthorizationNumber(response.getAuthorization().getNumber());
        }
        if (response.getAuthorization() != null && !Strings.isNullOrEmpty((String)response.getAuthorization().getDate())) {
            result.setAuthorizationDate(DATE_TIME_PATTERN.parseDateTime(response.getAuthorization().getDate()));
        }
        if (response.getPayment() != null && !Strings.isNullOrEmpty((String)response.getPayment().getAmount())) {
            result.setPaymentAmount(new BigDecimal(response.getPayment().getAmount()).divide(new BigDecimal("100")));
        }
        if (response.getTransaction() != null) {
            result.setTransactionId(response.getTransaction().getId());
        }
        if (response.getTransaction() != null && !Strings.isNullOrEmpty((String)response.getTransaction().getDate())) {
            result.setTransactionDate(DATE_TIME_PATTERN.parseDateTime(response.getTransaction().getDate()));
        }
        result.setJsonRequest(TreasuryConstants.json(request));
        result.setJsonResponse(TreasuryConstants.json(response));
        return result;
    }

    private PaylineWebServiceResponse paylineDoWebPayment(ForwardPaymentRequest forwardPaymentRequest, String returnUrl, String cancelUrl) {
        int PAYLINE_MAX_PHONE_SIZE = 14;
        DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm");
        String SECURITY_MODE = "SSL";
        String PT = "PT";
        String EURO_CURRENCY = "978";
        String ACTION_AUTHORIZATION_AND_VALIDATION = "101";
        String MODE_CPT = "CPT";
        String TRANSACTION_APPROVED_CODE = TRANSACTION_APPROVED_CODE;
        String TRANSACTION_PENDING_FORM_FILL = TRANSACTION_PENDING_FORM_FILL;
        String ACTION_RETURN_URL = ACTION_RETURN_URL;
        String ACTION_CANCEL_URL = ACTION_CANCEL_URL;
        String LANG_PT = LANG_PT;
        String LANG_EN = LANG_EN;
        String formattedAmount = forwardPaymentRequest.getPayableAmount().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_EVEN).toString();
        Payment paymentDetails = new Payment();
        paymentDetails.setAmount(formattedAmount);
        paymentDetails.setCurrency("978");
        paymentDetails.setAction("101");
        paymentDetails.setMode("CPT");
        paymentDetails.setContractNumber(((PaylineConfiguration)((Object)forwardPaymentRequest.getDigitalPaymentPlatform())).getPaylineContractNumber());
        Order order = new Order();
        order.setRef(String.valueOf(forwardPaymentRequest.getOrderNumber()));
        order.setAmount(formattedAmount);
        order.setCurrency("978");
        order.setDate(FenixEDUTreasuryPlatformDependentServices.getVersioningCreationDate(forwardPaymentRequest).toString("dd/MM/yyyy HH:mm"));
        order.setCountry("PT");
        Customer customer = forwardPaymentRequest.getDebtAccount().getCustomer();
        Buyer buyerDetails = new Buyer();
        buyerDetails.setFirstName(customer.getFirstNames());
        buyerDetails.setLastName(customer.getLastNames());
        if (!Strings.isNullOrEmpty((String)customer.getEmail()) && EmailValidator.getInstance().isValid(customer.getEmail())) {
            buyerDetails.setEmail(customer.getEmail());
        }
        if (!Strings.isNullOrEmpty((String)customer.getPhoneNumber())) {
            String phone = customer.getPhoneNumber().replaceAll("[^\\d]", "");
            if (phone.length() > 14) {
                phone = phone.substring(0, 14);
            }
            buyerDetails.setMobilePhone(phone);
        }
        DoWebPaymentRequest request = new DoWebPaymentRequest();
        request.setPayment(paymentDetails);
        request.setOrder(order);
        request.setReturnURL(returnUrl);
        request.setCancelURL(cancelUrl);
        String languageToUse = LANG_EN.equals(I18N.getLocale().getLanguage()) ? LANG_EN : LANG_PT;
        request.setLanguageCode(languageToUse);
        request.setBuyer(buyerDetails);
        request.setSecurityMode("SSL");
        DoWebPaymentResponse response = ((WebPaymentAPI)new PaylineWebServiceClient().getClient()).doWebPayment(request);
        PaylineWebServiceResponse result = new PaylineWebServiceResponse();
        if (response.getResult() != null) {
            result.setResultCode(response.getResult().getCode());
            result.setResultLongMessage(response.getResult().getLongMessage());
        }
        result.setToken(response.getToken());
        result.setRedirectURL(response.getRedirectURL());
        result.setJsonRequest(TreasuryConstants.json(request));
        result.setJsonResponse(TreasuryConstants.json(response));
        return result;
    }

    private void fillAddress(Customer customer, Buyer buyerDetails) {
        Address address = new Address();
        address.setStreet1(customer.getAddress());
        address.setZipCode(customer.getZipCode());
        address.setCountry(customer.getAddressCountryCode());
        buyerDetails.setShippingAdress(address);
    }

    private void fillOrderDetails(ForwardPaymentRequest forwardPayment, Order order) {
        Currency currency = forwardPayment.getDebtAccount().getFinantialInstitution().getCurrency();
        Details details = new Details();
        for (DebitEntry debitEntry : forwardPayment.getDebitEntriesSet()) {
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setRef(debitEntry.getExternalId());
            orderDetail.setPrice(Currency.getValueWithScale(debitEntry.getOpenAmount()).multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_EVEN).toString());
            orderDetail.setQuantity("1");
            orderDetail.setComment(debitEntry.getDescription());
            details.getDetails().add(orderDetail);
        }
        order.setDetails(details);
    }
}

