/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.exceptions;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class TreasuryDomainException
extends RuntimeException {
    private final String key;
    private final String[] args;
    private final String bundle;
    private final Response.Status status;
    private static final long serialVersionUID = 1L;

    protected TreasuryDomainException(String bundle, String key, String ... args) {
        this(Response.Status.PRECONDITION_FAILED, bundle, key, args);
    }

    protected TreasuryDomainException(Response.Status status, String bundle, String key, String ... args) {
        super(key);
        this.status = status;
        this.bundle = bundle;
        this.key = key;
        this.args = args;
    }

    protected TreasuryDomainException(Throwable cause, String bundle, String key, String ... args) {
        this(cause, Response.Status.INTERNAL_SERVER_ERROR, bundle, key, args);
    }

    protected TreasuryDomainException(Throwable cause, Response.Status status, String bundle, String key, String ... args) {
        super(key, cause);
        this.status = status;
        this.bundle = bundle;
        this.key = key;
        this.args = args;
    }

    @Override
    public String getLocalizedMessage() {
        return BundleUtil.getString((String)this.bundle, (String)this.key, (String[])this.args);
    }

    public Response.Status getResponseStatus() {
        return this.status;
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("message", this.getLocalizedMessage());
        return json;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getArgs() {
        return this.args;
    }

    public TreasuryDomainException(String key, String ... args) {
        this("resources.FenixeduTreasuryResources", key, args);
    }

    public TreasuryDomainException(Response.Status status, String key, String ... args) {
        this(status, "resources.FenixeduTreasuryResources", key, args);
    }

    public TreasuryDomainException(Throwable cause, String key, String ... args) {
        this(cause, "resources.FenixeduTreasuryResources", key, args);
    }

    public TreasuryDomainException(Throwable cause, Response.Status status, String key, String ... args) {
        this(cause, status, "resources.FenixeduTreasuryResources", key, args);
    }

    public static void throwWhenDeleteBlocked(Collection<String> blockers) {
        if (!blockers.isEmpty()) {
            throw new TreasuryDomainException("key.return.argument", blockers.stream().collect(Collectors.joining(", ")));
        }
    }
}

