/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.TreasuryOperationLog$callable$create;
import org.fenixedu.treasury.domain.TreasuryOperationLog$callable$delete;
import org.fenixedu.treasury.domain.TreasuryOperationLog$callable$edit;
import org.fenixedu.treasury.domain.TreasuryOperationLog_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.services.integration.FenixEDUTreasuryPlatformDependentServices;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryOperationLog
extends TreasuryOperationLog_Base {
    public static Comparator<TreasuryOperationLog> COMPARATOR_BY_CREATION_DATE;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected TreasuryOperationLog() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TreasuryOperationLog(String log2, String oid, String type) {
        this();
        this.init(log2, oid, type);
    }

    protected void init(String log2, String oid, String type) {
        this.setLog(log2);
        this.setDomainOid(oid);
        this.setType(type);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void edit(String string, String string2, String string3) {
        Object object = advice$edit.perform((Callable)new TreasuryOperationLog$callable$edit(this, string, string2, string3));
    }

    static /* synthetic */ void advised$edit(TreasuryOperationLog this_, String log2, String oid, String type) {
        this_.setLog(log2);
        this_.setDomainOid(oid);
        this_.setType(type);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryOperationLog$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryOperationLog this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static TreasuryOperationLog create(String string, String string2, String string3) {
        return (TreasuryOperationLog)((Object)advice$create.perform((Callable)new TreasuryOperationLog$callable$create(string, string2, string3)));
    }

    static /* synthetic */ TreasuryOperationLog advised$create(String log2, String oid, String type) {
        return new TreasuryOperationLog(log2, oid, type);
    }

    public static Stream<TreasuryOperationLog> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryOperationLogsSet().stream();
    }

    public static Stream<TreasuryOperationLog> findByLog(String log2) {
        return TreasuryOperationLog.findAll().filter(i -> log2.equalsIgnoreCase(i.getLog()));
    }

    public static Stream<TreasuryOperationLog> findByOid(String oid) {
        return TreasuryOperationLog.findAll().filter(i -> oid.equalsIgnoreCase(i.getDomainOid()));
    }

    public static Stream<TreasuryOperationLog> findByType(String type) {
        return TreasuryOperationLog.findAll().filter(i -> type.equalsIgnoreCase(i.getType()));
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_CREATION_DATE = new Comparator<TreasuryOperationLog>(){

            @Override
            public int compare(TreasuryOperationLog o1, TreasuryOperationLog o2) {
                DateTime o2CreationDate;
                DateTime o1CreationDate = FenixEDUTreasuryPlatformDependentServices.getVersioningCreationDate(o1);
                if (o1CreationDate.isBefore((ReadableInstant)(o2CreationDate = FenixEDUTreasuryPlatformDependentServices.getVersioningCreationDate(o2)))) {
                    return -1;
                }
                if (o1CreationDate.isEqual((ReadableInstant)o2CreationDate)) {
                    return 0;
                }
                return 1;
            }
        };
    }
}

