/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalMonth_Base;
import org.fenixedu.treasury.domain.FiscalYear;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.fenixframework.FenixFramework;

public class FiscalMonth
extends FiscalMonth_Base {
    public FiscalMonth() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public FiscalMonth(FiscalYear fiscalYear, int month) {
        this();
        super.setFiscalYear(fiscalYear);
        super.setMonth(month);
        Boolean fiscalOperationsClosed = this.isFiscalExerciseExpired(new LocalDate());
        super.setFiscalOperationsClosed(fiscalOperationsClosed);
        if (fiscalOperationsClosed.booleanValue()) {
            String loggedUsername = TreasuryConstants.getAuthenticatedUsername();
            super.setFiscalOperationsClosedResponsible(loggedUsername);
            super.setFiscalOperationsClosedSetDate(new DateTime());
        }
        this.checkRules();
    }

    public boolean isFiscalExerciseExpired() {
        return this.isFiscalExerciseExpired(new LocalDate());
    }

    public boolean isFiscalExerciseExpired(LocalDate localDate) {
        LocalDate endDayOfMonthDate = new LocalDate(this.getFiscalYear().getYear(), this.getMonth(), 1).plusMonths(1).minusDays(1);
        return endDayOfMonthDate.isBefore((ReadablePartial)localDate);
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.FiscalMonth.domainRoot.required", new String[0]);
        }
        if (this.getFiscalYear() == null) {
            throw new TreasuryDomainException("error.FiscalMonth.fiscalYear.required", new String[0]);
        }
        if (this.getMonth() < 1 || this.getMonth() > 12) {
            throw new TreasuryDomainException("error.FiscalMonth.month.invalid", new String[0]);
        }
        if (FiscalMonth.find(this.getFiscalYear(), this.getMonth()).count() > 1L) {
            throw new TreasuryDomainException("error.FiscalMonth.year.month.duplicated", new String[0]);
        }
    }

    public void closeOperations() {
        super.setFiscalOperationsClosed(Boolean.valueOf(true));
        String loggedUsername = TreasuryConstants.getAuthenticatedUsername();
        super.setFiscalOperationsClosedResponsible(loggedUsername);
        super.setFiscalOperationsClosedSetDate(new DateTime());
    }

    public static Stream<FiscalMonth> findAll() {
        return FenixFramework.getDomainRoot().getFiscalMonthsSet().stream();
    }

    public static Stream<FiscalMonth> find(FiscalYear fiscalYear) {
        return FiscalMonth.findAll().filter(f -> f.getFiscalYear() == fiscalYear);
    }

    public static Stream<FiscalMonth> find(FiscalYear fiscalYear, int month) {
        return FiscalMonth.find(fiscalYear).filter(f -> f.getMonth() == month);
    }

    public static Optional<FiscalMonth> findUnique(FiscalYear fiscalYear, int month) {
        return FiscalMonth.find(fiscalYear, month).findFirst();
    }

    public static boolean isFiscalOperationsOpenNow(FinantialInstitution finantialInstitution) {
        LocalDate now = new LocalDate();
        return FiscalMonth.isFiscalOperationsOpen(finantialInstitution, now.getYear(), now.getMonthOfYear());
    }

    public static boolean isFiscalOperationsOpen(FinantialInstitution finantialInstitution, int year, int month) {
        if (!FiscalYear.findUnique(finantialInstitution, year).isPresent()) {
            return false;
        }
        FiscalYear fiscalYear = FiscalYear.findUnique(finantialInstitution, year).get();
        if (!FiscalMonth.findUnique(fiscalYear, month).isPresent()) {
            return false;
        }
        return !Boolean.TRUE.equals(FiscalMonth.findUnique(fiscalYear, month).get().getFiscalOperationsClosed());
    }

    public static boolean isFiscalOperationsClosed(FinantialInstitution finantialInstitution, int year, int month) {
        if (!FiscalYear.findUnique(finantialInstitution, year).isPresent()) {
            return false;
        }
        FiscalYear fiscalYear = FiscalYear.findUnique(finantialInstitution, year).get();
        if (!FiscalMonth.findUnique(fiscalYear, month).isPresent()) {
            return false;
        }
        return Boolean.TRUE.equals(FiscalMonth.findUnique(fiscalYear, month).get().getFiscalOperationsClosed());
    }

    public static FiscalMonth create(FiscalYear fiscalYear, int month) {
        return new FiscalMonth(fiscalYear, month);
    }

    public static FiscalMonth getOrCreateFiscalMonth(FiscalYear fiscalYear, int month) {
        return FiscalMonth.findUnique(fiscalYear, month).orElseGet(() -> FiscalMonth.create(fiscalYear, month));
    }
}

