/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;

public class CreditEntryBean
implements ITreasuryBean {
    private Vat vat;
    private List<TreasuryTupleDataSourceBean> vatDataSource;
    private Product product;
    private List<TreasuryTupleDataSourceBean> productDataSource;
    private DebtAccount debtAccount;
    private List<TreasuryTupleDataSourceBean> debtAccountDataSource;
    private Currency currency;
    private List<TreasuryTupleDataSourceBean> currencyDataSource;
    private CreditNote finantialDocument;
    private boolean eventAnnuled;
    private String description;
    private BigDecimal amount;
    private BigDecimal quantity;
    private Tariff tariff;

    public Vat getVat() {
        return this.vat;
    }

    public void setVat(Vat value) {
        this.vat = value;
    }

    public List<TreasuryTupleDataSourceBean> getVatDataSource() {
        return this.vatDataSource;
    }

    public void setVatDataSource(List<Vat> value) {
        this.vatDataSource = value.stream().map(x -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.toString());
            return tuple;
        }).collect(Collectors.toList());
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product value) {
        this.product = value;
    }

    public List<TreasuryTupleDataSourceBean> getProductDataSource() {
        return this.productDataSource;
    }

    public void setProductDataSource(List<Product> value) {
        this.productDataSource = value.stream().map(x -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.getName().getContent());
            return tuple;
        }).collect(Collectors.toList());
    }

    public DebtAccount getDebtAccount() {
        return this.debtAccount;
    }

    public void setDebtAccount(DebtAccount value) {
        this.debtAccount = value;
    }

    public List<TreasuryTupleDataSourceBean> getDebtAccountDataSource() {
        return this.debtAccountDataSource;
    }

    public void setDebtAccountDataSource(List<DebtAccount> value) {
        this.debtAccountDataSource = value.stream().map(x -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.toString());
            return tuple;
        }).collect(Collectors.toList());
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency value) {
        this.currency = value;
    }

    public List<TreasuryTupleDataSourceBean> getCurrencyDataSource() {
        return this.currencyDataSource;
    }

    public void setCurrencyDataSource(List<Currency> value) {
        this.currencyDataSource = value.stream().map(x -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.toString());
            return tuple;
        }).collect(Collectors.toList());
    }

    public CreditNote getFinantialDocument() {
        return this.finantialDocument;
    }

    public void setFinantialDocument(CreditNote value) {
        this.finantialDocument = value;
    }

    public boolean getEventAnnuled() {
        return this.eventAnnuled;
    }

    public void setEventAnnuled(boolean value) {
        this.eventAnnuled = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal value) {
        this.quantity = value;
    }

    public CreditEntryBean() {
        this.setQuantity(BigDecimal.ONE);
        this.setAmount(BigDecimal.ZERO);
    }

    public CreditEntryBean(CreditEntry creditEntry) {
        this();
        this.setVat(creditEntry.getVat());
        this.setProduct(creditEntry.getProduct());
        this.setDebtAccount(creditEntry.getDebtAccount());
        this.setCurrency(creditEntry.getCurrency());
        this.setFinantialDocument((CreditNote)((Object)creditEntry.getFinantialDocument()));
        this.setDescription(creditEntry.getDescription());
        this.setAmount(creditEntry.getAmount());
        this.setQuantity(creditEntry.getQuantity());
        this.setDescription(creditEntry.getDescription());
        this.setAmount(creditEntry.getAmount());
        this.setQuantity(creditEntry.getQuantity());
    }

    public Tariff getTariff() {
        return this.tariff;
    }

    public void setTariff(Tariff tariff) {
        this.tariff = tariff;
    }
}

