/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibsonlinepaymentsgateway;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGatewayLog_Base;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

@Deprecated
public class SibsOnlinePaymentsGatewayLog
extends SibsOnlinePaymentsGatewayLog_Base {
    public static final String REQUEST_PAYMENT_CODE = "REQUEST_PAYMENT_CODE";
    public static final String WEBHOOK_NOTIFICATION = "WEBHOOK_NOTIFICATION";

    public SibsOnlinePaymentsGatewayLog() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected SibsOnlinePaymentsGatewayLog(String operationCode) {
        this();
        this.setCreationDate(new DateTime());
        this.setResponsibleUsername(TreasuryConstants.getAuthenticatedUsername());
        this.setOperationCode(operationCode);
    }

    protected SibsOnlinePaymentsGatewayLog(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, String operationCode, DebtAccount debtAccount) {
        this();
        this.setCreationDate(new DateTime());
        this.setResponsibleUsername(TreasuryConstants.getAuthenticatedUsername());
        this.setSibsOnlinePaymentsGateway(sibsOnlinePaymentsGateway);
        this.setOperationCode(operationCode);
        this.setDebtAccount(debtAccount);
        this.setCustomerFiscalNumber(debtAccount.getCustomer().getUiFiscalNumber());
        this.setCustomerName(debtAccount.getCustomer().getName());
        this.setCustomerBusinessIdentification(debtAccount.getCustomer().getBusinessIdentification());
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayLog.domainRoot.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getOperationCode())) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayLog.operationCode.required", new String[0]);
        }
        if (REQUEST_PAYMENT_CODE.equals(this.getOperationCode())) {
            if (this.getSibsOnlinePaymentsGateway() == null) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayLog.sibsOnlinePaymentsGateway.required", new String[0]);
            }
            if (this.getDebtAccount() == null) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayLog.debtAccount.required", new String[0]);
            }
        }
    }

    public boolean isExceptionOccured() {
        return super.getExceptionOccured();
    }

    public boolean isOperationSuccess() {
        return super.getOperationSuccess();
    }

    public void logRequestSendDate() {
        this.setRequestSendDate(new DateTime());
    }

    public void logRequestReceiveDateAndData(String transactionId, boolean operationSuccess, boolean transactionPaid, String operationResultCode, String operationResultDescription) {
        this.setRequestReceiveDate(new DateTime());
        this.setTransactionId(transactionId);
        this.setOperationSuccess(operationSuccess);
        this.setTransactionPaid(transactionPaid);
        this.setOperationResultCode(operationResultCode);
        this.setOperationResultDescription(operationResultDescription);
    }

    public void saveRequestAndResponsePayload(String requestPayload, String responsePayload) {
        ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
        if (requestPayload != null) {
            String requestPayloadFileId = implementation.createFile(String.format("sibsOnlinePaymentsGatewayLog-requestPayload-%s.txt", this.getExternalId()), "application/octet-stream", requestPayload.getBytes());
            this.setRequestPayloadFileId(requestPayloadFileId);
        }
        if (responsePayload != null) {
            String responsePayloadFileId = implementation.createFile(String.format("sibsOnlinePaymentsGatewayLog-responsePayload-%s.txt", this.getExternalId()), "application/octet-stream", responsePayload.getBytes());
            this.setResponsePayloadFileId(responsePayloadFileId);
        }
    }

    public void markExceptionOccuredAndSaveLog(Exception e) {
        ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
        String exceptionLog = String.format("%s\n%s", e.getLocalizedMessage(), ExceptionUtils.getFullStackTrace((Throwable)e));
        this.setExceptionOccured(true);
        String exceptionLogFileId = implementation.createFile(String.format("sibsOnlinePaymentsGatewayLog-exception-%s.txt", this.getExternalId()), "application/octet-stream", exceptionLog.getBytes());
        this.setExceptionLogFileId(exceptionLogFileId);
    }

    public void savePaymentCode(String paymentCode) {
        this.setPaymentCode(paymentCode);
    }

    public void saveMerchantTransactionId(String merchantTransactionId) {
        this.setMerchantTransactionId(merchantTransactionId);
    }

    public void saveReferenceId(String referenceId) {
        this.setReferenceId(referenceId);
    }

    public void saveWebhookNotificationData(String notificationInitializationVector, String notificationAuthenticationTag, String notificationEncryptedPayload) {
        ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
        this.setNotificationInitializationVector(notificationInitializationVector);
        this.setNotificationAuthTag(notificationAuthenticationTag);
        if (notificationEncryptedPayload != null) {
            String notificationEncryptedPayloadFileId = implementation.createFile(String.format("sibsOnlinePaymentsGatewayLog-notificationEncryptedPayload-%s.txt", this.getExternalId()), "application/octet-stream", notificationEncryptedPayload.getBytes());
            this.setNotificationEncryptedPayloadFileId(notificationEncryptedPayloadFileId);
        }
    }

    public void associateSibsOnlinePaymentGatewayAndDebtAccount(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount) {
        this.setSibsOnlinePaymentsGateway(sibsOnlinePaymentsGateway);
        this.setDebtAccount(debtAccount);
    }

    public void savePaymentInfo(BigDecimal amount, DateTime paymentDate) {
        this.setAmount(amount);
        this.setPaymentDate(paymentDate);
    }

    public void savePaymentTypeAndBrand(String paymentType, String paymentBrand) {
        this.setPaymentType(paymentType);
        this.setPaymentBrand(paymentBrand);
    }

    public void markAsDuplicatedTransaction() {
        this.setSibsTransactionDuplicated(true);
    }

    public void markSettlementNotesCreated(Set<SettlementNote> settlementNotes) {
        String settlementNotesNumber = String.join((CharSequence)";", settlementNotes.stream().map(FinantialDocument::getUiDocumentNumber).collect(Collectors.toSet()));
        this.setSettlementNoteNumbers(settlementNotesNumber);
    }

    public static Stream<SibsOnlinePaymentsGatewayLog> findAll() {
        return FenixFramework.getDomainRoot().getSibsOnlinePaymentsGatewayLogsSet().stream();
    }

    public static SibsOnlinePaymentsGatewayLog createLogForRequestPaymentCode(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount) {
        return new SibsOnlinePaymentsGatewayLog(sibsOnlinePaymentsGateway, REQUEST_PAYMENT_CODE, debtAccount);
    }

    public static SibsOnlinePaymentsGatewayLog createLogForWebhookNotification() {
        return new SibsOnlinePaymentsGatewayLog(WEBHOOK_NOTIFICATION);
    }
}

