/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.settings.TreasurySettings;

public enum DueDateCalculationType {
    NO_DUE_DATE,
    FIXED_DATE,
    DAYS_AFTER_CREATION,
    BEST_OF_FIXED_DATE_AND_DAYS_AFTER_CREATION;


    public boolean isFixedDate() {
        return this == FIXED_DATE;
    }

    public boolean isNoDueDate() {
        return this == NO_DUE_DATE;
    }

    public boolean isDaysAfterCreation() {
        return this == DAYS_AFTER_CREATION;
    }

    public boolean isBestOfFixedDateAndDaysAfterCreation() {
        return this == BEST_OF_FIXED_DATE_AND_DAYS_AFTER_CREATION;
    }

    public LocalizedString getDescriptionI18N() {
        return TreasurySettings.GET_DUE_DATE_CALCULATION_TYPE_DAYS_AFTER_CREATION_LABEL(this);
    }
}

