/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.payments;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalMonth;
import org.fenixedu.treasury.domain.FiscalYear;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLogFile;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog_Base;
import org.fenixedu.treasury.domain.sibspay.MbwayMandate;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class PaymentRequestLog
extends PaymentRequestLog_Base {
    public static final String OCTECT_STREAM_CONTENT_TYPE = "application/octet-stream";
    public static final Comparator<PaymentRequestLog> COMPARE_BY_CREATION_DATE = Comparator.comparing(PaymentRequestLog_Base::getCreationDate).thenComparing(AbstractDomainObject::getExternalId);

    public PaymentRequestLog() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
        this.setResponsibleUsername(TreasuryConstants.getAuthenticatedUsername());
        FinantialInstitution finantialInstitution = (FinantialInstitution)((Object)FinantialInstitution.findAll().iterator().next());
        int year = this.getCreationDate().getYear();
        int monthOfYear = this.getCreationDate().getMonthOfYear();
        FiscalYear fiscalYear = FiscalYear.getOrCreateFiscalYear(finantialInstitution, year);
        FiscalMonth fiscalMonth = FiscalMonth.getOrCreateFiscalMonth(fiscalYear, monthOfYear);
        this.setFiscalMonth(fiscalMonth);
    }

    protected PaymentRequestLog(PaymentRequest request, String operationCode, String stateCode, LocalizedString stateDescription) {
        this();
        this.setPaymentRequest(request);
        this.setOperationCode(operationCode);
        this.setStateCode(stateCode);
        this.setStateDescription(stateDescription);
        if (request != null) {
            FinantialInstitution finantialInstitution = request.getDebtAccount().getFinantialInstitution();
            int year = this.getCreationDate().getYear();
            int monthOfYear = this.getCreationDate().getMonthOfYear();
            FiscalYear fiscalYear = FiscalYear.getOrCreateFiscalYear(finantialInstitution, year);
            FiscalMonth fiscalMonth = FiscalMonth.getOrCreateFiscalMonth(fiscalYear, monthOfYear);
            this.setFiscalMonth(fiscalMonth);
        }
    }

    protected PaymentRequestLog(MbwayMandate mbwayMandate, String operationCode, String stateCode, LocalizedString stateDescription) {
        this();
        this.setMbwayMandate(mbwayMandate);
        this.setOperationCode(operationCode);
        this.setStateCode(stateCode);
        this.setStateDescription(stateDescription);
    }

    public PaymentRequestLog(String webhookNotification) {
        this();
        this.setOperationCode(webhookNotification);
    }

    public void saveRequest(String requestBody) {
        if (requestBody == null) {
            return;
        }
        try {
            String filename = String.format("request_%s_%s.txt", new DateTime().toString("yyyyMMddHHmmss"), this.getExternalId());
            this.setRequestLogFile(PaymentRequestLogFile.create(filename, requestBody.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveResponse(String responseBody) {
        if (responseBody == null) {
            return;
        }
        try {
            String filename = String.format("response_%s_%s.txt", new DateTime().toString("yyyyMMddHHmmss"), this.getExternalId());
            this.setResponseLogFile(PaymentRequestLogFile.create(filename, responseBody.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void logException(Exception e) {
        String exceptionLog = String.format("%s\n%s", e.getLocalizedMessage(), ExceptionUtils.getFullStackTrace((Throwable)e));
        this.setExceptionOccured(true);
        this.setOperationSuccess(false);
        try {
            String filename = String.format("exception_%s_%s.txt", new DateTime().toString("yyyyMMddHHmmss"), this.getExternalId());
            this.setExceptionLogFile(PaymentRequestLogFile.create(filename, exceptionLog.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void editAuthorizationData(String authorizationId, DateTime authorizationDate) {
        this.setAuthorizationId(authorizationId);
        this.setAuthorizationDate(authorizationDate);
    }

    public void logRequestSendDate() {
        this.setRequestSendDate(new DateTime());
    }

    public void markAsDuplicatedTransaction() {
        this.setTransactionDuplicated(true);
    }

    public void savePaymentInfo(BigDecimal amount, DateTime paymentDate) {
        this.setAmount(amount);
        this.setPaymentDate(paymentDate);
    }

    public void savePaymentTypeAndBrand(String paymentType, String paymentBrand) {
        this.setPaymentType(paymentType);
        this.setPaymentBrand(paymentBrand);
    }

    public void logRequestReceiveDateAndData(String transactionId, boolean operationSuccess, boolean transactionPaid, String operationResultCode, String operationResultDescription) {
        this.setRequestReceiveDate(new DateTime());
        this.setExternalTransactionId(transactionId);
        this.setOperationSuccess(operationSuccess);
        this.setTransactionWithPayment(transactionPaid);
        this.setStatusCode(operationResultCode);
        this.setStatusMessage(operationResultDescription);
    }

    public void saveWebhookNotificationData(String notificationInitializationVector, String notificationAuthenticationTag, String notificationEncryptedPayload) {
        ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
        this.setNotificationInitializationVector(notificationInitializationVector);
        this.setNotificationAuthTag(notificationAuthenticationTag);
        if (notificationEncryptedPayload != null) {
            String notificationEncryptedPayloadFileId = implementation.createFile(String.format("sibsOnlinePaymentsGatewayLog-notificationEncryptedPayload-%s.txt", this.getExternalId()), OCTECT_STREAM_CONTENT_TYPE, notificationEncryptedPayload.getBytes());
            this.setNotificationEncryptedPayloadFileId(notificationEncryptedPayloadFileId);
        }
    }

    public void setPaymentRequest(PaymentRequest paymentRequest) {
        super.setPaymentRequest(paymentRequest);
        if (paymentRequest != null) {
            FinantialInstitution finantialInstitution = paymentRequest.getDebtAccount().getFinantialInstitution();
            int year = this.getCreationDate().getYear();
            int monthOfYear = this.getCreationDate().getMonthOfYear();
            FiscalYear fiscalYear = FiscalYear.getOrCreateFiscalYear(finantialInstitution, year);
            FiscalMonth fiscalMonth = FiscalMonth.getOrCreateFiscalMonth(fiscalYear, monthOfYear);
            this.setFiscalMonth(fiscalMonth);
        }
    }

    public static Stream<? extends PaymentRequestLog> findAll() {
        return FenixFramework.getDomainRoot().getPaymentRequestLogsSet().stream();
    }

    public static PaymentRequestLog create(PaymentRequest request, String operationCode, String stateCode, LocalizedString stateDescription) {
        return new PaymentRequestLog(request, operationCode, stateCode, stateDescription);
    }

    public static PaymentRequestLog create(MbwayMandate mbwayMandate, String operationCode, String stateCode, LocalizedString stateDescription) {
        return new PaymentRequestLog(mbwayMandate, operationCode, stateCode, stateDescription);
    }
}

