/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.onlinepaymentsgateway.sibs.sdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.fenixedu.onlinepaymentsgateway.api.CustomerDataInputBean;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PaymentBrand;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PaymentType;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.SibsEnvironmentMode;

public class PrepareMBCheckout {
    private String entityId;
    private String amount;
    private String currency;
    private PaymentType paymentType;
    private String merchantTransactionId;
    private PaymentBrand paymentBrand;
    private CustomerDataInputBean customerInput;
    private String SIBSMULTIBANCO_PtmntEntty;
    private String SIBSMULTIBANCO_RefIntlDtTm;
    private String SIBSMULTIBANCO_RefLmtDtTm;
    private String billingCountry;
    private SibsEnvironmentMode environmentMode;

    public PrepareMBCheckout(String entityId, String amount, String currency, String paymentType, String paymentBrand, String sIBSMULTIBANCO_PtmntEntty, String sIBSMULTIBANCO_RefIntlDtTm, String sIBSMULTIBANCO_RefLmtDtTm, String billingCountry, CustomerDataInputBean customerInput, SibsEnvironmentMode environmentMode) {
        this.entityId = entityId;
        this.amount = amount;
        this.currency = currency;
        this.paymentType = PaymentType.valueOf(paymentType);
        this.paymentBrand = PaymentBrand.valueOf(paymentBrand);
        this.SIBSMULTIBANCO_PtmntEntty = sIBSMULTIBANCO_PtmntEntty;
        this.SIBSMULTIBANCO_RefIntlDtTm = sIBSMULTIBANCO_RefIntlDtTm;
        this.SIBSMULTIBANCO_RefLmtDtTm = sIBSMULTIBANCO_RefLmtDtTm;
        this.billingCountry = billingCountry;
        this.customerInput = customerInput;
        this.environmentMode = environmentMode;
    }

    public PrepareMBCheckout() {
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = PaymentType.valueOf(paymentType);
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public PaymentBrand getPaymentBrand() {
        return this.paymentBrand;
    }

    public void setPaymentBrand(String paymentBrand) {
        this.paymentBrand = PaymentBrand.valueOf(paymentBrand);
    }

    public CustomerDataInputBean getCustomerInput() {
        return this.customerInput;
    }

    public void setCustomerInputBean(CustomerDataInputBean customerInput) {
        this.customerInput = customerInput;
    }

    public String getSIBSMULTIBANCO_PtmntEntty() {
        return this.SIBSMULTIBANCO_PtmntEntty;
    }

    public void setSIBSMULTIBANCO_PtmntEntty(String sIBSMULTIBANCO_PtmntEntty) {
        this.SIBSMULTIBANCO_PtmntEntty = sIBSMULTIBANCO_PtmntEntty;
    }

    public String getSIBSMULTIBANCO_RefIntlDtTm() {
        return this.SIBSMULTIBANCO_RefIntlDtTm;
    }

    public void setSIBSMULTIBANCO_RefIntlDtTm(String sIBSMULTIBANCO_RefIntlDtTm) {
        this.SIBSMULTIBANCO_RefIntlDtTm = sIBSMULTIBANCO_RefIntlDtTm;
    }

    public String getSIBSMULTIBANCO_RefLmtDtTm() {
        return this.SIBSMULTIBANCO_RefLmtDtTm;
    }

    public void setSIBSMULTIBANCO_RefLmtDtTm(String sIBSMULTIBANCO_RefLmtDtTm) {
        this.SIBSMULTIBANCO_RefLmtDtTm = sIBSMULTIBANCO_RefLmtDtTm;
    }

    public String getBillingCountry() {
        return this.billingCountry;
    }

    public void setBillingCountry(String billingCountry) {
        this.billingCountry = billingCountry;
    }

    public SibsEnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(SibsEnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public MultivaluedMap<String, String> asMap() {
        MultivaluedHashMap form = new MultivaluedHashMap();
        form.add((Object)"entityId", (Object)this.entityId);
        form.add((Object)"amount", (Object)this.amount.toString());
        form.add((Object)"currency", (Object)this.currency);
        form.add((Object)"paymentType", (Object)this.paymentType.toString());
        form.add((Object)"paymentBrand", (Object)this.paymentBrand.toString());
        form.add((Object)"customParameters[SIBSMULTIBANCO_PtmntEntty]", (Object)this.SIBSMULTIBANCO_PtmntEntty);
        form.add((Object)"customParameters[SIBSMULTIBANCO_RefIntlDtTm]", (Object)this.SIBSMULTIBANCO_RefIntlDtTm);
        form.add((Object)"customParameters[SIBSMULTIBANCO_RefLmtDtTm]", (Object)this.SIBSMULTIBANCO_RefLmtDtTm);
        form.add((Object)"billing.country", (Object)this.billingCountry);
        if (this.environmentMode == SibsEnvironmentMode.TEST_MODE_EXTERNAL) {
            form.add((Object)"testMode", (Object)"EXTERNAL");
            form.add((Object)"customParameters[SIBS_ENV]", (Object)"QLY");
        } else if (this.environmentMode == SibsEnvironmentMode.TEST_MODE_INTERNAL) {
            form.add((Object)"testMode", (Object)"INTERNAL");
            form.add((Object)"customParameters[SIBS_ENV]", (Object)"QLY");
        } else if (this.environmentMode != SibsEnvironmentMode.PRODUCTION) {
            throw new RuntimeException("Unknow environment mode.");
        }
        if (this.merchantTransactionId != null) {
            form.add((Object)"merchantTransactionId", (Object)this.merchantTransactionId);
        }
        if (this.customerInput != null) {
            if (this.customerInput.getIp() != null) {
                form.add((Object)"customer.ip", (Object)this.customerInput.getIp());
            }
            if (this.customerInput.getSurname() != null) {
                form.add((Object)"customer.surname", (Object)this.customerInput.getSurname());
            }
            if (this.customerInput.getGivenName() != null) {
                form.add((Object)"customer.givenName", (Object)this.customerInput.getGivenName());
            }
        }
        return form;
    }

    public String toString() {
        MultivaluedMap<String, String> map = this.asMap();
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }
}

