/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.util.streaming.spreadsheet;

import com.qubit.terra.framework.tools.excel.ExcelUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;

public interface Spreadsheet {
    public static final int ROWS_IN_MEMORY = 100;

    public ExcelSheet[] getSheets();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] buildSpreadsheetContent(Spreadsheet spreadsheet, IErrorsLog errorsLog) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Spreadsheet.buildSpreadsheetContent(spreadsheet, errorsLog, output);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildSpreadsheetContent(Spreadsheet spreadsheet, IErrorsLog errorsLog, OutputStream outputStream) {
        Workbook wb = ExcelUtil.createLargeWorkbook((int)100);
        for (ExcelSheet sheet : spreadsheet.getSheets()) {
            Sheet sh = wb.createSheet(sheet.getName());
            Row row = sh.createRow(0);
            Font headerFont = wb.createFont();
            headerFont.setBold(true);
            if (row.getRowStyle() == null) {
                row.setRowStyle(wb.createCellStyle());
            }
            row.getRowStyle().setFont(headerFont);
            String[] headers = sheet.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(headers[i]);
            }
            sheet.getRows().forEach(r -> r.writeCellValues(sh.createRow(sh.getLastRowNum() + 1), errorsLog));
        }
        try {
            File tempFile = File.createTempFile("treasury-spreadsheet" + wb.hashCode() + "-" + System.currentTimeMillis(), ".xlsx");
            try (FileOutputStream output = new FileOutputStream(tempFile);){
                wb.write((OutputStream)output);
            }
            try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            }
            finally {
                tempFile.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

