/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.FinantialDocumentType$callable$createForCreditNote;
import org.fenixedu.treasury.domain.document.FinantialDocumentType$callable$createForDebitNote;
import org.fenixedu.treasury.domain.document.FinantialDocumentType$callable$createForReimbursementNote;
import org.fenixedu.treasury.domain.document.FinantialDocumentType$callable$createForSettlementNote;
import org.fenixedu.treasury.domain.document.FinantialDocumentType$callable$delete;
import org.fenixedu.treasury.domain.document.FinantialDocumentType$callable$edit;
import org.fenixedu.treasury.domain.document.FinantialDocumentTypeEnum;
import org.fenixedu.treasury.domain.document.FinantialDocumentType_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FinantialDocumentType
extends FinantialDocumentType_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForDebitNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForCreditNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForSettlementNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForReimbursementNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected FinantialDocumentType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected FinantialDocumentType(FinantialDocumentTypeEnum type, String code, LocalizedString name, String documentNumberSeriesPrefix, boolean invoice) {
        this();
        this.setType(type);
        this.setCode(code);
        this.setName(name);
        this.setDocumentNumberSeriesPrefix(documentNumberSeriesPrefix);
        this.setInvoice(invoice);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getType() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentType.type.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.FinantialDocumentType.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.FinantialDocumentType.name.required", new String[0]);
        }
        Set stream = FinantialDocumentType.findAll().filter(fdt -> fdt.getType() == this.getType()).collect(Collectors.toSet());
        if (stream.size() > 1) {
            throw new TreasuryDomainException("error.FinantialDocumentType.not.unique.in.finantial.document.type", new String[0]);
        }
        FinantialDocumentType.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> FinantialDocumentType.findByName(this.getName().getContent(l)));
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new FinantialDocumentType$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(FinantialDocumentType this_, String code, LocalizedString name) {
        this_.setCode(code);
        this_.setName(name);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getFinantialDocumentsSet().isEmpty() && this.getDocumentNumberSeriesSet().isEmpty() && this.getTreasuryDocumentTemplatesSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new FinantialDocumentType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(FinantialDocumentType this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.FinantialDocumentType.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Stream<FinantialDocumentType> findAll() {
        return FenixFramework.getDomainRoot().getFinantialDocumentTypesSet().stream();
    }

    public static FinantialDocumentType findByCode(String code) {
        FinantialDocumentType result = null;
        for (FinantialDocumentType it : FinantialDocumentType.findAll().collect(Collectors.toList())) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.FinantialDocumentType.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    protected static FinantialDocumentType findByName(String name) {
        FinantialDocumentType result = null;
        for (FinantialDocumentType it : FinantialDocumentType.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.FinantialDocumentType.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    protected static FinantialDocumentType findByDocumentNumberSeriesPrefix(String documentNumberSeriesPrefix) {
        FinantialDocumentType result = null;
        for (FinantialDocumentType it : FinantialDocumentType.findAll().collect(Collectors.toList())) {
            if (!it.getDocumentNumberSeriesPrefix().equalsIgnoreCase(documentNumberSeriesPrefix)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.FinantialDocumentType.duplicated.documentNumberSeriesPrefix", new String[0]);
            }
            result = it;
        }
        return result;
    }

    protected static FinantialDocumentType findByFinantialDocumentType(FinantialDocumentTypeEnum type) {
        Set stream = FinantialDocumentType.findAll().filter(fdt -> fdt.getType() == type).collect(Collectors.toSet());
        if (stream.size() > 1) {
            throw new TreasuryDomainException("error.FinantialDocumentType.not.unique.in.finantial.document.type", new String[0]);
        }
        if (stream.size() == 0) {
            return null;
        }
        return (FinantialDocumentType)((Object)stream.iterator().next());
    }

    public static FinantialDocumentType findForDebitNote() {
        return FinantialDocumentType.findByFinantialDocumentType(FinantialDocumentTypeEnum.DEBIT_NOTE);
    }

    public static FinantialDocumentType findForCreditNote() {
        return FinantialDocumentType.findByFinantialDocumentType(FinantialDocumentTypeEnum.CREDIT_NOTE);
    }

    public static FinantialDocumentType findForSettlementNote() {
        return FinantialDocumentType.findByFinantialDocumentType(FinantialDocumentTypeEnum.SETTLEMENT_NOTE);
    }

    public static FinantialDocumentType findForReimbursementNote() {
        return FinantialDocumentType.findByFinantialDocumentType(FinantialDocumentTypeEnum.REIMBURSEMENT_NOTE);
    }

    public static FinantialDocumentType createForDebitNote(String string, LocalizedString localizedString, String string2, boolean bl) {
        return (FinantialDocumentType)((Object)advice$createForDebitNote.perform((Callable)new FinantialDocumentType$callable$createForDebitNote(string, localizedString, string2, bl)));
    }

    static /* synthetic */ FinantialDocumentType advised$createForDebitNote(String code, LocalizedString name, String documentNumberSeriesPrefix, boolean invoice) {
        return new FinantialDocumentType(FinantialDocumentTypeEnum.DEBIT_NOTE, code, name, documentNumberSeriesPrefix, invoice);
    }

    public static FinantialDocumentType createForCreditNote(String string, LocalizedString localizedString, String string2, boolean bl) {
        return (FinantialDocumentType)((Object)advice$createForCreditNote.perform((Callable)new FinantialDocumentType$callable$createForCreditNote(string, localizedString, string2, bl)));
    }

    static /* synthetic */ FinantialDocumentType advised$createForCreditNote(String code, LocalizedString name, String documentNumberSeriesPrefix, boolean invoice) {
        return new FinantialDocumentType(FinantialDocumentTypeEnum.CREDIT_NOTE, code, name, documentNumberSeriesPrefix, invoice);
    }

    public static FinantialDocumentType createForSettlementNote(String string, LocalizedString localizedString, String string2, boolean bl) {
        return (FinantialDocumentType)((Object)advice$createForSettlementNote.perform((Callable)new FinantialDocumentType$callable$createForSettlementNote(string, localizedString, string2, bl)));
    }

    static /* synthetic */ FinantialDocumentType advised$createForSettlementNote(String code, LocalizedString name, String documentNumberSeriesPrefix, boolean invoice) {
        return new FinantialDocumentType(FinantialDocumentTypeEnum.SETTLEMENT_NOTE, code, name, documentNumberSeriesPrefix, invoice);
    }

    public static FinantialDocumentType createForReimbursementNote(String string, LocalizedString localizedString, String string2, boolean bl) {
        return (FinantialDocumentType)((Object)advice$createForReimbursementNote.perform((Callable)new FinantialDocumentType$callable$createForReimbursementNote(string, localizedString, string2, bl)));
    }

    static /* synthetic */ FinantialDocumentType advised$createForReimbursementNote(String code, LocalizedString name, String documentNumberSeriesPrefix, boolean invoice) {
        return new FinantialDocumentType(FinantialDocumentTypeEnum.REIMBURSEMENT_NOTE, code, name, documentNumberSeriesPrefix, invoice);
    }
}

