/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.util;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TreasuryConstants {
    private static final int SCALE = 20;
    public static final BigDecimal HUNDRED_PERCENT = new BigDecimal("100.00");
    public static final String BUNDLE = "resources.FenixeduTreasuryResources";
    public static final DateTime INFINITY_DATE = new DateTime().plusYears(500);
    public static final BigDecimal DEFAULT_QUANTITY = BigDecimal.ONE;
    @Deprecated
    public static final Locale DEFAULT_LANGUAGE = new Locale("PT");
    @Deprecated
    public static final String DEFAULT_COUNTRY = "PT";
    private static final int ORIGIN_DOCUMENT_LIMIT = 100;
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String DATE_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    public static final String DATE_FORMAT_YYYY_MM_DD = "yyyy/MM/dd";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD = "yyyy/MM/dd HH:mm:ss";
    public static final String STANDARD_DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";

    public static LocalizedString getDefaultProductUnitDescription() {
        return TreasuryConstants.treasuryBundleI18N("label.TreasuryConstants.default.product.unit.description", new String[0]);
    }

    public static boolean isForeignLanguage(Locale language) {
        return !language.getLanguage().equals(DEFAULT_LANGUAGE.getLanguage());
    }

    public static boolean isDefaultCountry(String country) {
        if (Strings.isNullOrEmpty((String)country)) {
            return false;
        }
        return TreasuryConstants.isSameCountryCode(DEFAULT_COUNTRY, country);
    }

    public static boolean isSameCountryCode(String leftCountryCode, String rightCountryCode) {
        return TreasuryConstants.lowerCase(leftCountryCode).equals(TreasuryConstants.lowerCase(rightCountryCode));
    }

    private static String lowerCase(String value) {
        if (value == null) {
            return null;
        }
        return value.toLowerCase();
    }

    public static boolean isNegative(BigDecimal value) {
        return !TreasuryConstants.isZero(value) && !TreasuryConstants.isPositive(value);
    }

    public static boolean isZero(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) == 0;
    }

    public static boolean isPositive(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) < 0;
    }

    public static boolean isGreaterThan(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0;
    }

    public static boolean isGreaterOrEqualThan(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) >= 0;
    }

    public static boolean isEqual(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) == 0;
    }

    public static boolean isLessThan(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) < 0;
    }

    public static boolean isLessOrEqualThan(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) <= 0;
    }

    public static BigDecimal defaultScale(BigDecimal v) {
        return v.setScale(20, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        return a.divide(b, 20, RoundingMode.HALF_UP);
    }

    public static BigDecimal rationalVatRate(InvoiceEntry entry) {
        return TreasuryConstants.divide(entry.getVatRate(), BigDecimal.valueOf(100L));
    }

    public static int numberOfDaysInYear(int year) {
        if (new LocalDate(year, 1, 1).year().isLeap()) {
            return 366;
        }
        return 365;
    }

    public static LocalDate lastDayInYear(int year) {
        return new LocalDate(year, 12, 31);
    }

    public static LocalDate firstDayInYear(int year) {
        return new LocalDate(year, 1, 1);
    }

    public static boolean isDateBetween(LocalDate beginDate, LocalDate endDate, LocalDate when) {
        return new Interval((ReadableInstant)beginDate.toDateTimeAtStartOfDay(), (ReadableInstant)(endDate != null ? endDate.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1) : INFINITY_DATE)).contains((ReadableInstant)when.toDateTimeAtStartOfDay());
    }

    public static boolean isDateBetween(LocalDate beginDate, LocalDate endDate, DateTime when) {
        return new Interval((ReadableInstant)beginDate.toDateTimeAtStartOfDay(), (ReadableInstant)(endDate != null ? endDate.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1) : INFINITY_DATE)).contains((ReadableInstant)when);
    }

    public static DateTime parseDateTime(String strValue, String pattern) {
        DateTimeFormatter dateTimePattern = DateTimeFormat.forPattern((String)pattern);
        return dateTimePattern.parseDateTime(strValue);
    }

    public static LocalDate parseLocalDate(String strValue, String pattern) {
        DateTimeFormatter dateTimePattern = DateTimeFormat.forPattern((String)pattern);
        return dateTimePattern.parseLocalDate(strValue);
    }

    public static Set<Partial> getHolidays() {
        return TreasuryPlataformDependentServicesFactory.implementation().getHolidays();
    }

    public static boolean isHoliday(LocalDate localDate) {
        return TreasuryConstants.getHolidays().stream().anyMatch(p -> p.isMatch((ReadablePartial)localDate));
    }

    public static boolean isHoliday(DateTime dateTime) {
        return TreasuryConstants.getHolidays().stream().anyMatch(p -> p.isMatch((ReadableInstant)dateTime));
    }

    public static int countNumberOfWorkDaysBetween(LocalDate startDate, LocalDate endDate) {
        Predicate<LocalDate> isWeekend = date -> date.getDayOfWeek() == 6 || date.getDayOfWeek() == 7 || TreasuryConstants.getHolidays().stream().anyMatch(h -> h.isMatch((ReadablePartial)date));
        return IntStream.rangeClosed(0, Days.daysBetween((ReadablePartial)startDate, (ReadablePartial)endDate).getDays()).map(d -> isWeekend.test(startDate.plusDays(d)) ? 0 : 1).reduce(0, (a, b) -> a + b);
    }

    public static List<LocalDateInterval> splitByYearIntervals(LocalDate beginDate, LocalDate endDate) {
        if (beginDate.isAfter((ReadablePartial)endDate)) {
            throw new RuntimeException("error");
        }
        if (beginDate.getYear() == endDate.getYear()) {
            return Collections.singletonList(new LocalDateInterval(beginDate, endDate));
        }
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        dates.add(beginDate);
        dates.add(endDate);
        for (int i = beginDate.getYear(); i < endDate.getYear(); ++i) {
            dates.add(new LocalDate(i, 12, 31));
            dates.add(new LocalDate(i + 1, 1, 1));
        }
        Collections.sort(dates);
        LocalDate[] datesArray = dates.toArray(new LocalDate[0]);
        ArrayList<LocalDateInterval> result = new ArrayList<LocalDateInterval>();
        for (int i = 0; i < dates.size() - 1; i += 2) {
            result.add(new LocalDateInterval(datesArray[i], datesArray[i + 1]));
        }
        return result;
    }

    public static boolean stringNormalizedContains(String text, String compound) {
        String textNormalized = Normalizer.normalize(text.toLowerCase(), Normalizer.Form.NFC);
        String compoundNormalized = Normalizer.normalize(compound.toLowerCase(), Normalizer.Form.NFC);
        return textNormalized.contains(compoundNormalized);
    }

    public static boolean matchNames(String value, String searchTerms) {
        ArrayList valuesArray = Lists.newArrayList((Object[])value.split("\\s+"));
        ArrayList searchTermsArray = Lists.newArrayList((Object[])searchTerms.split("\\s+"));
        if (valuesArray.isEmpty() && !searchTermsArray.isEmpty()) {
            return false;
        }
        for (String term : searchTermsArray) {
            if (valuesArray.stream().anyMatch(str -> str.contains(term))) continue;
            return false;
        }
        return true;
    }

    public static String firstAndLastWords(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        List wordsList = Splitter.onPattern((String)"\\s+").splitToList((CharSequence)value.trim());
        if (wordsList.size() == 1) {
            return value;
        }
        return (String)wordsList.get(0) + " " + (String)wordsList.get(wordsList.size() - 1);
    }

    public static String json(Object obj) {
        GsonBuilder builder = new GsonBuilder();
        builder.addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes arg0) {
                return false;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz == Class.class;
            }
        });
        return builder.create().toJson(obj);
    }

    public static String treasuryBundle(String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(BUNDLE, key, args);
    }

    public static String treasuryBundle(Locale locale, String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(locale, BUNDLE, key, args);
    }

    public static LocalizedString treasuryBundleI18N(String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundleI18N(BUNDLE, key, args);
    }

    public static final String sibsTransactionUniqueIdentifier(String paymentCode, DateTime whenOccured) {
        return String.format("%s%s", paymentCode, whenOccured.toString("yyyyMMddHHmm"));
    }

    public static boolean isOriginDocumentNumberValid(String originDocumentNumber) {
        if (Strings.isNullOrEmpty((String)originDocumentNumber)) {
            return true;
        }
        return originDocumentNumber.length() <= 100;
    }

    public static String propertiesMapToJson(Map<String, String> propertiesMap) {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        Type stringStringMapType = new TypeToken<Map<String, String>>(){}.getType();
        return gson.toJson(propertiesMap, stringStringMapType);
    }

    public static Map<String, String> propertiesJsonToMap(String propertiesMapJson) {
        if (StringUtils.isEmpty((String)propertiesMapJson)) {
            return new HashMap<String, String>();
        }
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        Type stringStringMapType = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)gson.fromJson(propertiesMapJson, stringStringMapType);
    }

    public static String getAuthenticatedUsername() {
        if (Authenticate.getUser() == null) {
            return null;
        }
        return Authenticate.getUser().getUsername();
    }

    public static Locale getDefaultLocale() {
        return Locale.forLanguageTag(CoreConfiguration.getConfiguration().defaultLocale());
    }

    public static Locale getCurrentLocale() {
        return I18N.getLocale();
    }

    public static Set<Locale> getAvailableLocales() {
        return CoreConfiguration.supportedLocales();
    }

    public static class LocalDateInterval {
        private LocalDate beginDate;
        private LocalDate endDate;

        public LocalDateInterval(LocalDate beginDate, LocalDate endDate) {
            this.beginDate = beginDate;
            this.endDate = endDate;
        }

        public LocalDate getBeginDate() {
            return this.beginDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }
    }
}

