/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibspaymentsgateway;

import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.sibspaymentsgateway.SibsPaymentsGatewayLog_Base;

public class SibsPaymentsGatewayLog
extends SibsPaymentsGatewayLog_Base {
    public static final String OCTECT_STREAM_CONTENT_TYPE = "application/octet-stream";

    public SibsPaymentsGatewayLog() {
    }

    protected SibsPaymentsGatewayLog(String operationCode) {
        this();
        this.setOperationCode(operationCode);
        this.checkRules();
    }

    protected SibsPaymentsGatewayLog(String operationCode, String sibsGatewayMerchantTransactionId) {
        this();
        this.setOperationCode(operationCode);
        this.setSibsGatewayMerchantTransactionId(sibsGatewayMerchantTransactionId);
        this.checkRules();
    }

    public SibsPaymentsGatewayLog(PaymentRequest paymentRequest, String stateCode, LocalizedString stateDescription) {
        this();
        this.setPaymentRequest(paymentRequest);
        this.setStateCode(stateCode);
        this.setStateDescription(stateDescription);
    }

    private void checkRules() {
    }

    public boolean isExceptionOccured() {
        return super.getExceptionOccured();
    }

    public boolean isOperationSuccess() {
        return super.getOperationSuccess();
    }

    public void markAsDuplicatedTransaction() {
        this.setSibsTransactionDuplicated(true);
        super.markAsDuplicatedTransaction();
    }

    public void saveMerchantTransactionId(String merchantTransactionId) {
        this.setSibsGatewayMerchantTransactionId(merchantTransactionId);
    }

    public void saveTransactionId(String transactionId) {
        this.setSibsGatewayTransactionId(transactionId);
    }

    public void saveReferenceId(String referenceId) {
        this.setSibsGatewayReferenceId(referenceId);
    }

    public String getInternalMerchantTransactionId() {
        return super.getSibsGatewayMerchantTransactionId();
    }

    public String getExternalTransactionId() {
        return super.getSibsGatewayTransactionId();
    }

    public void setSibsGatewayMerchantTransactionId(String sibsGatewayMerchantTransactionId) {
        super.setSibsGatewayMerchantTransactionId(sibsGatewayMerchantTransactionId);
        super.setInternalMerchantTransactionId(sibsGatewayMerchantTransactionId);
    }

    public void setSibsGatewayTransactionId(String sibsGatewayTransactionId) {
        super.setSibsGatewayTransactionId(sibsGatewayTransactionId);
        super.setExternalTransactionId(sibsGatewayTransactionId);
    }

    public static Stream<SibsPaymentsGatewayLog> findAll() {
        return PaymentRequestLog.findAll().filter(p -> p instanceof SibsPaymentsGatewayLog).map(SibsPaymentsGatewayLog.class::cast);
    }

    public static SibsPaymentsGatewayLog createForSibsPaymentRequest(String sibsGatewayMerchantTransactionId) {
        SibsPaymentsGatewayLog log2 = new SibsPaymentsGatewayLog("sibsMbPaymentRequest", sibsGatewayMerchantTransactionId);
        log2.setStateCode(PaymentReferenceCodeStateType.UNUSED.getCode());
        log2.setStateDescription(PaymentReferenceCodeStateType.UNUSED.getDescriptionI18N());
        return log2;
    }

    public static SibsPaymentsGatewayLog createForMbwayPaymentRequest(String sibsGatewayMerchantTransactionId) {
        SibsPaymentsGatewayLog log2 = new SibsPaymentsGatewayLog("mbwayPaymentRequest", sibsGatewayMerchantTransactionId);
        log2.setStateCode(PaymentReferenceCodeStateType.UNUSED.getCode());
        log2.setStateDescription(PaymentReferenceCodeStateType.UNUSED.getDescriptionI18N());
        return log2;
    }

    public static SibsPaymentsGatewayLog createLogForWebhookNotification() {
        return new SibsPaymentsGatewayLog("WEBHOOK_NOTIFICATION");
    }

    public static SibsPaymentsGatewayLog create(PaymentRequest paymentRequest, String sibsGatewayMerchantTransactionId) {
        SibsPaymentsGatewayLog log2 = new SibsPaymentsGatewayLog();
        log2.setPaymentRequest(paymentRequest);
        log2.setSibsGatewayMerchantTransactionId(sibsGatewayMerchantTransactionId);
        return log2;
    }

    public static SibsPaymentsGatewayLog createPaymentRequestLog(PaymentRequest paymentRequest, String stateCode, LocalizedString stateDescription) {
        return new SibsPaymentsGatewayLog(paymentRequest, stateCode, stateDescription);
    }
}

