/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.forwardpayments.PostForwardPaymentsReportFile$callable$create;
import org.fenixedu.treasury.domain.forwardpayments.PostForwardPaymentsReportFile_Base;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PostForwardPaymentsReportFile
extends PostForwardPaymentsReportFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private PostForwardPaymentsReportFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    private PostForwardPaymentsReportFile(DateTime postForwardPaymentsExecutionDate, DateTime beginDate, DateTime endDate, String filename, byte[] content) {
        this();
        this.setPostForwardPaymentsExecutionDate(postForwardPaymentsExecutionDate);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.createFile(this, filename, CONTENT_TYPE, content);
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username);
    }

    @Override
    public void delete() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        this.setDomainRoot(null);
        services.deleteFile(this);
        super.deleteDomainObject();
    }

    public static Stream<PostForwardPaymentsReportFile> findAll() {
        return FenixFramework.getDomainRoot().getPostForwardPaymentsReportFilesSet().stream();
    }

    public static PostForwardPaymentsReportFile create(DateTime dateTime, DateTime dateTime2, DateTime dateTime3, String string, byte[] byArray) {
        return (PostForwardPaymentsReportFile)advice$create.perform((Callable)new PostForwardPaymentsReportFile$callable$create(dateTime, dateTime2, dateTime3, string, byArray));
    }

    static /* synthetic */ PostForwardPaymentsReportFile advised$create(DateTime postForwardPaymentsExecutionDate, DateTime beginDate, DateTime endDate, String filename, byte[] content) {
        PostForwardPaymentsReportFile file = new PostForwardPaymentsReportFile(postForwardPaymentsExecutionDate, beginDate, endDate, filename, content);
        return file;
    }
}

