/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibspay.webhook;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.sibspay.MbwayMandate;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayAPIService;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotification;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotificationResponse;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotificationWrapper;
import org.fenixedu.treasury.services.payments.sibspay.webhook.SibsPayWebhookLogic$callable$createLog;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsPayWebhookLogic {
    private static final String PROVIDER_NAME = "BC";
    private static final Logger logger;
    private final String encryptedBody;
    private final String iv;
    private final String authTag;
    private SibsPayPlatform configurationToUse;
    private SibsPayWebhookNotificationWrapper webhookNotificationWrapper;
    private PaymentRequestLog log;
    private boolean mockedUser;
    public static final Advice advice$createLog;

    public SibsPayWebhookLogic(String encryptedBody, String iv, String authTag) {
        this.encryptedBody = encryptedBody;
        this.iv = iv;
        this.authTag = authTag;
    }

    private boolean decryptNotificationAndFindConfiguration() throws IOException {
        Throwable savedUnableToDecryptException = null;
        for (SibsPayPlatform configuration : SibsPayPlatform.findAllActive().collect(Collectors.toList())) {
            try {
                String jsonBody = this.decrypt(configuration.getSecretKey(), this.iv, this.authTag, this.encryptedBody);
                FenixFramework.atomic(() -> this.log.saveRequest(jsonBody));
                SibsPayWebhookNotification webhookNotificationObj = SibsPayAPIService.deserializeWebhookNotification(jsonBody);
                if (!StringUtils.isNotEmpty((String)webhookNotificationObj.getNotificationID())) continue;
                this.webhookNotificationWrapper = new SibsPayWebhookNotificationWrapper(webhookNotificationObj);
                this.configurationToUse = configuration;
                return true;
            }
            catch (UnableToDecryptException e) {
                savedUnableToDecryptException = e;
            }
        }
        logger.error("Unable to decrypt the encrypted body");
        if (savedUnableToDecryptException != null) {
            logger.error(savedUnableToDecryptException.getMessage());
        }
        return false;
    }

    public Response runWebhook() {
        this.log = this.createLog();
        FenixFramework.atomic(() -> this.log.saveWebhookNotificationData(this.iv, this.authTag, this.encryptedBody));
        try {
            boolean decryptedSuccessfully = this.decryptNotificationAndFindConfiguration();
            if (!decryptedSuccessfully) {
                throw new RuntimeException("the system was not able to decrypt or integration is down");
            }
            this.mockUserIfNecessary();
            FenixFramework.atomic(() -> {
                this.log.setExternalTransactionId(this.webhookNotificationWrapper.getTransactionId());
                this.log.setStatusCode(this.webhookNotificationWrapper.getOperationStatusCode());
                this.log.setStatusMessage(this.webhookNotificationWrapper.getOperationStatusMessage());
                this.log.setTransactionWithPayment(this.webhookNotificationWrapper.isPaid());
                this.log.setOperationSuccess(this.webhookNotificationWrapper.isOperationSuccess());
                this.log.savePaymentTypeAndBrand(this.webhookNotificationWrapper.getPaymentType(), this.webhookNotificationWrapper.getPaymentBrand());
            });
            if (this.isMandateActionAuthCreation()) {
                Response response = this.runLogicForMandateActionAuthCreation();
                return response;
            }
            if (this.isMandateActionAuthSuspension()) {
                Response response = this.runLogicForMandateActionAuthSuspension();
                return response;
            }
            if (this.isMandateActionAuthReactivation()) {
                Response response = this.runLogicForMandateActionAuthReactivation();
                return response;
            }
            if (this.isMandateActionAuthLimitsUpdate()) {
                Response response = this.runLogicForMandateActionAuthLimitUpdate();
                return response;
            }
            Response response = this.runLogicForPayment();
            return response;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            FenixFramework.atomic(() -> this.log.logException(e));
            if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                OnlinePaymentsGatewayCommunicationException oe = (OnlinePaymentsGatewayCommunicationException)e;
                FenixFramework.atomic(() -> {
                    this.log.saveRequest(oe.getRequestLog());
                    this.log.saveResponse(oe.getResponseLog());
                });
            }
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (this.mockedUser) {
                Authenticate.unmock();
                logger.debug("Unmocked user");
            }
        }
    }

    private Response runLogicForMandateActionAuthSuspension() {
        String mandateId = this.webhookNotificationWrapper.getMandateId();
        if (StringUtils.isEmpty((String)mandateId)) {
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        Optional<MbwayMandate> mbwayMandateOpt = MbwayMandate.findUniqueByMandateIdExcludingTransferred(mandateId);
        if (!mbwayMandateOpt.isPresent()) {
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        MbwayMandate mbwayMandate = mbwayMandateOpt.get();
        FenixFramework.atomic(() -> {
            if (!this.isIsMandateActionStatusSuccess()) {
                throw new IllegalArgumentException("how to deal with this kind of notification");
            }
            mbwayMandate.suspend();
        });
        return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
    }

    private Response runLogicForMandateActionAuthReactivation() {
        String mandateId = this.webhookNotificationWrapper.getMandateId();
        if (StringUtils.isEmpty((String)mandateId)) {
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        Optional<MbwayMandate> mbwayMandateOpt = MbwayMandate.findUniqueByMandateIdExcludingTransferred(mandateId);
        if (!mbwayMandateOpt.isPresent()) {
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        MbwayMandate mbwayMandate = mbwayMandateOpt.get();
        FenixFramework.atomic(() -> {
            if (!this.isIsMandateActionStatusSuccess()) {
                throw new IllegalArgumentException("how to deal with this kind of notification");
            }
            mbwayMandate.reactivate();
        });
        return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
    }

    private Response runLogicForMandateActionAuthLimitUpdate() {
        String mandateId = this.webhookNotificationWrapper.getMandateId();
        if (StringUtils.isEmpty((String)mandateId)) {
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        Optional<MbwayMandate> mbwayMandateOpt = MbwayMandate.findUniqueByMandateIdExcludingTransferred(mandateId);
        if (!mbwayMandateOpt.isPresent()) {
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        MbwayMandate mbwayMandate = mbwayMandateOpt.get();
        FenixFramework.atomic(() -> {
            if (!this.isIsMandateActionStatusSuccess()) {
                throw new IllegalArgumentException("how to deal with this kind of notification");
            }
            mbwayMandate.updatePlafondAndExpirationDate(this.webhookNotificationWrapper.getPlafond(), this.webhookNotificationWrapper.getAuthorizationExpirationDate());
        });
        return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
    }

    private Response runLogicForPayment() {
        Optional<PaymentRequest> paymentRequestOptional = this.configurationToUse.getPaymentRequestsSet().stream().filter(p -> this.webhookNotificationWrapper.getTransactionId().equals(p.getTransactionId())).findFirst();
        if (!paymentRequestOptional.isPresent()) {
            logger.info("Transaction not found, maybe was generated in other system: '%s' - '%s'. Return ok...".formatted(this.webhookNotificationWrapper.getMerchantTransactionId(), this.webhookNotificationWrapper.getTransactionId()));
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        PaymentRequest paymentRequest = paymentRequestOptional.get();
        FenixFramework.atomic(() -> {
            this.log.setInternalMerchantTransactionId(paymentRequest.getMerchantTransactionId());
            this.log.setPaymentRequest(paymentRequest);
            this.log.setStateCode(paymentRequest.getCurrentState().getCode());
            this.log.setStateDescription(paymentRequest.getCurrentState().getLocalizedName());
        });
        if (this.webhookNotificationWrapper.isPaid()) {
            if (PaymentTransaction.isTransactionDuplicate(this.webhookNotificationWrapper.getTransactionId())) {
                FenixFramework.atomic(() -> this.log.markAsDuplicatedTransaction());
                logger.debug("The transaction is duplicate. Nothing to do, return: " + this.webhookNotificationWrapper.getTransactionId());
                return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
            }
            if (!(paymentRequest instanceof SibsPaymentRequest || paymentRequest.isInCreatedState() || paymentRequest.isInRequestedState())) {
                throw new RuntimeException("The notification is a successful payment but the paymentRequest is already processed or annuled. Please check");
            }
            this.webhookNotificationWrapper.checkIfNotificationIsPaidAndPaymentReferenceIsAlsoInPaidStatus();
        }
        if (this.webhookNotificationWrapper.isPending()) {
            logger.debug("The notification is pending status. Nothing to do, return...: " + this.webhookNotificationWrapper.getTransactionId());
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        if (this.webhookNotificationWrapper.isPaid()) {
            logger.debug("The notification paid. Registering payment: " + this.webhookNotificationWrapper.getTransactionId());
            if (paymentRequest instanceof ForwardPaymentRequest) {
                this.configurationToUse.processForwardPaymentFromWebhook(this.log, this.webhookNotificationWrapper);
                return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
            }
            if (paymentRequest instanceof SibsPaymentRequest) {
                this.configurationToUse.processPaymentReferenceCodeTransaction(this.log, this.webhookNotificationWrapper);
                return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
            }
            if (paymentRequest instanceof MbwayRequest) {
                this.configurationToUse.processMbwayTransaction(this.log, this.webhookNotificationWrapper);
                return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
            }
            throw new RuntimeException("unknown payment request type");
        }
        if (this.webhookNotificationWrapper.isExpired() || this.webhookNotificationWrapper.isDeclined()) {
            logger.debug("The notification is expired or declined. Reject payment request...: " + this.webhookNotificationWrapper.getTransactionId());
            FenixFramework.atomic(() -> this.configurationToUse.rejectRequest(paymentRequest, this.log, this.webhookNotificationWrapper));
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        logger.info("Unknown state, nothing to do, return with successful response: " + this.webhookNotificationWrapper.getTransactionId());
        return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
    }

    private Response runLogicForMandateActionAuthCreation() {
        String mandateId = this.webhookNotificationWrapper.getMandateId();
        if (StringUtils.isEmpty((String)mandateId)) {
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        Optional<MbwayMandate> mbwayMandateOpt = MbwayMandate.findUniqueByMandateIdExcludingTransferred(mandateId);
        if (!mbwayMandateOpt.isPresent()) {
            return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
        }
        MbwayMandate mbwayMandate = mbwayMandateOpt.get();
        FenixFramework.atomic(() -> {
            if (this.isIsMandateActionStatusSuccess()) {
                mbwayMandate.authorize();
                mbwayMandate.updatePlafondAndExpirationDate(this.webhookNotificationWrapper.getPlafond(), this.webhookNotificationWrapper.getAuthorizationExpirationDate());
            } else if (this.isMandateActionStatusRefusedOrRejected()) {
                mbwayMandate.markAsNotAuthorized("Received declined in the platform by a webhook notification");
            } else {
                throw new IllegalArgumentException("how to deal with this kind of notification");
            }
        });
        return Response.ok((Object)this.response(this.webhookNotificationWrapper), (String)"application/json").build();
    }

    private boolean isMandateActionStatusRefusedOrRejected() {
        return this.webhookNotificationWrapper.isMandateActionStatusRejected() || this.webhookNotificationWrapper.isMandateActionStatusRefused();
    }

    private boolean isIsMandateActionStatusSuccess() {
        return this.webhookNotificationWrapper.IsMandateActionStatusSuccess();
    }

    private boolean isMandateActionAuthCreation() {
        return this.webhookNotificationWrapper.IsMandateActionAuthCreation();
    }

    private boolean isMandateActionAuthSuspension() {
        return this.webhookNotificationWrapper.isMandateActionAuthSuspension();
    }

    private boolean isMandateActionAuthReactivation() {
        return this.webhookNotificationWrapper.isMandateActionAuthReactivation();
    }

    private boolean isMandateActionAuthLimitsUpdate() {
        return this.webhookNotificationWrapper.isMandateActionAuthLimitsUpdate();
    }

    private void mockUserIfNecessary() {
        boolean needToMockUser;
        boolean bl = needToMockUser = StringUtils.isEmpty((String)TreasuryConstants.getAuthenticatedUsername()) && StringUtils.isNotEmpty((String)this.configurationToUse.getApplicationUsernameForAutomaticOperations());
        if (needToMockUser) {
            this.mockApplicationUser(this.configurationToUse.getApplicationUsernameForAutomaticOperations());
            this.mockedUser = true;
            logger.debug("Mocked user with " + this.configurationToUse.getApplicationUsernameForAutomaticOperations());
        }
    }

    private void mockApplicationUser(String username) {
        User user = User.findByUsername((String)username);
        if (user == null) {
            throw new IllegalArgumentException("user not found: " + username);
        }
        Authenticate.mock((User)user, (String)"TODO: CHANGE ME");
    }

    private String decrypt(String aesSecretKey, String ivFromHttpHeader, String authTagFromHttpHeader, String encryptedBody) throws UnableToDecryptException {
        byte[] key = Base64.getDecoder().decode(aesSecretKey);
        byte[] iv = Base64.getDecoder().decode(ivFromHttpHeader);
        byte[] authTag = Base64.getDecoder().decode(authTagFromHttpHeader);
        byte[] encryptedText = Base64.getDecoder().decode(encryptedBody);
        byte[] cipherText = ArrayUtils.addAll((byte[])encryptedText, (byte[])authTag);
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, 0, 32, "AES");
            Cipher cipher = SibsPayWebhookLogic.getCipherInstance();
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
            byte[] bytes = cipher.doFinal(cipherText);
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new UnableToDecryptException((Throwable)e);
        }
    }

    public static Cipher getCipherInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        return Cipher.getInstance("AES/GCM/NoPadding", PROVIDER_NAME);
    }

    private PaymentRequestLog createLog() {
        return (PaymentRequestLog)((Object)advice$createLog.perform((Callable)new SibsPayWebhookLogic$callable$createLog(this)));
    }

    static /* synthetic */ PaymentRequestLog advised$createLog(SibsPayWebhookLogic this_) {
        return new PaymentRequestLog("webhookNotification");
    }

    private SibsPayWebhookNotificationResponse response(SibsPayWebhookNotificationWrapper webhookNotificationWrapper) {
        return new SibsPayWebhookNotificationResponse(200, "Success", webhookNotificationWrapper.getNotificationID());
    }

    static {
        advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(SibsPayWebhookLogic.class);
    }

    private class UnableToDecryptException
    extends Exception {
        public UnableToDecryptException(Throwable e) {
            super(e);
        }
    }
}

