/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs.outgoing;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.services.payments.sibs.outgoing.PrintedPaymentCodes;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class SibsOutgoingPaymentFile {
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final String NUMBER_FILLER = "0";
    private static final String LINE_TERMINATOR = "\r\n";
    private Header header;
    private List<Line> lines;
    private Footer footer;
    private Set<String> existingCodes;
    PrintedPaymentCodes associatedPaymentCodes;

    public SibsOutgoingPaymentFile(String sourceInstitutionId, String destinationInstitutionId, String entity) {
        this.header = new Header(sourceInstitutionId, destinationInstitutionId, entity);
        this.lines = new ArrayList<Line>();
        this.footer = new Footer();
        this.existingCodes = new HashSet<String>();
        this.associatedPaymentCodes = new PrintedPaymentCodes();
    }

    public SibsOutgoingPaymentFile(String sourceInstitutionId, String destinationInstitutionId, String entity, DateTime lastSuccessfulSentDate) {
        this.header = new Header(sourceInstitutionId, destinationInstitutionId, entity, lastSuccessfulSentDate);
        this.lines = new ArrayList<Line>();
        this.footer = new Footer();
        this.existingCodes = new HashSet<String>();
        this.associatedPaymentCodes = new PrintedPaymentCodes();
    }

    public void addAssociatedPaymentCode(SibsReferenceCode paymentCode) {
        this.associatedPaymentCodes.addPaymentCode(paymentCode);
    }

    public PrintedPaymentCodes getAssociatedPaymentCodes() {
        return this.associatedPaymentCodes;
    }

    public void addLine(String code, BigDecimal minAmount, BigDecimal maxAmount, LocalDate validFrom, LocalDate validTo) {
        if (this.existingCodes.contains(code)) {
            throw new RuntimeException(MessageFormat.format("Code {0} is duplicated", code));
        }
        this.existingCodes.add(code);
        this.lines.add(new Line(code, minAmount, maxAmount, validFrom, validTo));
    }

    public String render() {
        StringBuilder result = new StringBuilder();
        result.append(this.header.render());
        for (Line line : this.lines) {
            result.append(line.render());
        }
        result.append(this.footer.render(this.lines.size()));
        return result.toString();
    }

    public String toString() {
        return this.render();
    }

    public void save(File destinationFile) {
        FilterOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            outputStream.write(this.render().getBytes());
            ((BufferedOutputStream)outputStream).flush();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class Header {
        private static final String HEADER_REGISTER_TYPE = "0";
        private static final String FILE_TYPE = "AEPS";
        private static final String OMISSION_SEQUENCE_NUMBER = "1";
        private static final String CURRENCY_CODE = "978";
        private static final int WHITE_SPACES_IN_HEADER = 3;
        private String sourceInstitutionId;
        private String destinationInstitutionId;
        private String entityCode;
        private DateTime lastSentPaymentFile;

        public Header(String sourceInstitutionId, String destinationInstitutionId, String entityCode) {
            this.sourceInstitutionId = sourceInstitutionId;
            this.destinationInstitutionId = destinationInstitutionId;
            this.entityCode = entityCode;
        }

        public Header(String sourceInstitutionId, String destinationInstitutionId, String entityCode, DateTime lastSuccessfulSentDate) {
            this.sourceInstitutionId = sourceInstitutionId;
            this.destinationInstitutionId = destinationInstitutionId;
            this.entityCode = entityCode;
            this.lastSentPaymentFile = lastSuccessfulSentDate;
        }

        public String render() {
            StringBuilder header = new StringBuilder();
            header.append("0");
            header.append(FILE_TYPE);
            header.append(this.sourceInstitutionId);
            header.append(this.destinationInstitutionId);
            header.append(new LocalDate().toString(SibsOutgoingPaymentFile.DATE_FORMAT));
            header.append(OMISSION_SEQUENCE_NUMBER);
            header.append(this.lastSentPaymentFile != null ? this.lastSentPaymentFile.toString(SibsOutgoingPaymentFile.DATE_FORMAT) : "00000000");
            header.append(OMISSION_SEQUENCE_NUMBER);
            header.append(this.entityCode);
            header.append(CURRENCY_CODE);
            header.append(StringUtils.leftPad((String)"", (int)3));
            header.append(SibsOutgoingPaymentFile.LINE_TERMINATOR);
            return header.toString();
        }
    }

    private static class Footer {
        private static final String FOOTER_REGISTER_TYPE = "9";
        private static final int NUMBER_OF_LINES_DESCRIPTOR_LENGTH = 8;
        public static final int WHITE_SPACES_IN_FOOTER = 41;

        public String render(int totalLines) {
            StringBuilder footer = new StringBuilder();
            footer.append(FOOTER_REGISTER_TYPE);
            footer.append(StringUtils.leftPad((String)String.valueOf(totalLines), (int)8, (String)SibsOutgoingPaymentFile.NUMBER_FILLER));
            footer.append(StringUtils.leftPad((String)"", (int)41));
            footer.append(SibsOutgoingPaymentFile.LINE_TERMINATOR);
            return footer.toString();
        }
    }

    private static class Line {
        private static final String LINE_REGISTER_TYPE = "1";
        private static final String LINE_PROCESSING_CODE = "80";
        private static int DECIMAL_PLACES_FACTOR = 100;
        private static final int WHITE_SPACES_IN_LINE = 2;
        private static final int AMOUNT_LENGTH = 10;
        private String code;
        private BigDecimal minAmount;
        private BigDecimal maxAmount;
        private LocalDate startDate;
        private LocalDate endDate;

        public Line(String code, BigDecimal minAmount, BigDecimal maxAmount, LocalDate startDate, LocalDate endDate) {
            this.checkAmounts(code, minAmount, maxAmount);
            this.code = code;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        private void checkAmounts(String code, BigDecimal minAmount, BigDecimal maxAmount) {
            if (minAmount.compareTo(BigDecimal.ZERO) < 0) {
                throw new RuntimeException(MessageFormat.format("Min amount for code {0} must be greater than zero", code));
            }
            if (maxAmount.compareTo(BigDecimal.ZERO) < 0) {
                throw new RuntimeException(MessageFormat.format("Max amount for code {0} must be greater than zero", code));
            }
        }

        public String render() {
            StringBuilder result = new StringBuilder();
            result.append(LINE_REGISTER_TYPE);
            result.append(LINE_PROCESSING_CODE);
            result.append(this.code);
            result.append(this.endDate.toString(SibsOutgoingPaymentFile.DATE_FORMAT));
            result.append(this.leftPadAmount(this.maxAmount));
            result.append(this.startDate.toString(SibsOutgoingPaymentFile.DATE_FORMAT));
            result.append(this.leftPadAmount(this.minAmount));
            result.append(StringUtils.leftPad((String)"", (int)2));
            result.append(SibsOutgoingPaymentFile.LINE_TERMINATOR);
            return result.toString();
        }

        private String leftPadAmount(BigDecimal amount) {
            return StringUtils.leftPad((String)String.valueOf(amount.multiply(BigDecimal.valueOf(DECIMAL_PLACES_FACTOR)).longValue()), (int)10, (String)SibsOutgoingPaymentFile.NUMBER_FILLER);
        }
    }
}

