/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.sibs.outgoing.SibsOutgoingPaymentFile;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsOutputFile
extends SibsOutputFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "text/plain";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public SibsOutputFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
        this.setCreator(TreasuryConstants.getAuthenticatedUsername());
    }

    private String createPaymentFile(Set<SibsPaymentCodePool> paymentCodePoolsToInclude, DateTime lastSuccessfulSentDateTime, StringBuilder errorsBuilder) {
        if (paymentCodePoolsToInclude.isEmpty()) {
            throw new TreasuryDomainException("error.SibsOutputFile.selected.paymentCodePools.empty", new String[0]);
        }
        String sourceInstitutionId = paymentCodePoolsToInclude.iterator().next().getSourceInstitutionId();
        String destinationInstitutionId = paymentCodePoolsToInclude.iterator().next().getDestinationInstitutionId();
        if (StringUtils.isEmpty((String)sourceInstitutionId)) {
            throw new TreasuryDomainException("error.SibsOutputFile.sourceInstitutionId.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)destinationInstitutionId)) {
            throw new TreasuryDomainException("error.SibsOutputFile.destinationInstitutionId.required", new String[0]);
        }
        if (paymentCodePoolsToInclude.stream().anyMatch(p -> !sourceInstitutionId.equals(p.getSourceInstitutionId()))) {
            throw new TreasuryDomainException("error.SibsOutputFile.selected.paymentCodePools.sourceInstitutionId.differ", new String[0]);
        }
        if (paymentCodePoolsToInclude.stream().anyMatch(p -> !destinationInstitutionId.equals(p.getDestinationInstitutionId()))) {
            throw new TreasuryDomainException("error.SibsOutputFile.selected.paymentCodePools.destinationInstitutionId.differ", new String[0]);
        }
        String entityReferenceCode = paymentCodePoolsToInclude.iterator().next().getEntityReferenceCode();
        if (paymentCodePoolsToInclude.stream().anyMatch(p -> !entityReferenceCode.equals(p.getEntityReferenceCode()))) {
            throw new TreasuryDomainException("error.SibsOutputFile.selected.paymentCodePools.entityReferenceCode.differ", new String[0]);
        }
        SibsOutgoingPaymentFile sibsOutgoingPaymentFile = new SibsOutgoingPaymentFile(sourceInstitutionId, destinationInstitutionId, entityReferenceCode, lastSuccessfulSentDateTime);
        for (SibsReferenceCode referenceCode : this.getNotPaidReferenceCodes(paymentCodePoolsToInclude, errorsBuilder)) {
            this.addCalculatedPaymentCodesFromEvent(sibsOutgoingPaymentFile, referenceCode, errorsBuilder);
        }
        return sibsOutgoingPaymentFile.render();
    }

    @Deprecated
    protected String createPaymentFile(FinantialInstitution finantialInstitution, String sibsEntityReferenceCode, DateTime lastSuccessfulSentDateTime, StringBuilder errorsBuilder) {
        SibsPaymentCodePool pool = SibsPaymentCodePool.find(finantialInstitution).filter(p -> sibsEntityReferenceCode.equals(p.getEntityReferenceCode())).findFirst().get();
        SibsOutgoingPaymentFile sibsOutgoingPaymentFile = new SibsOutgoingPaymentFile(pool.getSourceInstitutionId(), pool.getDestinationInstitutionId(), sibsEntityReferenceCode, lastSuccessfulSentDateTime);
        for (SibsReferenceCode referenceCode : this.getNotPaidReferenceCodes(finantialInstitution, sibsEntityReferenceCode, errorsBuilder)) {
            this.addCalculatedPaymentCodesFromEvent(sibsOutgoingPaymentFile, referenceCode, errorsBuilder);
        }
        return sibsOutgoingPaymentFile.render();
    }

    @Deprecated
    private Set<SibsReferenceCode> getNotPaidReferenceCodes(FinantialInstitution finantialInstitution, String sibsEntityReferenceCode, StringBuilder errorsBuilder) {
        return SibsPaymentCodePool.find(finantialInstitution).filter(p -> sibsEntityReferenceCode.equals(p.getEntityReferenceCode())).flatMap(SibsPaymentCodePool::getPaymentCodesToExport).collect(Collectors.toSet());
    }

    private Set<SibsReferenceCode> getNotPaidReferenceCodes(Set<SibsPaymentCodePool> paymentCodePoolsToInclude, StringBuilder errorsBuilder) {
        return paymentCodePoolsToInclude.stream().flatMap(SibsPaymentCodePool::getPaymentCodesToExport).collect(Collectors.toSet());
    }

    private void appendToErrors(StringBuilder errorsBuilder, String externalId, Throwable e) {
        errorsBuilder.append("Error in : " + externalId + "-" + e.getLocalizedMessage()).append("\n");
        this.setErrorLog(errorsBuilder.toString());
    }

    protected void addCalculatedPaymentCodesFromEvent(SibsOutgoingPaymentFile file, SibsReferenceCode referenceCode, StringBuilder errorsBuilder) {
        try {
            file.addAssociatedPaymentCode(referenceCode);
            file.addLine(referenceCode.getReferenceCode(), referenceCode.getMinAmount(), referenceCode.getMaxAmount(), referenceCode.getValidFrom(), referenceCode.getValidTo());
        }
        catch (Throwable e) {
            this.appendToErrors(errorsBuilder, referenceCode.getExternalId(), e);
        }
    }

    private String outgoingFilename() {
        return String.format("SIBS-%s.txt", new DateTime().toString("dd-MM-yyyy_H_m_s"));
    }

    @Override
    public boolean isAccessible(String username) {
        return true;
    }

    protected void init(FinantialInstitution finantialInstitution, String errorLog, String infoLog, String printedPaymentCodes) {
        this.setFinantialInstitution(finantialInstitution);
        this.setErrorLog(errorLog);
        this.setInfoLog(infoLog);
        this.setPrintedPaymentCodes(printedPaymentCodes);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void edit(FinantialInstitution finantialInstitution, String string, String string2, String string3) {
        Object object = advice$edit.perform((Callable)new SibsOutputFile$callable$edit(this, finantialInstitution, string, string2, string3));
    }

    static /* synthetic */ void advised$edit(SibsOutputFile this_, FinantialInstitution finantialInstitution, String errorLog, String infoLog, String printedPaymentCodes) {
        this_.setFinantialInstitution(finantialInstitution);
        this_.setErrorLog(errorLog);
        this_.setInfoLog(infoLog);
        this_.setPrintedPaymentCodes(printedPaymentCodes);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsOutputFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsOutputFile this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setFinantialInstitution(null);
        this_.setDomainRoot(null);
        services.deleteFile(this_);
        super.deleteDomainObject();
    }

    public static Stream<SibsOutputFile> findAll() {
        return FenixFramework.getDomainRoot().getSibsOutputFilesSet().stream();
    }

    public static Stream<SibsOutputFile> findByFinantialInstitution(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getSibsOutputFilesSet().stream();
    }

    public static Stream<SibsOutputFile> findByErrorLog(String errorLog) {
        return SibsOutputFile.findAll().filter(i -> errorLog.equalsIgnoreCase(i.getErrorLog()));
    }

    public static Stream<SibsOutputFile> findByInfoLog(String infoLog) {
        return SibsOutputFile.findAll().filter(i -> infoLog.equalsIgnoreCase(i.getInfoLog()));
    }

    @Deprecated
    public static SibsOutputFile create(FinantialInstitution finantialInstitution, String sibsEntityReferenceCode, DateTime lastSuccessfulSentDateTime) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        SibsOutputFile file = new SibsOutputFile();
        try {
            StringBuilder errorsBuilder = new StringBuilder();
            byte[] paymentFileContents = file.createPaymentFile(finantialInstitution, sibsEntityReferenceCode, lastSuccessfulSentDateTime, errorsBuilder).getBytes("ASCII");
            services.createFile(file, file.outgoingFilename(), CONTENT_TYPE, paymentFileContents);
            file.setLastSuccessfulExportation(lastSuccessfulSentDateTime);
            file.setErrorLog(errorsBuilder.toString());
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            builder.append(e.getLocalizedMessage()).append("\n");
            for (StackTraceElement el : e.getStackTrace()) {
                builder.append(el.toString()).append("\n");
            }
            services.createFile(file, file.outgoingFilename(), CONTENT_TYPE, new byte[0]);
            file.setLastSuccessfulExportation(lastSuccessfulSentDateTime);
            file.setErrorLog(builder.toString());
        }
        return file;
    }

    public static SibsOutputFile create(Set<SibsPaymentCodePool> paymentCodePoolsToInclude, DateTime lastSuccessfulSentDateTime) {
        try {
            ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
            SibsOutputFile file = new SibsOutputFile();
            StringBuilder errorsBuilder = new StringBuilder();
            byte[] paymentFileContents = file.createPaymentFile(paymentCodePoolsToInclude, lastSuccessfulSentDateTime, errorsBuilder).getBytes("ASCII");
            services.createFile(file, file.outgoingFilename(), CONTENT_TYPE, paymentFileContents);
            file.setLastSuccessfulExportation(lastSuccessfulSentDateTime);
            file.setErrorLog(errorsBuilder.toString());
            return file;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

