/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs.incomming;

import java.math.BigDecimal;

public class SibsIncommingPaymentFileFooter {
    private static final int[] FIELD_SIZES = new int[]{1, 8, 17, 12, 12, 50};
    private BigDecimal transactionsTotalAmount;
    private BigDecimal totalCost;

    public SibsIncommingPaymentFileFooter(BigDecimal transactionsTotalAmount, BigDecimal totalCost) {
        this.transactionsTotalAmount = transactionsTotalAmount;
        this.totalCost = totalCost;
    }

    public static SibsIncommingPaymentFileFooter buildFrom(String rawLine) {
        String[] fields = SibsIncommingPaymentFileFooter.splitLine(rawLine);
        return new SibsIncommingPaymentFileFooter(SibsIncommingPaymentFileFooter.getTransactionsTotalAmountFrom(fields), SibsIncommingPaymentFileFooter.getCostFrom(fields));
    }

    private static BigDecimal getCostFrom(String[] fields) {
        return BigDecimal.valueOf(Double.parseDouble(fields[3].substring(0, 10) + "." + fields[3].substring(10)));
    }

    private static BigDecimal getTransactionsTotalAmountFrom(String[] fields) {
        return BigDecimal.valueOf(Double.parseDouble(fields[2].substring(0, 15) + "." + fields[2].substring(15)));
    }

    private static final String[] splitLine(String line) {
        int lastIndex = 0;
        String[] result = new String[FIELD_SIZES.length];
        for (int i = 0; i < FIELD_SIZES.length; ++i) {
            result[i] = line.substring(lastIndex, lastIndex + FIELD_SIZES[i]);
            lastIndex += FIELD_SIZES[i];
        }
        return result;
    }

    public BigDecimal getTotalCost() {
        return this.totalCost;
    }

    public BigDecimal getTransactionsTotalAmount() {
        return this.transactionsTotalAmount;
    }
}

