/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$createSibsInputFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$updateLastProcessExecutionDate;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile_Base;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsInputFile
extends SibsInputFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "text/plain";
    public static final Comparator<SibsInputFile> COMPARATOR_BY_DATE;
    public static final Advice advice$delete;
    public static final Advice advice$updateLastProcessExecutionDate;
    public static final Advice advice$create;
    public static final Advice advice$createSibsInputFile;

    protected SibsInputFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    protected SibsInputFile(DateTime whenProcessedBySIBS, String filename, byte[] content, String uploader) {
        this();
        this.init(whenProcessedBySIBS, filename, content, uploader);
    }

    protected void init(DateTime whenProcessedBySIBS, String filename, byte[] content, String uploader) {
        TreasuryPlataformDependentServicesFactory.implementation().createFile(this, filename, CONTENT_TYPE, content);
        this.setWhenProcessedBySibs(whenProcessedBySIBS);
        this.setUploaderUsername(uploader);
        String sibsEntityCode = new SIBSPaymentsImporter().readSibsEntityCode(filename, content);
        this.setSibsEntityCode(sibsEntityCode);
        this.checkRules();
    }

    private void checkRules() {
    }

    public boolean isDeletable() {
        return true;
    }

    @Deprecated
    public FinantialInstitution getFinantialInstitution() {
        return super.getFinantialInstitution();
    }

    @Deprecated
    public void setFinantialInstitution(FinantialInstitution finantialInstitution) {
        super.setFinantialInstitution(finantialInstitution);
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsInputFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsInputFile this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SibsInputFile.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setFinantialInstitution(null);
        services.deleteFile(this_);
        super.deleteDomainObject();
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username, this.getFinantialInstitution());
    }

    public void updateLastProcessExecutionDate() {
        Object object = advice$updateLastProcessExecutionDate.perform((Callable)new SibsInputFile$callable$updateLastProcessExecutionDate(this));
    }

    static /* synthetic */ void advised$updateLastProcessExecutionDate(SibsInputFile this_) {
        this_.setLastProcessExecutionDate(new DateTime());
    }

    public static SibsInputFile create(DateTime dateTime, String string, byte[] byArray, String string2) {
        return (SibsInputFile)advice$create.perform((Callable)new SibsInputFile$callable$create(dateTime, string, byArray, string2));
    }

    static /* synthetic */ SibsInputFile advised$create(DateTime whenProcessedBySIBS, String filename, byte[] content, String uploader) {
        return new SibsInputFile(whenProcessedBySIBS, filename, content, uploader);
    }

    public static SibsInputFile createSibsInputFile(DateTime dateTime, String string, byte[] byArray) {
        return (SibsInputFile)advice$createSibsInputFile.perform((Callable)new SibsInputFile$callable$createSibsInputFile(dateTime, string, byArray));
    }

    static /* synthetic */ SibsInputFile advised$createSibsInputFile(DateTime whenProcessedBySibs, String filename, byte[] sibsContent) {
        try {
            String entityReferenceCode;
            SibsIncommingPaymentFile file = SibsIncommingPaymentFile.parse(filename, sibsContent);
            if (file.getHeader().getWhenProcessedBySibs().toDateTimeAtStartOfDay().compareTo((ReadableInstant)whenProcessedBySibs) != 0) {
                whenProcessedBySibs = file.getHeader().getWhenProcessedBySibs().toDateTimeAtStartOfDay();
            }
            if (!SibsPaymentCodePool.find(entityReferenceCode = file.getHeader().getEntityCode()).findAny().isPresent()) {
                throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile.poolNull", entityReferenceCode);
            }
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            SibsInputFile sibsInputFile = new SibsInputFile(whenProcessedBySibs, filename, sibsContent, loggedUsername);
            return sibsInputFile;
        }
        catch (RuntimeException ex) {
            throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile", ex.getLocalizedMessage());
        }
    }

    public static Stream<SibsInputFile> findAll() {
        return FenixFramework.getDomainRoot().getSibsInputFilesSet().stream();
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$updateLastProcessExecutionDate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createSibsInputFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_DATE = (o1, o2) -> {
            int c = o1.getCreationDate().compareTo((ReadableInstant)o2.getCreationDate());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

