/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.PaymentMethod$callable$create;
import org.fenixedu.treasury.domain.PaymentMethod$callable$delete;
import org.fenixedu.treasury.domain.PaymentMethod$callable$edit;
import org.fenixedu.treasury.domain.PaymentMethod_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentMethod
extends PaymentMethod_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PaymentMethod() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected PaymentMethod(String code, LocalizedString name, boolean availableForPaymentInApplication, boolean requirePaymentMethodReference) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setAvailableForPaymentInApplication(availableForPaymentInApplication);
        this.setRequirePaymentMethodReference(requirePaymentMethodReference);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.PaymentMethod.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.PaymentMethod.name.required", new String[0]);
        }
        if (this.getRequirePaymentMethodReference() == null) {
            throw new TreasuryDomainException("error.PaymentMethod.requirePaymentMethodReference.required", new String[0]);
        }
        PaymentMethod.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> PaymentMethod.findByName(this.getName().getContent(l)));
    }

    public boolean isAvailableForPaymentInApplication() {
        return this.getAvailableForPaymentInApplication();
    }

    public void edit(String string, LocalizedString localizedString, boolean bl, boolean bl2) {
        Object object = advice$edit.perform((Callable)new PaymentMethod$callable$edit(this, string, localizedString, bl, bl2));
    }

    static /* synthetic */ void advised$edit(PaymentMethod this_, String code, LocalizedString name, boolean availableForPaymentInApplication, boolean requirePaymentMethodReference) {
        this_.setCode(code);
        this_.setName(name);
        this_.setAvailableForPaymentInApplication(availableForPaymentInApplication);
        this_.setRequirePaymentMethodReference(requirePaymentMethodReference);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getPaymentCodePoolPaymentMethodSet().isEmpty() && this.getPaymentEntriesSet().isEmpty() && this.getReimbursementEntriesSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentMethod$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentMethod this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.PaymentMethod.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Stream<PaymentMethod> findAll() {
        return FenixFramework.getDomainRoot().getPaymentMethodsSet().stream();
    }

    public static Stream<PaymentMethod> findAvailableForPaymentInApplication() {
        return PaymentMethod.findAll().filter(l -> l.isAvailableForPaymentInApplication());
    }

    public static PaymentMethod findByCode(String code) {
        PaymentMethod result = null;
        for (PaymentMethod it : PaymentMethod.findAll().collect(Collectors.toList())) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.PaymentMethod.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static PaymentMethod findByName(String name) {
        PaymentMethod result = null;
        for (PaymentMethod it : PaymentMethod.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.PaymentMethod.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static PaymentMethod create(String string, LocalizedString localizedString, boolean bl, boolean bl2) {
        return (PaymentMethod)((Object)advice$create.perform((Callable)new PaymentMethod$callable$create(string, localizedString, bl, bl2)));
    }

    static /* synthetic */ PaymentMethod advised$create(String code, LocalizedString name, boolean availableForPaymentInApplication, boolean requirePaymentMethodReference) {
        return new PaymentMethod(code, name, availableForPaymentInApplication, requirePaymentMethodReference);
    }
}

