/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibspay.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.treasury.domain.sibspay.MbwayMandateState;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayAPIService;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayExecution;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayMandate;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayReturnStatus;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SibsPayGetInquiryMbwayMandateResponse {
    @JsonProperty(value="returnStatus")
    private SibsPayReturnStatus returnStatus = null;
    @JsonProperty(value="mandate")
    private SibsPayMandate mandate;
    @JsonProperty(value="moreElementsIndicator")
    private boolean moreElementsIndicator;
    @JsonProperty(value="execution")
    private SibsPayExecution execution = null;
    @JsonIgnore
    private String requestLog;
    @JsonIgnore
    private String responseLog;

    public boolean isOperationSuccess() {
        return this.returnStatus != null && SibsPayAPIService.isOperationSuccess(this.returnStatus.getStatusCode());
    }

    public boolean isOperationErrorUnknownAuthPayment() {
        return this.returnStatus != null && SibsPayAPIService.isUnknownMbwayAuthorizedPayment(this.returnStatus.getStatusCode());
    }

    public MbwayMandateState getCurrentMandateState() {
        if (this.getMandate() != null && StringUtils.isNotEmpty((CharSequence)this.getMandate().getMandateStatus())) {
            return switch (this.mandate.getMandateStatus()) {
                case "ACTV" -> MbwayMandateState.ACTIVE;
                case "SSPN" -> MbwayMandateState.SUSPENDED;
                case "EXPR" -> MbwayMandateState.EXPIRED;
                case "CNCL" -> MbwayMandateState.CANCELED;
                default -> throw new IllegalArgumentException("Unexpected value: " + this.mandate.getMandateStatus());
            };
        }
        return null;
    }

    public SibsPayReturnStatus getReturnStatus() {
        return this.returnStatus;
    }

    public void setReturnStatus(SibsPayReturnStatus returnStatus) {
        this.returnStatus = returnStatus;
    }

    public SibsPayMandate getMandate() {
        return this.mandate;
    }

    public void setMandates(SibsPayMandate mandate) {
        this.mandate = mandate;
    }

    public boolean isMoreElementsIndicator() {
        return this.moreElementsIndicator;
    }

    public void setMoreElementsIndicator(boolean moreElementsIndicator) {
        this.moreElementsIndicator = moreElementsIndicator;
    }

    public SibsPayExecution getExecution() {
        return this.execution;
    }

    public void setExecution(SibsPayExecution execution) {
        this.execution = execution;
    }

    public String getRequestLog() {
        return this.requestLog;
    }

    public void setRequestLog(String requestLog) {
        this.requestLog = requestLog;
    }

    public String getResponseLog() {
        return this.responseLog;
    }

    public void setResponseLog(String responseLog) {
        this.responseLog = responseLog;
    }
}

