/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paypal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.paypal.http.serializer.Json;
import com.paypal.orders.Order;
import java.io.IOException;
import java.math.BigDecimal;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.joda.time.DateTime;

public class PayPalWebhookBean
implements DigitalPlatformResultBean {
    private String resource_type;
    private String event_type;
    private Order order;

    public PayPalWebhookBean(String body) {
        JsonParser parser = new JsonParser();
        JsonObject json = (JsonObject)parser.parse(body);
        JsonElement jsonElement = json.get("resource");
        try {
            this.resource_type = json.get("resource_type").getAsString();
            this.event_type = json.get("event_type").getAsString();
            this.order = (Order)new Json().decode(jsonElement.toString(), Order.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getResource_type() {
        return this.resource_type;
    }

    public String getEvent_type() {
        return this.event_type;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setResource_type(String resource_type) {
        this.resource_type = resource_type;
    }

    public void setEvent_type(String event_type) {
        this.event_type = event_type;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public BigDecimal getAmount() {
        if ("COMPLETED".equals(this.order.status())) {
            return this.order.purchaseUnits().stream().flatMap(unit -> unit.payments().captures().stream()).map(capture -> new BigDecimal(capture.amount().value())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if ("APPROVED".equals(this.order.status())) {
            return this.order.purchaseUnits().stream().map(unit -> new BigDecimal(unit.amountWithBreakdown().value())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public String getMerchantTransactionId() {
        return null;
    }

    @Override
    public String getPaymentBrand() {
        return null;
    }

    @Override
    public DateTime getPaymentDate() {
        return DateTime.parse((String)(this.order.updateTime() == null ? this.order.createTime() : this.order.updateTime()));
    }

    @Override
    public String getPaymentResultCode() {
        return this.order.status();
    }

    @Override
    public String getPaymentResultDescription() {
        return this.event_type;
    }

    @Override
    public String getPaymentType() {
        return this.resource_type;
    }

    @Override
    public String getTimestamp() {
        return null;
    }

    @Override
    public String getTransactionId() {
        return this.order.status();
    }

    @Override
    public boolean isOperationSuccess() {
        return !"VOIDED".equals(this.order.status());
    }

    @Override
    public boolean isPaid() {
        return "COMPLETED".equals(this.order.status());
    }
}

