/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate$callable$addFile;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate$callable$create;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate$callable$delete;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate$callable$edit;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryDocumentTemplate
extends TreasuryDocumentTemplate_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected TreasuryDocumentTemplate() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TreasuryDocumentTemplate(FinantialDocumentType finantialDocumentTypes, FinantialEntity finantialEntity) {
        this();
        this.setFinantialDocumentType(finantialDocumentTypes);
        this.setFinantialEntity(finantialEntity);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialDocumentType() == null) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplate.finantialDocumentTypes.required", new String[0]);
        }
        if (this.getFinantialEntity() == null) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplate.finantialEntity.required", new String[0]);
        }
        if (TreasuryDocumentTemplate.findByFinantialDocumentTypeAndFinantialEntity(this.getFinantialDocumentType(), this.getFinantialEntity()).count() > 1L) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplate.duplicated", new String[0]);
        }
    }

    public void edit(FinantialDocumentType finantialDocumentType, FinantialEntity finantialEntity) {
        Object object = advice$edit.perform((Callable)new TreasuryDocumentTemplate$callable$edit(this, finantialDocumentType, finantialEntity));
    }

    static /* synthetic */ void advised$edit(TreasuryDocumentTemplate this_, FinantialDocumentType finantialDocumentTypes, FinantialEntity finantialEntity) {
        this_.setFinantialDocumentType(finantialDocumentTypes);
        this_.setFinantialEntity(finantialEntity);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryDocumentTemplate$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryDocumentTemplate this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplate.cannot.delete", new String[0]);
        }
        for (TreasuryDocumentTemplateFile file : this_.getTreasuryDocumentTemplateFilesSet()) {
            this_.removeTreasuryDocumentTemplateFiles(file);
            file.delete();
        }
        this_.setDomainRoot(null);
        this_.setFinantialDocumentType(null);
        this_.setFinantialEntity(null);
        this_.deleteDomainObject();
    }

    public TreasuryDocumentTemplateFile getAtiveDocumentTemplateFile() {
        for (TreasuryDocumentTemplateFile documentTemplateFile : this.getTreasuryDocumentTemplateFilesSet()) {
            if (!documentTemplateFile.getActive()) continue;
            return documentTemplateFile;
        }
        return null;
    }

    public TreasuryDocumentTemplateFile addFile(TreasuryDocumentTemplate treasuryDocumentTemplate, String string, String string2, byte[] byArray) {
        return (TreasuryDocumentTemplateFile)advice$addFile.perform((Callable)new TreasuryDocumentTemplate$callable$addFile(this, treasuryDocumentTemplate, string, string2, byArray));
    }

    static /* synthetic */ TreasuryDocumentTemplateFile advised$addFile(TreasuryDocumentTemplate this_, TreasuryDocumentTemplate documentTemplate, String displayName, String fileName, byte[] content) {
        TreasuryDocumentTemplateFile treasuryDocumentTemplateFile = TreasuryDocumentTemplateFile.create(this_, displayName, fileName, content);
        this_.activateFile(treasuryDocumentTemplateFile);
        return treasuryDocumentTemplateFile;
    }

    void activateFile(TreasuryDocumentTemplateFile treasuryDocumentTemplateFile) {
        for (TreasuryDocumentTemplateFile file : this.getTreasuryDocumentTemplateFilesSet()) {
            file.setActive(false);
        }
        treasuryDocumentTemplateFile.setActive(true);
    }

    public static TreasuryDocumentTemplate create(FinantialDocumentType finantialDocumentType, FinantialEntity finantialEntity) {
        return (TreasuryDocumentTemplate)((Object)advice$create.perform((Callable)new TreasuryDocumentTemplate$callable$create(finantialDocumentType, finantialEntity)));
    }

    static /* synthetic */ TreasuryDocumentTemplate advised$create(FinantialDocumentType finantialDocumentTypes, FinantialEntity finantialEntity) {
        return new TreasuryDocumentTemplate(finantialDocumentTypes, finantialEntity);
    }

    public static Stream<TreasuryDocumentTemplate> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryDocumentTemplatesSet().stream();
    }

    public static Stream<TreasuryDocumentTemplate> findByFinantialDocumentType(FinantialDocumentType finantialDocumentType) {
        return finantialDocumentType.getTreasuryDocumentTemplatesSet().stream();
    }

    public static Stream<TreasuryDocumentTemplate> findByFinantialEntity(FinantialEntity finantialEntity) {
        return finantialEntity.getTreasuryDocumentTemplatesSet().stream();
    }

    public static Stream<TreasuryDocumentTemplate> findByFinantialDocumentTypeAndFinantialEntity(FinantialDocumentType finantialDocumentType, FinantialEntity finantialEntity) {
        return TreasuryDocumentTemplate.findByFinantialDocumentType(finantialDocumentType).filter(i -> finantialEntity.equals((Object)i.getFinantialEntity()));
    }

    public boolean isActive() {
        return this.getAtiveDocumentTemplateFile() != null;
    }
}

