/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalCountryRegion;
import org.fenixedu.treasury.domain.FiscalYear;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatExemptionReason;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanNumberGenerator;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanGroupValidator;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.tariff.FixedAmountInterestRateType;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRateType;
import org.fenixedu.treasury.domain.tariff.InterestRateEntry;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.dto.PaymentPlans.AddictionsCalculeTypeEnum;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.standards.geographic.Country;
import pt.ist.standards.geographic.District;
import pt.ist.standards.geographic.Municipality;

public class TreasuryBootstrapper {
    private static final Object COUNTRY_PT = "PT";

    public static void bootstrap(String institutionName, String institutionInitials, String countryCode) {
        TreasuryBootstrapper.initializeFiscalRegion(countryCode);
        TreasuryBootstrapper.initializeCustomerType();
        TreasuryBootstrapper.initializeProductGroup();
        TreasuryBootstrapper.initializeVatType();
        TreasuryBootstrapper.initializeVatExemption(countryCode);
        TreasuryBootstrapper.initializePaymentMethod();
        TreasuryBootstrapper.initializeCurrency();
        TreasuryBootstrapper.initializeFinantialDocumentType();
        TreasuryBootstrapper.initializeGlobalInterestRate();
        TreasuryBootstrapper.initializeReimbursementProcessStatusType();
        TreasuryBootstrapper.initializeProducts();
        TreasuryBootstrapper.initializeTreasurySettings();
        TreasuryBootstrapper.initializePaymentPlanConfigurations();
        TreasuryBootstrapper.initializeFinantialInstituition(institutionName, institutionInitials, countryCode);
    }

    private static void initializeFiscalYear(FinantialInstitution finantialInstitution) {
        int lastYear = LocalDate.now().getYear() + 10;
        for (int year = LocalDate.now().getYear() - 10; year <= lastYear; ++year) {
            FiscalYear.create(finantialInstitution, year, new LocalDate(year, 12, 31));
        }
    }

    private static void initializePaymentPlanConfigurations() {
        LocalizedString name = TreasuryConstants.treasuryBundleI18N("TreasuryBootstrapper.paymentPlan.WITHOUT_VALIDATION", new String[0]);
        PaymentPlanGroupValidator.create(name, Boolean.TRUE);
        LocalizedString numberGeneratorName = TreasuryConstants.treasuryBundleI18N("TreasuryBootstrapper.paymentPlan.DEFAULT_GENERATOR", new String[0]);
        PaymentPlanNumberGenerator numberGenerator = PaymentPlanNumberGenerator.create(numberGeneratorName, "PP", 1);
        LocalizedString paymentPlanConfiguratorName = TreasuryConstants.treasuryBundleI18N("TreasuryBootstrapper.paymentPlan.CONFIGURATOR", new String[0]);
        LocalizedString installmentDescriptionFormat = TreasuryConstants.treasuryBundleI18N("TreasuryBootstrapper.paymentPlan.DESCRIPTION", new String[0]);
        PaymentPlanConfigurator configurator = new PaymentPlanConfigurator(paymentPlanConfiguratorName, installmentDescriptionFormat, Boolean.FALSE, AddictionsCalculeTypeEnum.AFTER_DEBIT_ENTRY, null, Product.findUniqueByCode("PAYMENT_PLAN_EMOL").get(), numberGenerator, true);
        configurator.setApplyDebitEntryInterest(Boolean.TRUE);
        configurator.setCanIncreaseInterestAmount(Boolean.FALSE);
        configurator.setActive(Boolean.TRUE);
    }

    public static void bootstrapFinantialInstitution(FinantialInstitution finantialInstitution) {
        TreasuryBootstrapper.initializeFinantialEntity(finantialInstitution);
        TreasuryBootstrapper.initializeVat(finantialInstitution);
        TreasuryBootstrapper.initializeSeries(finantialInstitution);
        TreasuryBootstrapper.initializeFinantialIntitutionProducts(finantialInstitution);
        TreasuryBootstrapper.initializeRegulationDocumentNumberSeries(finantialInstitution);
        TreasuryBootstrapper.initializeFiscalYear(finantialInstitution);
    }

    private static void initializeFiscalRegion(String countryCode) {
        FiscalCountryRegion.create("PT", TreasuryConstants.treasuryBundleI18N("label.FiscalCountryRegion.PT", new String[0]));
        FiscalCountryRegion.create("PT_MA", TreasuryConstants.treasuryBundleI18N("label.FiscalCountryRegion.PT_MA", new String[0]));
        FiscalCountryRegion.create("PT_AZ", TreasuryConstants.treasuryBundleI18N("label.FiscalCountryRegion.PT_AZ", new String[0]));
    }

    private static void initializeCustomerType() {
        CustomerType.create("ADHOC", TreasuryConstants.treasuryBundleI18N("label.CustomerType.ADHOC", new String[0]));
    }

    private static void initializeProductGroup() {
        ProductGroup.create("EMOLUMENT", TreasuryConstants.treasuryBundleI18N("label.productGroup.emolument", new String[0]));
        ProductGroup.create("OTHER", TreasuryConstants.treasuryBundleI18N("label.ProductGroup.Other", new String[0]));
    }

    private static void initializeVatType() {
        VatType.create("RED", TreasuryConstants.treasuryBundleI18N("label.VatType.RED", new String[0]));
        VatType.create("INT", TreasuryConstants.treasuryBundleI18N("label.VatType.INT", new String[0]));
        VatType.create("NOR", TreasuryConstants.treasuryBundleI18N("label.VatType.NOR", new String[0]));
        VatType.create("ISE", TreasuryConstants.treasuryBundleI18N("label.VatType.ISE", new String[0]));
    }

    private static void initializeVatExemption(String countryCode) {
        if (COUNTRY_PT.equals(countryCode)) {
            String[] codes;
            for (String code : codes = new String[]{"M01", "M02", "M04", "M05", "M06", "M07", "M09", "M10", "M11", "M12", "M13", "M14", "M15", "M16", "M19", "M20", "M21", "M25", "M30", "M31", "M32", "M33", "M40", "M41", "M42", "M43", "M99"}) {
                if (code.equals("M01")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Artigo 16.\u00ba, n.\u00ba 6 do CIVA"), "Artigo 16.\u00ba, n.\u00ba 6, al\u00edneas a) a d) do CIVA", true);
                    continue;
                }
                if (code.equals("M02")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Artigo 6.\u00ba do Decreto-Lei n.\u00ba 198/90, de 19 de junho"), "Artigo 6.\u00ba do Decreto\u2010Lei n.\u00ba 198/90, de 19 de junho", true);
                    continue;
                }
                if (code.equals("M04")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Isento artigo 13.\u00ba do CIVA"), "Isento artigo 13.\u00ba do CIVA", true);
                    continue;
                }
                if (code.equals("M05")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Isento artigo 14.\u00ba do CIVA"), "Artigo 14.\u00ba do CIVA", true);
                    continue;
                }
                if (code.equals("M06")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Isento artigo 15.\u00ba do CIVA"), "Artigo 15.\u00ba do CIVA", true);
                    continue;
                }
                if (code.equals("M07")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Isento artigo 9.\u00ba do CIVA"), "Artigo 9.\u00ba do CIVA", true);
                    continue;
                }
                if (code.equals("M09")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - n\u00e3o confere direito a dedu\u00e7\u00e3o"), "Artigo 62.\u00ba al\u00ednea b) do CIVA", true);
                    continue;
                }
                if (code.equals("M10")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA \u2013 regime de isen\u00e7\u00e3o"), "Artigo 57.\u00ba do CIVA", true);
                    continue;
                }
                if (code.equals("M11")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Regime particular do tabaco"), "Decreto-Lei n.\u00ba 346/85, de 23 de agosto", true);
                    continue;
                }
                if (code.equals("M12")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Regime da margem de lucro \u2013 Ag\u00eancias de viagens"), "Decreto-Lei n.\u00ba 221/85, de 3 de julho", true);
                    continue;
                }
                if (code.equals("M13")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Regime da margem de lucro \u2013 Bens em segunda m\u00e3o"), "Decreto-Lei n.\u00ba 199/96, de 18 de outubro", true);
                    continue;
                }
                if (code.equals("M14")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Regime da margem de lucro \u2013 Objetos de arte"), "Decreto-Lei n.\u00ba 199/96, de 18 de outubro", true);
                    continue;
                }
                if (code.equals("M15")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Regime da margem de lucro \u2013 Objetos de cole\u00e7\u00e3o e antiguidades"), "Decreto-Lei n.\u00ba 199/96, de 18 de outubro", true);
                    continue;
                }
                if (code.equals("M16")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Isento artigo 14.\u00ba do RITI"), "Artigo 14.\u00ba do RITI", true);
                    continue;
                }
                if (code.equals("M19")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Outras isen\u00e7\u00f5es"), "Isen\u00e7\u00f5es tempor\u00e1rias determinadas em diploma pr\u00f3prio", true);
                    continue;
                }
                if (code.equals("M20")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - regime forfet\u00e1rio"), "Artigo 59.\u00ba-D n.\u00ba2 do CIVA", true);
                    continue;
                }
                if (code.equals("M21")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA \u2013 n\u00e3o confere direito \u00e0 dedu\u00e7\u00e3o (ou express\u00e3o similar)"), "Artigo 72.\u00ba n.\u00ba 4 do CIVA", true);
                    continue;
                }
                if (code.equals("M25")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("Mercadorias \u00e0 consigna\u00e7\u00e3o"), "Artigo 38.\u00ba n.\u00ba 1 al\u00ednea a)", true);
                    continue;
                }
                if (code.equals("M30")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - autoliquida\u00e7\u00e3o"), "Artigo 2.\u00ba n.\u00ba 1 al\u00ednea i) do CIVA", true);
                    continue;
                }
                if (code.equals("M31")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - autoliquida\u00e7\u00e3o"), "Artigo 2.\u00ba n.\u00ba 1 al\u00ednea j) do CIVA", true);
                    continue;
                }
                if (code.equals("M32")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - autoliquida\u00e7\u00e3o"), "Artigo 2.\u00ba n.\u00ba 1 al\u00ednea l) do CIVA", true);
                    continue;
                }
                if (code.equals("M33")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - autoliquida\u00e7\u00e3o"), "Artigo 2.\u00ba n.\u00ba 1 al\u00ednea m) do CIVA", true);
                    continue;
                }
                if (code.equals("M40")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - autoliquida\u00e7\u00e3o"), "Artigo 6.\u00ba n.\u00ba 6 al\u00ednea a) do CIVA, a contr\u00e1rio", true);
                    continue;
                }
                if (code.equals("M41")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - autoliquida\u00e7\u00e3o"), "Artigo 8.\u00ba n.\u00ba 3 do RITI", true);
                    continue;
                }
                if (code.equals("M42")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - autoliquida\u00e7\u00e3o"), "Decreto-Lei n.\u00ba 21/2007, de 29 de janeiro", true);
                    continue;
                }
                if (code.equals("M43")) {
                    VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("IVA - autoliquida\u00e7\u00e3o"), "Decreto-Lei n.\u00ba 362/99, de 16 de setembro", true);
                    continue;
                }
                if (!code.equals("M99")) continue;
                VatExemptionReason.create(code, TreasuryBootstrapper.defaultLs("N\u00e3o sujeito ou n\u00e3o tributado"), "Outras situa\u00e7\u00f5es de n\u00e3o liquida\u00e7\u00e3o do imposto (Exemplos: artigo 2.\u00ba, n.\u00ba 2 ; artigo 3.\u00ba, n.\u00bas 4, 6 e 7; artigo 4.\u00ba, n.\u00ba 5, todos do CIVA)", true);
            }
        }
    }

    private static LocalizedString defaultLs(String value) {
        return new LocalizedString(Locale.getDefault(), value);
    }

    private static void initializePaymentMethod() {
        PaymentMethod p = PaymentMethod.create("NU", TreasuryConstants.treasuryBundleI18N("label.PaymentMethod.MON", new String[0]), true, false);
        p.setSaftCode("NU");
        p = PaymentMethod.create("TB", TreasuryConstants.treasuryBundleI18N("label.PaymentMethod.WTR", new String[0]), true, false);
        p.setSaftCode("TB");
        p = PaymentMethod.create("MB", TreasuryConstants.treasuryBundleI18N("label.PaymentMethod.MB", new String[0]), true, false);
        p.setSaftCode("MB");
        p = PaymentMethod.create("CD", TreasuryConstants.treasuryBundleI18N("label.PaymentMethod.CCR", new String[0]), true, false);
        p.setSaftCode("CD");
        p = PaymentMethod.create("CH", TreasuryConstants.treasuryBundleI18N("label.PaymentMethod.CH", new String[0]), true, false);
        p.setSaftCode("CH");
        p = PaymentMethod.create("MW", TreasuryConstants.treasuryBundleI18N("label.PaymentMethod.MW", new String[0]), true, false);
        p.setSaftCode("OU");
        p = PaymentMethod.create("CC", TreasuryConstants.treasuryBundleI18N("label.PaymentMethod.CC", new String[0]), true, false);
        p.setSaftCode("CC");
    }

    private static void initializeCurrency() {
        Currency.create("EUR", TreasuryConstants.treasuryBundleI18N("label.Currency.EUR", new String[0]), "EUR", "\u20ac");
    }

    private static void initializeFinantialDocumentType() {
        FinantialDocumentType.createForCreditNote("NA", TreasuryConstants.treasuryBundleI18N("label.FinantialDocumentType.CreditNote", new String[0]), "NA", true);
        FinantialDocumentType.createForDebitNote("ND", TreasuryConstants.treasuryBundleI18N("label.FinantialDocumentType.DebitNote", new String[0]), "ND", true);
        FinantialDocumentType.createForSettlementNote("NP", TreasuryConstants.treasuryBundleI18N("label.FinantialDocumentType.SettlementNote", new String[0]), "NP", true);
        FinantialDocumentType.createForReimbursementNote("NR", TreasuryConstants.treasuryBundleI18N("label.FinantialDocumentType.ReimbursementNote", new String[0]), "NR", true);
    }

    private static void initializeGlobalInterestRate() {
        GlobalInterestRateType globalInterestRateType;
        if (!GlobalInterestRateType.findUnique().isPresent()) {
            globalInterestRateType = GlobalInterestRateType.create(TreasuryConstants.treasuryBundleI18N("label.GlobalInterestRateType.default.description", new String[0]));
            globalInterestRateType.activate();
            globalInterestRateType.makeDefault();
        }
        globalInterestRateType = GlobalInterestRateType.findUnique().get();
        if (!FixedAmountInterestRateType.findUnique().isPresent()) {
            FixedAmountInterestRateType fixedAmountInterestRateType = FixedAmountInterestRateType.create(TreasuryConstants.treasuryBundleI18N("label.FixedAmountInterestRateType.default.description", new String[0]));
            fixedAmountInterestRateType.activate();
        }
        for (int year = 1995; year <= new LocalDate().getYear(); ++year) {
            LocalDate firstDayOfYear = new LocalDate(year, 1, 1);
            if (InterestRateEntry.findUniqueByStartDate((InterestRateType)((Object)globalInterestRateType), firstDayOfYear).isPresent()) continue;
            InterestRateEntry.create((InterestRateType)((Object)globalInterestRateType), firstDayOfYear, TreasuryConstants.treasuryBundleI18N("label.interest.for.year", String.valueOf(year)), BigDecimal.ZERO, true, false);
        }
    }

    private static void initializeTreasurySettings() {
        TreasurySettings instance = TreasurySettings.getInstance();
        instance.edit(Currency.findByCode(Currency.EURO_CODE), Product.findUniqueByCode("INTEREST").get(), Product.findUniqueByCode("PAGAMENTO").get(), 1, Boolean.FALSE);
        instance.setMbPaymentMethod(PaymentMethod.findByCode("MB"));
        instance.setMbWayPaymentMethod(PaymentMethod.findByCode("MW"));
        instance.setCreditCardPaymentMethod(PaymentMethod.findByCode("CC"));
    }

    private static void initializeReimbursementProcessStatusType() {
        ReimbursementProcessStatusType.create("PENDING", TreasuryConstants.treasuryBundleI18N("TreasuryBootstrapper.ReimbursementProcessStatusType.PENDING", new String[0]).getContent(Locale.getDefault()), 1, true, false, false);
        ReimbursementProcessStatusType.create("ANNULED", TreasuryConstants.treasuryBundleI18N("TreasuryBootstrapper.ReimbursementProcessStatusType.ANNULED", new String[0]).getContent(Locale.getDefault()), 2, false, true, true);
        ReimbursementProcessStatusType.create("CONCLUDED", TreasuryConstants.treasuryBundleI18N("TreasuryBootstrapper.ReimbursementProcessStatusType.CONCLUDED", new String[0]).getContent(Locale.getDefault()), 3, false, true, false);
    }

    private static FinantialInstitution initializeFinantialInstituition(String institutionName, String institutionInitials, String countryCode) {
        FiscalCountryRegion fiscalCountryRegion = FiscalCountryRegion.findByRegionCode(countryCode);
        Currency currency = Currency.findByCode(Currency.EURO_CODE);
        String code = institutionInitials;
        String fiscalNumber = "999999990";
        String companyId = null;
        String name = institutionName;
        String companyName = institutionName;
        String address = null;
        Country country = null;
        District district = null;
        Municipality municipality = null;
        String locality = null;
        String zipCode = null;
        FinantialInstitution institution = FinantialInstitution.create(fiscalCountryRegion, currency, code, fiscalNumber, companyId, name, companyName, address, country, district, municipality, locality, zipCode);
        institution.setSplitCreditEntriesWithSettledAmount(true);
        institution.setSplitDebitEntriesWithSettledAmount(false);
        institution.setSupportCreditTreasuryExemptions(false);
        return institution;
    }

    private static FinantialEntity initializeFinantialEntity(FinantialInstitution finantialInstitution) {
        return FinantialEntity.create(finantialInstitution, finantialInstitution.getCode() + "_ACADEMIC", TreasuryConstants.treasuryBundleI18N("label.finantialEntity.name", finantialInstitution.getCode()));
    }

    private static void initializeVat(FinantialInstitution finantialInstitution) {
        VatType type;
        if (!finantialInstitution.getVatsSet().stream().anyMatch(x -> x.getVatType().getCode().equals("ISE"))) {
            Vat.create(VatType.findByCode("ISE"), finantialInstitution, BigDecimal.ZERO, TreasuryBootstrapper.fromDate(1980, 1, 1), TreasuryBootstrapper.toDate(2100, 12, 31));
        }
        if (!finantialInstitution.getVatsSet().stream().anyMatch(x -> x.getVatType().getCode().equals("RED"))) {
            type = VatType.findByCode("RED");
            Vat.create(type, finantialInstitution, BigDecimal.valueOf(8L), TreasuryBootstrapper.fromDate(1986, 1, 1), TreasuryBootstrapper.toDate(1992, 3, 23));
            Vat.create(type, finantialInstitution, BigDecimal.valueOf(5L), TreasuryBootstrapper.fromDate(1992, 3, 24), TreasuryBootstrapper.toDate(2010, 6, 30));
            Vat.create(type, finantialInstitution, BigDecimal.valueOf(6L), TreasuryBootstrapper.fromDate(2011, 7, 1), TreasuryBootstrapper.toDate(2100, 12, 31));
        }
        if (!finantialInstitution.getVatsSet().stream().anyMatch(x -> x.getVatType().getCode().equals("INT"))) {
            type = VatType.findByCode("INT");
            Vat.create(type, finantialInstitution, BigDecimal.valueOf(12L), TreasuryBootstrapper.fromDate(1996, 7, 1), TreasuryBootstrapper.toDate(2010, 6, 30));
            Vat.create(type, finantialInstitution, BigDecimal.valueOf(13L), TreasuryBootstrapper.fromDate(2011, 7, 1), TreasuryBootstrapper.toDate(2100, 12, 31));
        }
        if (!finantialInstitution.getVatsSet().stream().anyMatch(x -> x.getVatType().getCode().equals("NOR"))) {
            VatType taxaNormal = VatType.findByCode("NOR");
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(16L), TreasuryBootstrapper.fromDate(1986, 1, 1), TreasuryBootstrapper.toDate(1988, 1, 31));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(17L), TreasuryBootstrapper.fromDate(1988, 2, 1), TreasuryBootstrapper.toDate(1992, 3, 23));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(16L), TreasuryBootstrapper.fromDate(1992, 3, 24), TreasuryBootstrapper.toDate(1994, 12, 31));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(17L), TreasuryBootstrapper.fromDate(1995, 1, 1), TreasuryBootstrapper.toDate(1996, 6, 30));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(17L), TreasuryBootstrapper.fromDate(1996, 7, 1), TreasuryBootstrapper.toDate(2002, 6, 4));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(19L), TreasuryBootstrapper.fromDate(2002, 6, 5), TreasuryBootstrapper.toDate(2005, 6, 30));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(21L), TreasuryBootstrapper.fromDate(2005, 7, 1), TreasuryBootstrapper.toDate(2008, 6, 30));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(20L), TreasuryBootstrapper.fromDate(2008, 7, 1), TreasuryBootstrapper.toDate(2010, 6, 30));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(21L), TreasuryBootstrapper.fromDate(2010, 7, 1), TreasuryBootstrapper.toDate(2010, 12, 31));
            Vat.create(taxaNormal, finantialInstitution, BigDecimal.valueOf(23L), TreasuryBootstrapper.fromDate(2011, 1, 1), TreasuryBootstrapper.toDate(2100, 12, 31));
        }
    }

    private static void initializeSeries(FinantialInstitution finantialInstitution) {
        Series.create(finantialInstitution, "INT", TreasuryConstants.treasuryBundleI18N("label.internal.serie", new String[0]), true, false, true, true);
        Series.create(finantialInstitution, "LEG", TreasuryConstants.treasuryBundleI18N("label.legacy.serie", new String[0]), true, true, false, true);
        Series.create(finantialInstitution, "REG", TreasuryConstants.treasuryBundleI18N("label.reg.serie", new String[0]), true, false, false, false);
        Series.create(finantialInstitution, "EXT", TreasuryConstants.treasuryBundleI18N("label.external.serie", new String[0]), true, false, false, false);
    }

    private static void initializeProducts() {
        Product.create(ProductGroup.findByCode("OTHER"), "INTEREST", TreasuryConstants.treasuryBundleI18N("label.interest", new String[0]), TreasuryConstants.treasuryBundleI18N("label.unit", new String[0]), true, false, 0, VatType.findByCode("ISE"), null, null);
        Product.create(ProductGroup.findByCode("OTHER"), "PAGAMENTO", TreasuryConstants.treasuryBundleI18N("label.advancedPayment", new String[0]), TreasuryConstants.treasuryBundleI18N("label.unit", new String[0]), true, false, 0, VatType.findByCode("ISE"), null, null);
        Product.create(ProductGroup.findByCode("EMOLUMENT"), "PAYMENT_PLAN_EMOL", TreasuryConstants.treasuryBundleI18N("label.paymentPlanEmolumentProduct", new String[0]), TreasuryConstants.treasuryBundleI18N("label.unit", new String[0]), true, false, 0, VatType.findByCode("ISE"), null, null);
    }

    private static void initializeFinantialIntitutionProducts(FinantialInstitution finantialInstitution) {
        ArrayList<FinantialInstitution> finantialInstitutions;
        Product product;
        if (Product.findUniqueByCode("INTEREST").isPresent()) {
            product = Product.findUniqueByCode("INTEREST").get();
            finantialInstitutions = new ArrayList<FinantialInstitution>(product.getFinantialInstitutionsSet());
            finantialInstitutions.add(finantialInstitution);
            product.updateFinantialInstitutions(finantialInstitutions);
            product.setVatExemptionReason(VatExemptionReason.findByCode("M01"));
        }
        if (Product.findUniqueByCode("PAGAMENTO").isPresent()) {
            product = Product.findUniqueByCode("PAGAMENTO").get();
            finantialInstitutions = new ArrayList(product.getFinantialInstitutionsSet());
            finantialInstitutions.add(finantialInstitution);
            product.updateFinantialInstitutions(finantialInstitutions);
            product.setVatExemptionReason(VatExemptionReason.findByCode("M01"));
        }
        if (Product.findUniqueByCode("PAYMENT_PLAN_EMOL").isPresent()) {
            product = Product.findUniqueByCode("PAYMENT_PLAN_EMOL").get();
            finantialInstitutions = new ArrayList(product.getFinantialInstitutionsSet());
            finantialInstitutions.add(finantialInstitution);
            product.updateFinantialInstitutions(finantialInstitutions);
            product.setVatExemptionReason(VatExemptionReason.findByCode("M07"));
        }
    }

    private static void initializeRegulationDocumentNumberSeries(FinantialInstitution finantialInstitution) {
        Series regulationSeries = Series.findByCode("REG");
        if (regulationSeries.getFinantialInstitution() != finantialInstitution) {
            throw new IllegalStateException("finantial institution of series differ");
        }
        finantialInstitution.setRegulationSeries(regulationSeries);
        DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), regulationSeries).editReplacingPrefix(true, "NY");
        DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), regulationSeries).editReplacingPrefix(true, "NZ");
    }

    private static DateTime fromDate(int year, int month, int day) {
        return new DateTime(year, month, day, 0, 0, 0);
    }

    private static DateTime toDate(int year, int month, int day) {
        return new DateTime(year, month, day, 23, 59, 59);
    }
}

