/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.accesscontrol.spi;

import com.google.common.reflect.TypeToken;
import java.util.Set;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.SettlementNote;

public interface ITreasuryAccessControlExtension<T> {
    default public boolean isFrontOfficeMember(String username) {
        return false;
    }

    default public boolean isFrontOfficeMember(String username, FinantialInstitution finantialInstitution) {
        return false;
    }

    default public boolean isFrontOfficeMember(String username, FinantialEntity finantialEntity) {
        return false;
    }

    default public boolean isFrontOfficeMemberWithinContext(String username, T context) {
        return false;
    }

    default public boolean isBackOfficeMember(String username) {
        return false;
    }

    default public boolean isBackOfficeMember(String username, FinantialInstitution finantialInstitution) {
        return false;
    }

    default public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        return false;
    }

    default public boolean isBackOfficeMemberWithinContext(String username, T context) {
        return false;
    }

    default public boolean isManager(String username) {
        return false;
    }

    default public boolean isAllowToModifySettlements(String username, FinantialInstitution finantialInstitution) {
        return false;
    }

    default public boolean isAllowToModifyInvoices(String username, FinantialInstitution finantialInstitution) {
        return false;
    }

    default public boolean isAllowToConditionallyAnnulSettlementNote(String username, SettlementNote settlementNote) {
        return false;
    }

    default public boolean isAllowToAnnulSettlementNoteWithoutAnyRestriction(String username, SettlementNote settlementNote) {
        return false;
    }

    default public boolean hasPermission(String username, String permissionCode, FinantialEntity finantialEntity) {
        return false;
    }

    default public boolean isContextObjectApplied(Object context) {
        TypeToken typeToken = new TypeToken<T>(this.getClass()){};
        return context.getClass().isAssignableFrom(typeToken.getRawType());
    }

    public Set<String> getFrontOfficeMemberUsernames();

    public Set<String> getBackOfficeMemberUsernames();

    public Set<String> getTreasuryManagerMemberUsernames();
}

