/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.InterestRateEntry_Base;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.fenixframework.FenixFramework;

public class InterestRateEntry
extends InterestRateEntry_Base {
    public static final Comparator<? super InterestRateEntry> FIRST_DATE_COMPARATOR = (o1, o2) -> {
        int c = o1.getStartDate().compareTo((ReadablePartial)o2.getStartDate());
        return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
    };

    public InterestRateEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public InterestRateEntry(InterestRateType interestRateType) {
        this();
        this.setInterestRateType(interestRateType);
    }

    public InterestRateEntry(InterestRateType interestRateType, LocalDate startDate, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        this(interestRateType);
        super.setStartDate(startDate);
        super.setDescription(description);
        super.setRate(rate);
        super.setApplyPaymentMonth(Boolean.valueOf(applyPaymentMonth));
        super.setApplyInFirstWorkday(Boolean.valueOf(applyInFirstWorkday));
        this.checkRules();
    }

    private void checkRules() {
        if (this.getStartDate() == null) {
            throw new TreasuryDomainException("error.InterestRateEntry.startDate.required", new String[0]);
        }
        if (InterestRateEntry.findByStartDate(this.getInterestRateType(), this.getStartDate()).count() > 1L) {
            throw new TreasuryDomainException("error.InterestRateEntry.startDate.duplicated", new String[0]);
        }
        if (this.getRate() == null) {
            throw new TreasuryDomainException("error.InterestRateEntry.rate.with.valid.value.required", new String[0]);
        }
        if (this.getApplyPaymentMonth() == null) {
            throw new TreasuryDomainException("error.InterestRateEntry.applyPaymentMonth.required", new String[0]);
        }
        if (this.getApplyInFirstWorkday() == null) {
            throw new TreasuryDomainException("error.InterestRateEntry.applyInFirstWorkday.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getDescription().getContent())) {
            throw new TreasuryDomainException("error.InterestRateEntry.description.required", new String[0]);
        }
        if (TreasuryConstants.isLessThan(this.getRate(), BigDecimal.ZERO) || TreasuryConstants.isGreaterThan(this.getRate(), TreasuryConstants.HUNDRED_PERCENT)) {
            throw new TreasuryDomainException("error.InterestRateEntry.rate.with.valid.value.required", new String[0]);
        }
    }

    public void edit(LocalDate startDate, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        this.setStartDate(startDate);
        this.setDescription(description);
        this.setRate(rate);
        this.setApplyPaymentMonth(applyPaymentMonth);
        this.setApplyInFirstWorkday(applyInFirstWorkday);
        this.checkRules();
    }

    public void delete() {
        this.setDomainRoot(null);
        this.setInterestRateType(null);
        super.deleteDomainObject();
    }

    public Integer getYear() {
        return this.getStartDate().getYear();
    }

    public Boolean getApplyInFirstWorkday() {
        return super.getApplyInFirstWorkday();
    }

    public static Stream<InterestRateEntry> findByYear(InterestRateType interestRateType, int year) {
        return interestRateType.getInterestRateEntriesSet().stream().filter(entry -> entry.getYear() == year);
    }

    public static Stream<InterestRateEntry> findByStartDate(InterestRateType interestRateType, LocalDate date) {
        return interestRateType.getInterestRateEntriesSet().stream().filter(r -> r.getStartDate().equals((Object)date));
    }

    public static Optional<InterestRateEntry> findUniqueByStartDate(InterestRateType interestRateType, LocalDate date) {
        return InterestRateEntry.findByStartDate(interestRateType, date).findFirst();
    }

    public static Optional<InterestRateEntry> findUniqueAppliedForDate(InterestRateType interestRateType, LocalDate date) {
        return interestRateType.getInterestRateEntriesSet().stream().filter(r -> !r.getStartDate().isAfter((ReadablePartial)date)).sorted(FIRST_DATE_COMPARATOR.reversed()).findFirst();
    }

    public static InterestRateEntry create(InterestRateType interestRateType, LocalDate startDate, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        return new InterestRateEntry(interestRateType, startDate, description, rate, applyPaymentMonth, applyInFirstWorkday);
    }
}

