/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.payments.integration;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode_Base;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class DigitalPaymentPlatformPaymentMode
extends DigitalPaymentPlatformPaymentMode_Base {
    public static final Comparator<DigitalPaymentPlatformPaymentMode> COMPARE_BY_ORDER = Comparator.comparing(DigitalPaymentPlatformPaymentMode_Base::getPaymentModeOrder).thenComparing(AbstractDomainObject::getExternalId);

    public DigitalPaymentPlatformPaymentMode() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setActiveForFrontend(false);
    }

    public DigitalPaymentPlatformPaymentMode(DigitalPaymentPlatform platform, PaymentMethod paymentMethod) {
        this();
        List<DigitalPaymentPlatformPaymentMode> orderedPaymentModesList = platform.getOrderedPaymentModesList();
        this.setDigitalPaymentPlatform(platform);
        this.setPaymentMethod(paymentMethod);
        this.setActive(true);
        this.setPaymentModeOrder(!orderedPaymentModesList.isEmpty() ? orderedPaymentModesList.get(orderedPaymentModesList.size() - 1).getPaymentModeOrder() + 1 : 1);
        this.getDigitalPaymentPlatform().orderPaymentModes();
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.DigitalPaymentPlatformPaymentMode.domainRoot.required", new String[0]);
        }
        if (this.getPaymentMethod() == null) {
            throw new TreasuryDomainException("error.DigitalPaymentPlatformPaymentMode.paymentMethod.required", new String[0]);
        }
        if (DigitalPaymentPlatformPaymentMode.find(this.getDigitalPaymentPlatform(), this.getPaymentMethod()).count() > 1L) {
            throw new TreasuryDomainException("error.DigitalPaymentPlatformPaymentMode.duplicated", new String[0]);
        }
    }

    public boolean isDigitalPaymentPlatformAndPaymentModeActive() {
        return this.isDigitalPaymentPlatformAndPaymentModeActive(false);
    }

    private boolean isDigitalPaymentPlatformAndPaymentModeActive(boolean isForFrontend) {
        return this.getDigitalPaymentPlatform().isActive() && this.isActive() && (!isForFrontend || Boolean.TRUE.equals(this.getActiveForFrontend()));
    }

    public boolean isActive() {
        return this.getActive();
    }

    public void activate() {
        this.setActive(true);
    }

    public void deactivate() {
        this.setActive(false);
    }

    public LocalizedString getDigitalPaymentPlatformPaymentMethodDesignation() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        LocalizedString result = new LocalizedString();
        for (Locale locale : services.availableLocales()) {
            result.with(locale, String.format("[%s] %s", this.getDigitalPaymentPlatform().getName(), this.getPaymentMethod().getName().getContent(locale)));
        }
        return result;
    }

    public void delete() {
        super.setDomainRoot(null);
        super.setDigitalPaymentPlatform(null);
        super.setPaymentMethod(null);
        super.deleteDomainObject();
    }

    public boolean isFirstInPaymentOrder() {
        int index = this.getDigitalPaymentPlatform().getOrderedPaymentModesList().indexOf((Object)this);
        return index == 0;
    }

    public boolean isLastInPaymentOrder() {
        int index = this.getDigitalPaymentPlatform().getOrderedPaymentModesList().indexOf((Object)this);
        return index == this.getDigitalPaymentPlatform().getOrderedPaymentModesList().size() - 1;
    }

    public void orderUp() {
        if (this.isFirstInPaymentOrder()) {
            return;
        }
        List<DigitalPaymentPlatformPaymentMode> orderedPaymentModesList = this.getDigitalPaymentPlatform().getOrderedPaymentModesList();
        int index = orderedPaymentModesList.indexOf((Object)this);
        DigitalPaymentPlatformPaymentMode previous = orderedPaymentModesList.get(index - 1);
        int temp = previous.getPaymentModeOrder();
        previous.setPaymentModeOrder(this.getPaymentModeOrder());
        this.setPaymentModeOrder(temp);
        this.getDigitalPaymentPlatform().orderPaymentModes();
    }

    public void orderDown() {
        if (this.isLastInPaymentOrder()) {
            return;
        }
        List<DigitalPaymentPlatformPaymentMode> orderedPaymentModesList = this.getDigitalPaymentPlatform().getOrderedPaymentModesList();
        int index = orderedPaymentModesList.indexOf((Object)this);
        DigitalPaymentPlatformPaymentMode next = orderedPaymentModesList.get(index + 1);
        int temp = next.getPaymentModeOrder();
        next.setPaymentModeOrder(this.getPaymentModeOrder());
        this.setPaymentModeOrder(temp);
        this.getDigitalPaymentPlatform().orderPaymentModes();
    }

    public static Stream<DigitalPaymentPlatformPaymentMode> findAll() {
        return FenixFramework.getDomainRoot().getDigitalPaymentPlatformPaymentModesSet().stream();
    }

    public static Stream<DigitalPaymentPlatformPaymentMode> findDigitalPaymentPlatformAndPaymentModeActive(FinantialInstitution finantialInstitution) {
        return DigitalPaymentPlatformPaymentMode.findAll().filter(pm -> pm.getDigitalPaymentPlatform().getFinantialInstitution() == finantialInstitution).filter(pm -> pm.isDigitalPaymentPlatformAndPaymentModeActive());
    }

    public static Stream<DigitalPaymentPlatformPaymentMode> findDigitalPaymentPlatformAndPaymentModeActive(FinantialInstitution finantialInstitution, boolean isForFrontend) {
        return DigitalPaymentPlatformPaymentMode.findAll().filter(pm -> pm.getDigitalPaymentPlatform().getFinantialInstitution() == finantialInstitution).filter(pm -> pm.isDigitalPaymentPlatformAndPaymentModeActive(isForFrontend));
    }

    public static Stream<DigitalPaymentPlatformPaymentMode> findDigitalPaymentPlatformAndPaymentModeActive() {
        return DigitalPaymentPlatformPaymentMode.findAll().filter(pm -> pm.isDigitalPaymentPlatformAndPaymentModeActive());
    }

    public static Stream<DigitalPaymentPlatformPaymentMode> findDigitalPaymentPlatformAndPaymentModeActive(boolean isForFrontend) {
        return DigitalPaymentPlatformPaymentMode.findAll().filter(pm -> pm.isDigitalPaymentPlatformAndPaymentModeActive(isForFrontend));
    }

    public static Stream<DigitalPaymentPlatformPaymentMode> find(DigitalPaymentPlatform platform, PaymentMethod paymentMethod) {
        return platform.getDigitalPaymentPlatformPaymentModesSet().stream().filter(p -> p.getPaymentMethod() == paymentMethod);
    }

    public static Optional<DigitalPaymentPlatformPaymentMode> findUnique(DigitalPaymentPlatform platform, PaymentMethod paymentMethod) {
        return DigitalPaymentPlatformPaymentMode.find(platform, paymentMethod).findAny();
    }

    public static DigitalPaymentPlatformPaymentMode create(DigitalPaymentPlatform platform, PaymentMethod paymentMethod) {
        return new DigitalPaymentPlatformPaymentMode(platform, paymentMethod);
    }
}

