/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.onlinepaymentsgateway.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class PrepareCheckoutInputBean {
    public BigDecimal amount;
    public String merchantTransactionId;
    public String shopperResultUrl;
    private DateTime sibsRefIntDate;
    private DateTime sibsRefLmtDate;
    public Boolean useCreditCard = false;
    public Boolean useMBway = false;
    public Boolean useMB = false;
    private String billingCountry;
    private String billingCity;
    private String billingStreet1;
    private String billingPostcode;
    private String customerEmail;
    private String cardHolder;

    public PrepareCheckoutInputBean(BigDecimal amount, String merchantTransactionId, String shopperResultUrl, DateTime sibsRefIntDate, DateTime sibsRefLmtDate) {
        this.amount = amount;
        this.merchantTransactionId = merchantTransactionId;
        this.shopperResultUrl = shopperResultUrl;
        this.sibsRefIntDate = sibsRefIntDate;
        this.sibsRefLmtDate = sibsRefLmtDate;
    }

    public PrepareCheckoutInputBean(BigDecimal amount, String merchantTransactionId, String shopperResultUrl) {
        this.amount = amount;
        this.merchantTransactionId = merchantTransactionId;
        this.shopperResultUrl = shopperResultUrl;
    }

    public PrepareCheckoutInputBean() {
    }

    public void fillBillingData(String cardHolder, String billingCountry, String billingCity, String billingStreet1, String billingPostcode, String customerEmail) {
        this.cardHolder = cardHolder;
        this.billingCountry = billingCountry;
        this.billingCity = billingCity;
        this.billingStreet1 = billingStreet1;
        this.billingPostcode = billingPostcode;
        this.customerEmail = customerEmail;
    }

    public boolean isPropertiesValid() {
        boolean returnValue = true;
        returnValue &= this.amount != null && this.amount.compareTo(BigDecimal.ZERO) > 0;
        return returnValue &= this.shopperResultUrl != null && !this.shopperResultUrl.isEmpty();
    }

    public boolean isMBPropertiesValid() {
        boolean returnValue = true;
        returnValue &= this.amount != null && this.getAmount().compareTo(BigDecimal.ZERO) > 0;
        returnValue &= this.sibsRefIntDate != null && this.sibsRefLmtDate != null && this.sibsRefIntDate.isBefore((ReadableInstant)this.sibsRefLmtDate);
        return returnValue &= this.shopperResultUrl != null && !this.shopperResultUrl.isEmpty();
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public String getShopperResultUrl() {
        return this.shopperResultUrl;
    }

    public void setShopperResultUrl(String shopperResultUrl) {
        this.shopperResultUrl = shopperResultUrl;
    }

    public String getSibsRefIntDate() {
        return this.sibsRefIntDate.toString();
    }

    public void setSibsRefIntDate(DateTime sibsRefIntDate) {
        this.sibsRefIntDate = sibsRefIntDate;
    }

    public String getSibsRefLmtDate() {
        return this.sibsRefLmtDate.toString();
    }

    public void setSibsRefLmtDate(DateTime sibsRefLmtDate) {
        this.sibsRefLmtDate = sibsRefLmtDate;
    }

    public Boolean getUseCreditCard() {
        return this.useCreditCard;
    }

    public void setUseCreditCard(Boolean useCreditCard) {
        this.useCreditCard = useCreditCard;
    }

    public Boolean getUseMBway() {
        return this.useMBway;
    }

    public void setUseMBway(Boolean useMBway) {
        this.useMBway = useMBway;
    }

    public Boolean getUseMB() {
        return this.useMB;
    }

    public void setUseMB(Boolean useMB) {
        this.useMB = useMB;
    }

    public String getBillingCountry() {
        return this.billingCountry;
    }

    public void setBillingCountry(String billingCountry) {
        this.billingCountry = billingCountry;
    }

    public String getBillingCity() {
        return this.billingCity;
    }

    public void setBillingCity(String billingCity) {
        this.billingCity = billingCity;
    }

    public String getBillingStreet1() {
        return this.billingStreet1;
    }

    public void setBillingStreet1(String billingStreet1) {
        this.billingStreet1 = billingStreet1;
    }

    public String getBillingPostcode() {
        return this.billingPostcode;
    }

    public void setBillingPostcode(String billingPostcode) {
        this.billingPostcode = billingPostcode;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    public String getCardHolder() {
        return this.cardHolder;
    }

    public void setCardHolder(String cardHolder) {
        this.cardHolder = cardHolder;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }
}

