/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.virtualpaymententries;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;

public class VirtualPaymentEntryFactory {
    private static VirtualPaymentEntryFactory _impl;
    private List<IVirtualPaymentEntryHandler> handlers = new ArrayList<IVirtualPaymentEntryHandler>();

    public static VirtualPaymentEntryFactory implementation() {
        if (_impl == null) {
            _impl = new VirtualPaymentEntryFactory();
        }
        return _impl;
    }

    public List<IVirtualPaymentEntryHandler> getHandlers() {
        return this.handlers;
    }

    public void addHandler(IVirtualPaymentEntryHandler handler) {
        this.handlers.add(handler);
    }

    public void addHandler(int index, IVirtualPaymentEntryHandler handler) {
        this.handlers.add(index, handler);
    }

    public void removeHandler(Class<? extends IVirtualPaymentEntryHandler> clazz) {
        this.handlers.removeIf(handler -> handler.getClass() == clazz);
    }
}

