/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs.incomming;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;

public class SibsIncommingPaymentFileHeader {
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final int[] FIELD_SIZES = new int[]{1, 4, 8, 8, 9, 9, 5, 3, 2, 4, 47};
    private LocalDate whenProcessedBySibs;
    private Integer version;
    private String entityCode;

    public SibsIncommingPaymentFileHeader(LocalDate whenProcessedBySibs, Integer version, String entityCode) {
        this.whenProcessedBySibs = whenProcessedBySibs;
        this.version = version;
        this.entityCode = entityCode;
    }

    public static SibsIncommingPaymentFileHeader buildFrom(String rawLine) {
        String[] fields = SibsIncommingPaymentFileHeader.splitLine(rawLine);
        return new SibsIncommingPaymentFileHeader(SibsIncommingPaymentFileHeader.getWhenProcessedBySibsFrom(fields), SibsIncommingPaymentFileHeader.getVersionFrom(fields), SibsIncommingPaymentFileHeader.getEntityCodeFrom(fields));
    }

    private static String getEntityCodeFrom(String[] fields) {
        return fields[6];
    }

    private static LocalDate getWhenProcessedBySibsFrom(String[] fields) {
        String dateStringValue = fields[4].substring(0, DATE_FORMAT.length());
        return DateTimeFormat.forPattern((String)DATE_FORMAT).parseLocalDate(dateStringValue);
    }

    private static Integer getVersionFrom(String[] fields) {
        return Integer.valueOf(fields[5].substring(DATE_FORMAT.length()));
    }

    private static final String[] splitLine(String line) {
        int lastIndex = 0;
        String[] result = new String[FIELD_SIZES.length];
        for (int i = 0; i < FIELD_SIZES.length; ++i) {
            result[i] = line.substring(lastIndex, lastIndex + FIELD_SIZES[i]);
            lastIndex += FIELD_SIZES[i];
        }
        return result;
    }

    public LocalDate getWhenProcessedBySibs() {
        return this.whenProcessedBySibs;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }
}

