/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.meowallet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.meowallet.MeoWallet;
import org.fenixedu.treasury.domain.meowallet.MeoWalletLog;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.dto.meowallet.MeoWalletCallbackBean;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.meowallet.MeoWalletWebhooksController$callable$createLog;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/wallet_callback")
public class MeoWalletWebhooksController {
    private static final Logger logger;
    private static final String NOTIFICATION_URI = "/";
    public static final Advice advice$createLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response notification(String body, @Context HttpServletRequest httpRequest, @Context HttpServletResponse response) {
        MeoWalletLog log2 = this.createLog();
        FenixFramework.atomic(() -> log2.saveRequest(body));
        Gson s = new GsonBuilder().registerTypeAdapter(DateTime.class, (json, typeOfT, context) -> new DateTime((Object)json.getAsString())).setPrettyPrinting().create();
        MeoWalletCallbackBean bean = (MeoWalletCallbackBean)s.fromJson(body, MeoWalletCallbackBean.class);
        FenixFramework.atomic(() -> {
            log2.logRequestReceiveDateAndData(bean.getOperation_id(), "Notification", bean.getEvent(), bean.getAmount(), bean.getOperation_status(), !"FAIL".equals(bean.getOperation_status()));
            log2.setExtInvoiceId(bean.getExt_invoiceid());
            log2.setMeoWalletId(bean.getOperation_id());
            log2.setTransactionWithPayment("COMPLETED".equals(bean.getOperation_status()));
        });
        boolean mockedUser = false;
        try {
            Optional<Object> referenceCodeOptional = Optional.ofNullable(null);
            Optional<Object> mbwayPaymentRequestOptional = Optional.ofNullable(null);
            Optional<Object> forwardPaymentRequesteOptional = Optional.ofNullable(null);
            if (!StringUtils.isEmpty((String)bean.getExt_invoiceid())) {
                referenceCodeOptional = SibsPaymentRequest.findBySibsGatewayMerchantTransactionId(bean.getExt_invoiceid()).findFirst();
                mbwayPaymentRequestOptional = MbwayRequest.findUniqueBySibsGatewayMerchantTransactionId(bean.getExt_invoiceid());
                forwardPaymentRequesteOptional = ForwardPaymentRequest.findUniqueByMerchantTransactionId(bean.getExt_invoiceid());
            }
            if (referenceCodeOptional.isPresent()) {
                digitalPaymentPlatform = (MeoWallet)((Object)((SibsPaymentRequest)referenceCodeOptional.get()).getDigitalPaymentPlatform());
                mockedUser = this.mockUserIfNeeded(digitalPaymentPlatform);
                if (!digitalPaymentPlatform.isActive()) {
                    throw new Exception("MeoWallet not active, payment will not be processed");
                }
                if (!digitalPaymentPlatform.getMeoWalletService().verifyCallback(body)) {
                    throw new Exception("callback not verified");
                }
                SibsPaymentRequest paymentReferenceCode = (SibsPaymentRequest)((Object)referenceCodeOptional.get());
                FenixFramework.atomic(() -> log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)paymentReferenceCode)))));
                digitalPaymentPlatform.processPaymentReferenceCodeTransaction(log2, (DigitalPlatformResultBean)bean);
            } else if (mbwayPaymentRequestOptional.isPresent()) {
                digitalPaymentPlatform = (MeoWallet)((Object)((MbwayRequest)mbwayPaymentRequestOptional.get()).getDigitalPaymentPlatform());
                mockedUser = this.mockUserIfNeeded(digitalPaymentPlatform);
                if (!digitalPaymentPlatform.isActive()) {
                    throw new Exception("MeoWallet not active, payment will not be processed");
                }
                if (!digitalPaymentPlatform.getMeoWalletService().verifyCallback(body)) {
                    throw new Exception("callback not verified");
                }
                MbwayRequest mbwayRequest = (MbwayRequest)((Object)mbwayPaymentRequestOptional.get());
                FenixFramework.atomic(() -> log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)mbwayRequest)))));
                digitalPaymentPlatform.processMbwayTransaction(log2, (DigitalPlatformResultBean)bean);
            } else if (forwardPaymentRequesteOptional.isPresent()) {
                digitalPaymentPlatform = (MeoWallet)((Object)((ForwardPaymentRequest)forwardPaymentRequesteOptional.get()).getDigitalPaymentPlatform());
                mockedUser = this.mockUserIfNeeded(digitalPaymentPlatform);
                if (!digitalPaymentPlatform.isActive()) {
                    throw new Exception("MeoWallet not active, payment will not be processed");
                }
                if (!digitalPaymentPlatform.getMeoWalletService().verifyCallback(body)) {
                    throw new Exception("callback not verified");
                }
                ForwardPaymentRequest forwardPaymentRequest = (ForwardPaymentRequest)((Object)forwardPaymentRequesteOptional.get());
                FenixFramework.atomic(() -> log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)forwardPaymentRequest)))));
                digitalPaymentPlatform.processForwardPaymentFromWebhook((PaymentRequestLog)((Object)log2), bean);
            } else {
                FenixFramework.atomic(() -> log2.logRequestReceiveDateAndData(bean.getTransactionId(), "Notification", bean.getPaymentType(), bean.getAmount(), bean.getPaymentResultCode(), !"FAIL".equals(bean.getPaymentResultCode())));
            }
            Response response2 = Response.ok().build();
            return response2;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            if (log2 != null) {
                FenixFramework.atomic(() -> log2.logException(e));
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    OnlinePaymentsGatewayCommunicationException oe = (OnlinePaymentsGatewayCommunicationException)e;
                    FenixFramework.atomic(() -> {
                        log2.saveRequest(oe.getRequestLog());
                        log2.saveResponse(oe.getResponseLog());
                    });
                }
            }
            Response response3 = Response.serverError().build();
            return response3;
        }
        finally {
            if (mockedUser) {
                TreasuryPlataformDependentServicesFactory.implementation().removeCurrentApplicationUser();
                logger.debug("Unmocked user");
            }
        }
    }

    private boolean mockUserIfNeeded(MeoWallet digitalPaymentPlatform) {
        boolean needToMockUser;
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        boolean bl = needToMockUser = StringUtils.isEmpty((String)TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername()) && StringUtils.isNotEmpty((String)digitalPaymentPlatform.getApplicationUsernameForAutomaticOperations());
        if (needToMockUser) {
            treasuryServices.setCurrentApplicationUser(digitalPaymentPlatform.getApplicationUsernameForAutomaticOperations());
            logger.debug("Mocked user with " + digitalPaymentPlatform.getApplicationUsernameForAutomaticOperations());
            return true;
        }
        return false;
    }

    private MeoWalletLog createLog() {
        return (MeoWalletLog)((Object)advice$createLog.perform((Callable)new MeoWalletWebhooksController$callable$createLog(this)));
    }

    static /* synthetic */ MeoWalletLog advised$createLog(MeoWalletWebhooksController this_) {
        return MeoWalletLog.createLogForWebhookNotification();
    }

    static {
        advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(MeoWalletWebhooksController.class);
    }
}

