/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;

public class TreasuryExemptionBean
implements ITreasuryBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private TreasuryEvent treasuryEvent;
    private List<TreasuryTupleDataSourceBean> treasuryExemptionTypes;
    private List<TreasuryTupleDataSourceBean> products;
    private List<TreasuryTupleDataSourceBean> debitEntries;
    private TreasuryExemptionType treasuryExemptionType;
    private DebitEntry debitEntry;
    private BigDecimal netAmountToExempt;
    private String reason;
    private String currencySymbol;

    public TreasuryExemptionBean() {
        this.setTreasuryExemptionTypes(TreasuryExemptionType.findAll().sorted(TreasuryExemptionType.COMPARE_BY_NAME).collect(Collectors.toList()));
    }

    public TreasuryExemptionBean(TreasuryEvent treasuryEvent) {
        this();
        this.treasuryEvent = treasuryEvent;
        this.setDebitEntries(DebitEntry.findActive(treasuryEvent).map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), this.debitEntryDescription((DebitEntry)((Object)l)))).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList()));
    }

    private String debitEntryDescription(DebitEntry debitEntry) {
        if (debitEntry.getFinantialDocument() == null) {
            return debitEntry.getDescription();
        }
        return String.format("%s [%s]", debitEntry.getDescription(), debitEntry.getFinantialDocument().getUiDocumentNumber());
    }

    public List<TreasuryTupleDataSourceBean> getTreasuryExemptionTypes() {
        return this.treasuryExemptionTypes;
    }

    public TreasuryEvent getTreasuryEvent() {
        return this.treasuryEvent;
    }

    public void setTreasuryEvent(TreasuryEvent treasuryEvent) {
        this.treasuryEvent = treasuryEvent;
    }

    public void setTreasuryExemptionTypes(List<TreasuryExemptionType> treasuryExemptionTypes) {
        this.treasuryExemptionTypes = treasuryExemptionTypes.stream().map(treasuryExemptionType -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setText(treasuryExemptionType.getName().getContent());
            tuple.setId(treasuryExemptionType.getExternalId());
            return tuple;
        }).collect(Collectors.toList());
    }

    public List<TreasuryTupleDataSourceBean> getProducts() {
        return this.products;
    }

    public void setProducts(List<Product> products) {
        this.products = products.stream().map(product -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setText(product.getName().getContent());
            tuple.setId(product.getExternalId());
            return tuple;
        }).collect(Collectors.toList());
    }

    public TreasuryExemptionType getTreasuryExemptionType() {
        return this.treasuryExemptionType;
    }

    public void setTreasuryExemptionType(TreasuryExemptionType treasuryExemptionType) {
        this.treasuryExemptionType = treasuryExemptionType;
    }

    public List<TreasuryTupleDataSourceBean> getDebitEntries() {
        return this.debitEntries;
    }

    public void setDebitEntries(List<TreasuryTupleDataSourceBean> debitEntries) {
        this.debitEntries = debitEntries;
    }

    public BigDecimal getNetAmountToExempt() {
        return this.netAmountToExempt;
    }

    public void setNetAmountToExempt(BigDecimal netAmountToExempt) {
        this.netAmountToExempt = netAmountToExempt;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public DebitEntry getDebitEntry() {
        return this.debitEntry;
    }

    public void setDebitEntry(DebitEntry debitEntry) {
        this.debitEntry = debitEntry;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }
}

