/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.treasurydebtprocess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.treasurydebtprocess.ITreasuryDebtProcess;
import org.fenixedu.treasury.domain.treasurydebtprocess.ITreasuryDebtProcessService;
import org.fenixedu.treasury.domain.treasurydebtprocess.InvoiceEntryBlockingPaymentContext;

public class TreasuryDebtProcessMainService {
    private static final List<ITreasuryDebtProcessService> services = new ArrayList<ITreasuryDebtProcessService>();

    public static void registerService(ITreasuryDebtProcessService service) {
        if (!services.stream().anyMatch(s -> s.getClass().equals(service.getClass()))) {
            services.add(service);
        }
    }

    public static void removeService(Class<ITreasuryDebtProcessService> clazz) {
        Optional<ITreasuryDebtProcessService> optional = services.stream().filter(s -> s.getClass().equals(clazz)).findAny();
        if (optional.isPresent()) {
            services.remove(optional.get());
        }
    }

    public static Set<? extends ITreasuryDebtProcess> getDebtProcesses(InvoiceEntry invoiceEntry) {
        HashSet result = new HashSet();
        services.stream().forEach(service -> result.addAll(service.getDebtProcesses(invoiceEntry)));
        return result;
    }

    public static boolean isBlockingPaymentInFrontend(InvoiceEntry invoiceEntry) {
        for (ITreasuryDebtProcessService service : services) {
            if (!service.isBlockingPaymentInFrontend(invoiceEntry)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockingPaymentInBackoffice(InvoiceEntry invoiceEntry) {
        for (ITreasuryDebtProcessService service : services) {
            if (!service.isBlockingPaymentInBackoffice(invoiceEntry)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockingPayment(InvoiceEntry invoiceEntry, InvoiceEntryBlockingPaymentContext context) {
        if (context == InvoiceEntryBlockingPaymentContext.FRONTEND) {
            return TreasuryDebtProcessMainService.isBlockingPaymentInFrontend(invoiceEntry);
        }
        return TreasuryDebtProcessMainService.isBlockingPaymentInBackoffice(invoiceEntry);
    }

    public static boolean isBlockingPayment(Installment installment, InvoiceEntryBlockingPaymentContext context) {
        return installment.getInstallmentEntriesSet().stream().map(e -> e.getDebitEntry()).filter(d -> d.isInDebt()).anyMatch(d -> TreasuryDebtProcessMainService.isBlockingPayment((InvoiceEntry)((Object)((Object)d)), context));
    }

    public static List<LocalizedString> getBlockingPaymentReasonsForFrontend(DebtAccount debtAccount) {
        ArrayList<LocalizedString> result = new ArrayList<LocalizedString>();
        for (ITreasuryDebtProcessService service : services) {
            if (service.getBlockingPaymentReasonForFrontend(debtAccount) == null) continue;
            result.add(service.getBlockingPaymentReasonForFrontend(debtAccount));
        }
        return result;
    }

    public static List<LocalizedString> getBlockingPaymentReasonsForFrontend(InvoiceEntry invoiceEntry) {
        ArrayList<LocalizedString> result = new ArrayList<LocalizedString>();
        for (ITreasuryDebtProcessService service : services) {
            if (service.getBlockingPaymentReasonForFrontend(invoiceEntry) == null) continue;
            result.add(service.getBlockingPaymentReasonForFrontend(invoiceEntry));
        }
        return result;
    }

    public static List<LocalizedString> getBlockingPaymentReasonsForBackoffice(InvoiceEntry invoiceEntry) {
        ArrayList<LocalizedString> result = new ArrayList<LocalizedString>();
        for (ITreasuryDebtProcessService service : services) {
            if (service.getBlockingPaymentReasonForBackoffice(invoiceEntry) == null) continue;
            result.add(service.getBlockingPaymentReasonForBackoffice(invoiceEntry));
        }
        return result;
    }

    public static boolean isInterestCreationWhenTotalSettledPrevented(InvoiceEntry invoiceEntry) {
        for (ITreasuryDebtProcessService service : services) {
            if (!service.isInterestCreationWhenTotalSettledPrevented(invoiceEntry)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFinantialDocumentAnnullmentActionBlocked(FinantialDocument finantialDocument) {
        for (ITreasuryDebtProcessService service : services) {
            if (!service.isFinantialDocumentAnnullmentActionBlocked(finantialDocument)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFinantialDocumentEntryAnnullmentActionBlocked(FinantialDocumentEntry finantialDocumentEntry) {
        for (ITreasuryDebtProcessService service : services) {
            if (!service.isFinantialDocumentEntryAnnullmentActionBlocked(finantialDocumentEntry)) continue;
            return true;
        }
        return false;
    }

    public static Set<? extends ITreasuryDebtProcess> getDebtProcesses(SettlementNote settlementNote) {
        HashSet result = new HashSet();
        services.stream().forEach(service -> result.addAll(service.getDebtProcesses(settlementNote)));
        return result;
    }

    public static boolean isDebitEntryInterestCreationInAdvanceBlocked(DebitEntry debitEntry) {
        for (ITreasuryDebtProcessService service : services) {
            if (!service.isDebitEntryInterestCreationInAdvanceBlocked(debitEntry)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomerFiscalNumberInvalid(Customer customer) {
        for (ITreasuryDebtProcessService service : services) {
            if (!service.isCustomerFiscalNumberInvalid(customer)) continue;
            return true;
        }
        return false;
    }

    public static List<LocalizedString> getCustomerFiscalNumberInvalidReason(Customer customer) {
        ArrayList<LocalizedString> result = new ArrayList<LocalizedString>();
        for (ITreasuryDebtProcessService service : services) {
            if (service.getCustomerFiscalNumberInvalidReason(customer) == null) continue;
            result.add(service.getCustomerFiscalNumberInvalidReason(customer));
        }
        return result;
    }
}

