/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment$callable$create;
import org.fenixedu.treasury.domain.paymentPlan.Installment$callable$delete;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.Installment_Base;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Installment
extends Installment_Base {
    public static final Comparator<? super Installment> COMPARE_BY_DUEDATE;
    public static final Advice advice$create;
    public static final Advice advice$delete;

    public Installment() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public Installment(LocalizedString description, LocalDate dueDate, PaymentPlan paymentPlan) {
        this();
        this.setDescription(description);
        this.setDueDate(dueDate);
        this.setPaymentPlan(paymentPlan);
        this.checkRules();
    }

    public static Installment create(LocalizedString localizedString, LocalDate localDate, PaymentPlan paymentPlan) {
        return (Installment)((Object)advice$create.perform((Callable)new Installment$callable$create(localizedString, localDate, paymentPlan)));
    }

    static /* synthetic */ Installment advised$create(LocalizedString description, LocalDate dueDate, PaymentPlan paymentPlan) {
        return new Installment(description, dueDate, paymentPlan);
    }

    private void checkRules() {
        if (this.getDescription() == null) {
            throw new TreasuryDomainException("error.Installment.description.required", new String[0]);
        }
        if (this.getDueDate() == null) {
            throw new TreasuryDomainException("error.Installment.dueDate.required", new String[0]);
        }
        if (this.getPaymentPlan() == null) {
            throw new TreasuryDomainException("error.Installment.paymentPlan.required", new String[0]);
        }
        if (this.getDueDate().isBefore((ReadablePartial)this.getPaymentPlan().getCreationDate())) {
            throw new TreasuryDomainException("error.Installment.paymentPlan.must.be.after.paymentPlan.creationDate", new String[0]);
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Installment$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Installment this_) {
        this_.setDomainRoot(null);
        this_.getInstallmentEntriesSet().forEach(i -> i.delete());
        this_.deleteDomainObject();
    }

    public BigDecimal getTotalAmount() {
        this.getCurrency();
        return Currency.getValueWithScale(this.getInstallmentEntriesSet().stream().map(i -> i.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    public BigDecimal getPaidAmount() {
        this.getCurrency();
        return Currency.getValueWithScale(this.getInstallmentEntriesSet().stream().map(i -> i.getPaidAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    public BigDecimal getOpenAmount() {
        this.getCurrency();
        return Currency.getValueWithScale(this.getTotalAmount().subtract(this.getPaidAmount()));
    }

    public boolean isPaid() {
        return TreasuryConstants.isZero(this.getOpenAmount());
    }

    public List<InstallmentEntry> getSortedInstallmentEntries() {
        return super.getInstallmentEntriesSet().stream().sorted(InstallmentEntry.COMPARE_BY_DEBIT_ENTRY_COMPARATOR).collect(Collectors.toList());
    }

    public List<InstallmentEntry> getSortedOpenInstallmentEntries() {
        return super.getInstallmentEntriesSet().stream().filter(d -> !d.isPaid()).sorted(InstallmentEntry.COMPARE_BY_DEBIT_ENTRY_COMPARATOR).collect(Collectors.toList());
    }

    private Currency getCurrency() {
        return this.getPaymentPlan().getDebtAccount().getFinantialInstitution().getCurrency();
    }

    public boolean isOverdue() {
        return this.isOverdue(LocalDate.now());
    }

    public boolean isOverdue(LocalDate date) {
        return !this.isPaid() && this.getDueDate().isBefore((ReadablePartial)date);
    }

    public Map<String, String> getPropertiesMap() {
        return TreasuryConstants.propertiesJsonToMap(this.getPropertiesJsonMap());
    }

    public void editPropertiesMap(Map<String, String> propertiesMap) {
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(propertiesMap));
    }

    public Set<SibsPaymentRequest> getActiveSibsPaymentRequestsOfPendingInstallments() {
        return this.getPaymentRequestsSet().stream().filter(p -> p instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast).filter(p -> p.getState() == PaymentReferenceCodeStateType.UNUSED || p.getState() == PaymentReferenceCodeStateType.USED).filter(p -> p.getExpiresDate() == null || !p.getExpiresDate().isBeforeNow()).collect(Collectors.toSet());
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_DUEDATE = (m1, m2) -> m1.getDueDate().compareTo((ReadablePartial)m2.getDueDate());
    }
}

