/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto.forwardpayments;

import java.math.BigDecimal;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.joda.time.DateTime;

public class ForwardPaymentStatusBean {
    private boolean operationSuccess;
    private ForwardPaymentStateType stateType;
    private String authorizationNumber;
    private DateTime authorizationDate;
    private String transactionId;
    private DateTime transactionDate;
    private BigDecimal payedAmount;
    private String statusCode;
    private String statusMessage;
    private String requestBody;
    private String responseBody;
    private String sibsOnlinePaymentBrands;

    public ForwardPaymentStatusBean(boolean operationSuccess, ForwardPaymentStateType paymentStateType, String statusCode, String statusMessage, String requestBody, String responseBody) {
        this.operationSuccess = operationSuccess;
        this.stateType = paymentStateType;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.requestBody = requestBody;
        this.responseBody = responseBody;
    }

    public void editTransactionDetails(String transactionId, DateTime transactionDate, BigDecimal payedAmount) {
        this.transactionId = transactionId;
        this.transactionDate = transactionDate;
        this.payedAmount = payedAmount;
    }

    public void editAuthorizationDetails(String authorizationNumber, DateTime authorizationDate) {
        this.authorizationNumber = authorizationNumber;
        this.authorizationDate = authorizationDate;
    }

    public boolean isInPayedState() {
        return this.getStateType() != null && this.getStateType().isPayed();
    }

    public boolean isInRejectedState() {
        return this.getStateType() != null && this.getStateType().isRejected();
    }

    public boolean isAbleToRegisterPostPayment(ForwardPaymentRequest forwardPayment) {
        return forwardPayment.isInStateToPostProcessPayment() && this.getStateType() != null && this.getStateType().isPayed();
    }

    public void defineSibsOnlinePaymentBrands(String paymentBrands) {
        this.sibsOnlinePaymentBrands = paymentBrands;
    }

    public boolean isOperationSuccess() {
        return this.operationSuccess;
    }

    public ForwardPaymentStateType getStateType() {
        return this.stateType;
    }

    public String getAuthorizationNumber() {
        return this.authorizationNumber;
    }

    public DateTime getAuthorizationDate() {
        return this.authorizationDate;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public DateTime getTransactionDate() {
        return this.transactionDate;
    }

    public BigDecimal getPayedAmount() {
        return this.payedAmount;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getSibsOnlinePaymentBrands() {
        return this.sibsOnlinePaymentBrands;
    }
}

