/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.reports;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.services.reports.DocumentPrinterInterface;

public class DocumentPrinter {
    private static DocumentPrinterInterface SINGLETON;
    public static final String PDF = "application/pdf";
    public static final String ODT = "application/vnd.oasis.opendocument.text";

    public static void registerPrinterInterface(DocumentPrinterInterface printer) {
        SINGLETON = printer;
        SINGLETON.init();
    }

    private static <T> T apply(Function<DocumentPrinterInterface, T> function) {
        return Optional.ofNullable(SINGLETON).map(function).orElseThrow(() -> new RuntimeException("Feature not available"));
    }

    public static byte[] printDebtAccountPaymentPlan(DebtAccount debtAccount, String outputMimeType) {
        return DocumentPrinter.apply(dp -> dp.printDebtAccountPaymentPlan(debtAccount, outputMimeType));
    }

    public static byte[] printDebitNotesPaymentPlan(DebtAccount debtAccount, List<DebitNote> documents, String outputMimeType) {
        return DocumentPrinter.apply(dp -> dp.printDebitNotesPaymentPlan(debtAccount, documents, outputMimeType));
    }

    public static byte[] printFinantialDocument(FinantialDocument document, String outputMimeType) {
        return DocumentPrinter.apply(dp -> dp.printFinantialDocument(document, outputMimeType));
    }
}

