/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qubit.terra.framework.tools.excel.ExcelUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment$callable$_postForwardPaymentProcessService;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentLog;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentLogFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment_Base;
import org.fenixedu.treasury.domain.forwardpayments.PostForwardPaymentsReportFile;
import org.fenixedu.treasury.domain.forwardpayments.exceptions.ForwardPaymentAlreadyPayedException;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class ForwardPayment
extends ForwardPayment_Base {
    private static final Comparator<ForwardPayment> ORDER_COMPARATOR;
    private static final Comparator<DebitEntry> COMPARE_DEBIT_ENTRIES;
    public static final Advice advice$_postForwardPaymentProcessService;

    private ForwardPayment() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public ForwardPayment(ForwardPaymentConfiguration forwardPaymentConfiguration, DebtAccount debtAccount, Set<DebitEntry> debitEntriesSet, Set<Installment> installmentsToPay) {
        this();
        this.setForwardPaymentConfiguration(forwardPaymentConfiguration);
        this.setDebtAccount(debtAccount);
        this.getDebitEntriesSet().addAll(debitEntriesSet);
        this.getInstallmentsSet().addAll(installmentsToPay);
        this.setCurrentState(ForwardPaymentStateType.CREATED);
        this.setWhenOccured(new DateTime());
        for (DebitEntry debitEntry : debitEntriesSet) {
            if (TreasuryConstants.isPositive(debitEntry.getOpenAmount())) continue;
            throw new TreasuryDomainException("error.ForwardPayment.open.amount.debit.entry.not.positive", new String[0]);
        }
        BigDecimal amount = debitEntriesSet.stream().map(DebitEntry::getOpenAmountWithInterests).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        amount = amount.add(installmentsToPay.stream().map(Installment::getOpenAmount).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO));
        debtAccount.getFinantialInstitution().getCurrency();
        this.setAmount(Currency.getValueWithScale(amount));
        this.setOrderNumber(ForwardPayment.lastForwardPayment().isPresent() ? ForwardPayment.lastForwardPayment().get().getOrderNumber() + 1L : 1L);
        this.log();
        this.checkRules();
    }

    public void reject(String statusCode, String errorMessage, String requestBody, String responseBody) {
        this.setCurrentState(ForwardPaymentStateType.REJECTED);
        this.setRejectionCode(statusCode);
        this.setRejectionLog(errorMessage);
        this.log(statusCode, errorMessage, requestBody, responseBody);
        this.checkRules();
    }

    public void advanceToRequestState(String statusCode, String statusMessage, String requestBody, String responseBody) {
        this.setCurrentState(ForwardPaymentStateType.REQUESTED);
        this.log(statusCode, statusMessage, requestBody, responseBody);
        this.checkRules();
    }

    public void advanceToAuthenticatedState(String statusCode, String statusMessage, String requestBody, String responseBody) {
        this.setCurrentState(ForwardPaymentStateType.AUTHENTICATED);
        this.log(statusCode, statusMessage, requestBody, responseBody);
        this.checkRules();
    }

    public void advanceToAuthorizedState(String statusCode, String errorMessage, String requestBody, String responseBody) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.ForwardPayment.not.in.active.state", new String[0]);
        }
        if (this.isInAuthorizedState()) {
            throw new TreasuryDomainException("error.ForwardPayment.already.authorized", new String[0]);
        }
        if (this.isInPayedState()) {
            throw new ForwardPaymentAlreadyPayedException("error.ForwardPayment.already.payed", new String[0]);
        }
        this.setCurrentState(ForwardPaymentStateType.AUTHORIZED);
        this.log(statusCode, errorMessage, requestBody, responseBody);
        this.checkRules();
    }

    public void advanceToPayedState(String statusCode, String statusMessage, BigDecimal payedAmount, DateTime transactionDate, String transactionId, String authorizationNumber, String requestBody, String responseBody, String justification) {
        throw new RuntimeException("not supported");
    }

    public boolean payAllDebitEntriesInterests() {
        return true;
    }

    private Map<String, String> fillPaymentEntryPropertiesMap(String statusCode) {
        HashMap paymentEntryPropertiesMap = Maps.newHashMap();
        paymentEntryPropertiesMap.put("OrderNumber", String.valueOf(this.getOrderNumber()));
        if (!Strings.isNullOrEmpty((String)this.getTransactionId())) {
            paymentEntryPropertiesMap.put("TransactionId", this.getTransactionId());
        }
        if (this.getTransactionDate() != null) {
            paymentEntryPropertiesMap.put("TransactionDate", this.getTransactionDate().toString("yyyy/MM/dd HH:mm:ss"));
        }
        if (!Strings.isNullOrEmpty((String)statusCode)) {
            paymentEntryPropertiesMap.put("StatusCode", statusCode);
        }
        return paymentEntryPropertiesMap;
    }

    public boolean isActive() {
        return this.getCurrentState() != ForwardPaymentStateType.REJECTED;
    }

    public boolean isInCreatedState() {
        return this.getCurrentState() == ForwardPaymentStateType.CREATED;
    }

    public boolean isInAuthorizedState() {
        return this.getCurrentState() == ForwardPaymentStateType.AUTHORIZED;
    }

    public boolean isInPayedState() {
        return this.getCurrentState() == ForwardPaymentStateType.PAYED;
    }

    public boolean isInAuthenticatedState() {
        return this.getCurrentState() == ForwardPaymentStateType.AUTHENTICATED;
    }

    public boolean isInRequestedState() {
        return this.getCurrentState() == ForwardPaymentStateType.REQUESTED;
    }

    public String getReferenceNumber() {
        return String.valueOf(this.getOrderNumber());
    }

    public List<ForwardPaymentLog> getOrderedForwardPaymentLogs() {
        return this.getForwardPaymentLogsSet().stream().sorted(ForwardPaymentLog.COMPARATOR_BY_ORDER).collect(Collectors.toList());
    }

    private void checkRules() {
        if (this.isInPayedState() && this.getSettlementNote() == null) {
            throw new TreasuryDomainException("error.ForwardPayment.settlementNote.required", new String[0]);
        }
        if (this.getReferencedCustomers().size() > 1) {
            throw new TreasuryDomainException("error.ForwardPayment.referencedCustomers.only.one.allowed", new String[0]);
        }
    }

    public Set<Customer> getReferencedCustomers() {
        Set<InvoiceEntry> invoiceEntrySet = this.getInvoiceEntriesSet();
        Set installments = this.getInstallmentsSet();
        HashSet result = Sets.newHashSet();
        for (Object entry : invoiceEntrySet) {
            if (entry.getFinantialDocument() != null && ((Invoice)((Object)entry.getFinantialDocument())).isForPayorDebtAccount()) {
                result.add(((Invoice)((Object)entry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(entry.getDebtAccount().getCustomer());
        }
        for (Object entry : installments) {
            result.addAll(entry.getInstallmentEntriesSet().stream().map(e -> e.getDebitEntry()).map(deb -> deb.getFinantialDocument() != null && ((Invoice)((Object)((Object)((Object)deb.getFinantialDocument())))).isForPayorDebtAccount() ? ((Invoice)((Object)((Object)((Object)deb.getFinantialDocument())))).getPayorDebtAccount().getCustomer() : deb.getDebtAccount().getCustomer()).collect(Collectors.toSet()));
        }
        return result;
    }

    public ForwardPaymentLog log(String statusCode, String statusMessage, String requestBody, String responseBody) {
        ForwardPaymentLog log2 = this.log();
        log2.setStatusCode(statusCode);
        log2.setStatusLog(statusMessage);
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            ForwardPaymentLogFile.createForRequestBody(log2, requestBody.getBytes());
        }
        if (!Strings.isNullOrEmpty((String)responseBody)) {
            ForwardPaymentLogFile.createForResponseBody(log2, responseBody.getBytes());
        }
        return log2;
    }

    public ForwardPaymentLog logException(Exception e, String requestBody, String responseBody) {
        String exceptionLog = String.format("%s\n%s", e.getLocalizedMessage(), ExceptionUtils.getFullStackTrace((Throwable)e));
        ForwardPaymentLog log2 = this.log();
        log2.setExceptionOccured(true);
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            ForwardPaymentLogFile.createForRequestBody(log2, requestBody.getBytes());
        }
        if (!Strings.isNullOrEmpty((String)responseBody)) {
            ForwardPaymentLogFile.createForResponseBody(log2, responseBody.getBytes());
        }
        ForwardPaymentLogFile.createForException(log2, exceptionLog.getBytes());
        return log2;
    }

    private ForwardPaymentLog log() {
        return new ForwardPaymentLog(this, this.getCurrentState(), this.getWhenOccured());
    }

    public void delete() {
        this.setDebtAccount(null);
        this.setForwardPaymentConfiguration(null);
        this.setSettlementNote(null);
        this.setDomainRoot(null);
        this.getDebitEntriesSet().clear();
        while (!this.getForwardPaymentLogsSet().isEmpty()) {
            ((ForwardPaymentLog)((Object)this.getForwardPaymentLogsSet().iterator().next())).delete();
        }
        this.deleteDomainObject();
    }

    public static Stream<ForwardPayment> findAll() {
        return FenixFramework.getDomainRoot().getForwardPaymentsSet().stream();
    }

    public static Stream<ForwardPayment> findAllByStateType(ForwardPaymentStateType ... stateTypes) {
        ArrayList t = Lists.newArrayList((Object[])stateTypes);
        return ForwardPayment.findAll().filter(f -> t.contains(f.getCurrentState()));
    }

    public static ForwardPayment create(ForwardPaymentConfiguration forwardPaymentConfiguration, DebtAccount debtAccount, Set<DebitEntry> debitEntriesToPay, Set<Installment> installmentsToPay) {
        throw new RuntimeException("not supported");
    }

    public static ForwardPayment create(SettlementNoteBean bean, Function<ForwardPayment, String> successUrlFunction, Function<ForwardPayment, String> insuccessUrlFunction) {
        throw new RuntimeException("not supported");
    }

    private static Optional<ForwardPayment> lastForwardPayment() {
        return FenixFramework.getDomainRoot().getForwardPaymentsSet().stream().max(ORDER_COMPARATOR);
    }

    public static void postForwardPaymentProcessService(final DateTime beginDate, final DateTime endDate, final Logger logger) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ForwardPayment._postForwardPaymentProcessService(beginDate, endDate, logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            t.start();
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void _postForwardPaymentProcessService(DateTime dateTime, DateTime dateTime2, Logger logger) throws IOException {
        Object object = advice$_postForwardPaymentProcessService.perform((Callable)new ForwardPayment$callable$_postForwardPaymentProcessService(dateTime, dateTime2, logger));
    }

    static /* synthetic */ void advised$_postForwardPaymentProcessService(DateTime beginDate, DateTime endDate, Logger logger) throws IOException {
        if (beginDate == null || endDate == null) {
            throw new TreasuryDomainException("error.ForwardPayment.postForwardPaymentProcessService.dates.required", new String[0]);
        }
        DateTime postForwardPaymentsExecutionDate = new DateTime();
        ArrayList reportBeans = Lists.newArrayList();
        ForwardPayment.findAllByStateType(ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED).filter(f -> f.getWhenOccured().compareTo((ReadableInstant)beginDate) >= 0 && f.getWhenOccured().compareTo((ReadableInstant)endDate) < 0).forEach(f -> {
            try {
                PostForwardPaymentReportBean reportBean = ForwardPayment.updateForwardPayment(f.getExternalId(), logger);
                if (reportBean != null) {
                    logger.info(String.format("C\tPAYMENT REQUEST\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n", reportBean.executionDate, reportBean.forwardPaymentExternalId, reportBean.forwardPaymentOrderNumber, reportBean.customerCode, reportBean.customerName, reportBean.previousStateDescription, reportBean.nextStateDescription, reportBean.paymentRegisteredWithSuccess, reportBean.settlementNote, reportBean.advancedPaymentCreditNote, reportBean.paymentDate, reportBean.paidAmount, reportBean.advancedCreditAmount != null ? reportBean.advancedCreditAmount.toString() : "", reportBean.transactionId, reportBean.statusCode, reportBean.statusMessage, reportBean.remarks));
                    reportBeans.add(reportBean);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        ForwardPayment.writeExcel(reportBeans, postForwardPaymentsExecutionDate, beginDate, endDate);
    }

    private static void writeExcel(final List<PostForwardPaymentReportBean> reportBeans, DateTime postForwardPaymentsExecutionDate, DateTime beginDate, DateTime endDate) {
        byte[] content = Spreadsheet.buildSpreadsheetContent(() -> new ExcelSheet[]{new ExcelSheet(){

            @Override
            public String getName() {
                return TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.sheet.name", new String[0]);
            }

            @Override
            public String[] getHeaders() {
                return new String[]{TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.executionDate", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.forwardPaymentExternalId", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.forwardPaymentOrderNumber", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.forwardPaymentWhenOccured", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.customerCode", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.customerName", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.previousStateDescription", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.nextStateDescription", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.paymentRegisteredWithSuccess", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.settlementNote", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.advancedCreditSettlementNote", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.paymentDate", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.paidAmount", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.advancedCreditAmount", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.transactionId", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.statusCode", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.statusMessage", new String[0]), TreasuryConstants.treasuryBundle("label.PostForwardPaymentReportBean.cell.remarks", new String[0])};
            }

            @Override
            public Stream<? extends SpreadsheetRow> getRows() {
                return reportBeans.stream();
            }
        }}, null);
        String filename = TreasuryConstants.treasuryBundle("label.PostForwardPaymentsReportFile.filename", postForwardPaymentsExecutionDate.toString("yyyy_MM_dd_HH_mm_ss"));
        PostForwardPaymentsReportFile.create(postForwardPaymentsExecutionDate, beginDate, endDate, filename, content);
    }

    private static PostForwardPaymentReportBean updateForwardPayment(String forwardPaymentId, Logger logger) throws IOException {
        try {
            PostForwardPaymentReportBean reportBean = (PostForwardPaymentReportBean)FenixFramework.getTransactionManager().withTransaction(() -> {
                ForwardPayment forwardPayment = (ForwardPayment)FenixFramework.getDomainObject((String)forwardPaymentId);
                IForwardPaymentImplementation implementation = forwardPayment.getForwardPaymentConfiguration().implementation();
                String justification = TreasuryConstants.treasuryBundle("error.PostForwardPaymentsTask.post.payment.justification", new String[0]);
                PostProcessPaymentStatusBean postProcessPaymentStatusBean = implementation.postProcessPayment(forwardPayment, justification, Optional.empty());
                return new PostForwardPaymentReportBean(forwardPayment, postProcessPaymentStatusBean);
            });
            return reportBean;
        }
        catch (Exception e) {
            String message = e.getMessage();
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            String exceptionOutput = String.format("E\tERROR ON\t%s\t%s\n", forwardPaymentId, message);
            logger.error(exceptionOutput);
            logger.error(stackTrace + "\n");
            return null;
        }
    }

    public static String PAYMENT_TYPE_DESCRIPTION() {
        return TreasuryConstants.treasuryBundle("label.IPaymentProcessorForInvoiceEntries.paymentProcessorDescription.forwardPayment", new String[0]);
    }

    public DocumentNumberSeries getDocumentSeriesForPayments() {
        return DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), this.getForwardPaymentConfiguration().getSeries());
    }

    public DocumentNumberSeries getDocumentSeriesInterestDebits() {
        return DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), this.getForwardPaymentConfiguration().getSeries());
    }

    public PaymentMethod getPaymentMethod() {
        return this.getForwardPaymentConfiguration().getPaymentMethod();
    }

    public String fillPaymentEntryMethodId() {
        return null;
    }

    public BigDecimal getPayableAmount() {
        return this.getAmount();
    }

    public DateTime getPaymentRequestDate() {
        return this.getWhenOccured();
    }

    public String getPaymentRequestStateDescription() {
        return this.getCurrentState().getLocalizedName().getContent();
    }

    public String getPaymentTypeDescription() {
        return ForwardPayment.PAYMENT_TYPE_DESCRIPTION();
    }

    public Set<InvoiceEntry> getInvoiceEntriesSet() {
        HashSet<InvoiceEntry> result = new HashSet<InvoiceEntry>();
        result.addAll(this.getDebitEntriesSet());
        return result;
    }

    public boolean isForwardPayment() {
        return true;
    }

    public SibsOnlinePaymentsGateway getSibsOnlinePaymentsGateway() {
        return this.getForwardPaymentConfiguration().getSibsOnlinePaymentsGateway();
    }

    public String getSibsOppwaMerchantTransactionId() {
        return this.getSibsMerchantTransactionId();
    }

    public String getSibsOppwaTransactionId() {
        return this.getSibsTransactionId();
    }

    static {
        advice$_postForwardPaymentProcessService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        ORDER_COMPARATOR = (o1, o2) -> Long.valueOf(o1.getOrderNumber()).compareTo(o2.getOrderNumber());
        COMPARE_DEBIT_ENTRIES = (o1, o2) -> {
            Product interestProduct = TreasurySettings.getInstance().getInterestProduct();
            if (o1.getProduct() == interestProduct && o2.getProduct() != interestProduct) {
                return -1;
            }
            if (o1.getProduct() != interestProduct && o2.getProduct() == interestProduct) {
                return 1;
            }
            int compareByOpenAmount = o1.getOpenAmount().compareTo(o2.getOpenAmount());
            if (compareByOpenAmount != 0) {
                return compareByOpenAmount * -1;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        };
    }

    private static class PostForwardPaymentReportBean
    implements SpreadsheetRow {
        private String executionDate = new DateTime().toString("yyyy/MM/dd HH:mm:ss");
        private String forwardPaymentExternalId;
        private String forwardPaymentOrderNumber;
        private String forwardPaymentWhenOccured;
        private String customerCode;
        private String customerName;
        private String previousStateDescription;
        private String nextStateDescription;
        private boolean paymentRegisteredWithSuccess;
        private String settlementNote = "";
        private String advancedPaymentCreditNote = "";
        private String paymentDate = "";
        private String paidAmount = "";
        private BigDecimal advancedCreditAmount;
        private String transactionId = "";
        private String statusCode;
        private String statusMessage;
        private String remarks = "";

        private PostForwardPaymentReportBean(ForwardPayment forwardPayment, PostProcessPaymentStatusBean postProcessPaymentStatusBean) {
            this.forwardPaymentExternalId = forwardPayment.getExternalId();
            this.forwardPaymentOrderNumber = forwardPayment.getReferenceNumber();
            this.forwardPaymentWhenOccured = forwardPayment.getWhenOccured().toString("yyyy/MM/dd HH:mm:ss");
            this.customerCode = forwardPayment.getDebtAccount().getCustomer().getBusinessIdentification();
            this.customerName = forwardPayment.getDebtAccount().getCustomer().getName();
            this.previousStateDescription = postProcessPaymentStatusBean.getPreviousState().getLocalizedName().getContent();
            this.nextStateDescription = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStateType().getLocalizedName().getContent();
            this.paymentRegisteredWithSuccess = postProcessPaymentStatusBean.isSuccess();
            if (forwardPayment.getSettlementNote() != null) {
                this.settlementNote = forwardPayment.getSettlementNote().getUiDocumentNumber();
                this.paymentDate = forwardPayment.getSettlementNote().getPaymentDate().toString("yyyy/MM/dd HH:mm:ss");
                this.paidAmount = forwardPayment.getSettlementNote().getTotalPayedAmount().toString();
                this.transactionId = forwardPayment.getTransactionId();
                if (forwardPayment.getSettlementNote().getAdvancedPaymentCreditNote() != null) {
                    this.advancedPaymentCreditNote = forwardPayment.getSettlementNote().getAdvancedPaymentCreditNote().getUiDocumentNumber();
                    this.advancedCreditAmount = forwardPayment.getSettlementNote().getAdvancedPaymentCreditNote().getTotalAmount();
                }
                if (this.hasSettlementNotesOnSameDayForSameDebts(forwardPayment)) {
                    this.remarks = TreasuryConstants.treasuryBundle("warn.PostForwardPaymentsTask.settlement.notes.on.same.day.for.same.debts", new String[0]);
                }
            }
            this.statusCode = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStatusCode();
            this.statusMessage = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStatusMessage();
        }

        private boolean hasSettlementNotesOnSameDayForSameDebts(ForwardPayment forwardPayment) {
            LocalDate paymentDate = forwardPayment.getSettlementNote().getPaymentDate().toLocalDate();
            Set forwardPaymentDebitEntriesSet = forwardPayment.getDebitEntriesSet();
            for (SettlementNote settlementNote : SettlementNote.findByDebtAccount(forwardPayment.getDebtAccount()).collect(Collectors.toSet())) {
                if (settlementNote == forwardPayment.getSettlementNote() || settlementNote.isAnnulled() || !settlementNote.getPaymentDate().toLocalDate().isEqual((ReadablePartial)paymentDate)) continue;
                for (SettlementEntry settlementEntry : settlementNote.getSettlemetEntriesSet()) {
                    if (!forwardPaymentDebitEntriesSet.contains((Object)settlementEntry.getInvoiceEntry())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void writeCellValues(Row row, IErrorsLog errorsLog) {
            int i = 0;
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.executionDate);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.forwardPaymentExternalId);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.forwardPaymentOrderNumber);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.forwardPaymentWhenOccured);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.customerCode);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.customerName);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.previousStateDescription);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.nextStateDescription);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)TreasuryConstants.treasuryBundle("label." + this.paymentRegisteredWithSuccess, new String[0]));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.settlementNote);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.advancedPaymentCreditNote);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.paymentDate);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.paidAmount);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)(this.advancedCreditAmount != null ? this.advancedCreditAmount.toString() : ""));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.transactionId);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.statusCode);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.statusMessage);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.remarks);
        }
    }
}

