/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.standards.geographic.Country;
import pt.ist.standards.geographic.Planet;

public class AdhocCustomerBean
implements ITreasuryBean {
    private CustomerType customerType;
    private String code;
    private String fiscalNumber;
    private String identificationNumber;
    private String name;
    private String address;
    private String districtSubdivision;
    private String region;
    private String zipCode;
    private String addressCountryCode;
    private List<FinantialInstitution> finantialInstitutions;
    private List<TreasuryTupleDataSourceBean> finantialInstitutionsDataSource;
    private List<TreasuryTupleDataSourceBean> customerTypesDataSource;
    private List<TreasuryTupleDataSourceBean> countryCodesDataSource;
    private boolean changeFiscalNumberConfirmed;
    private boolean addressCountryDefault;

    public AdhocCustomerBean() {
        this.setFinantialInstitutionsDataSource(FinantialInstitution.findAll().collect(Collectors.toList()));
        this.setCustomerTypesDataSource(CustomerType.findAll().collect(Collectors.toList()));
        this.setCountryCodesDataSource(Lists.newArrayList((Iterable)Planet.getEarth().getPlaces()));
        this.update();
    }

    public AdhocCustomerBean(Customer customer) {
        this();
        this.setCustomerType(customer.getCustomerType());
        this.code = customer.getCode();
        this.setFiscalNumber(customer.getFiscalNumber());
        this.setIdentificationNumber(customer.getIdentificationNumber());
        this.setName(customer.getName());
        this.setAddress(customer.getAddress());
        this.setDistrictSubdivision(customer.getDistrictSubdivision());
        this.setRegion(customer.getRegion());
        this.setZipCode(customer.getZipCode());
        this.setAddressCountryCode(customer.getAddressCountryCode());
        this.setFinantialInstitutions(customer.getDebtAccountsSet().stream().filter(x -> !x.getClosed()).map(x -> x.getFinantialInstitution()).collect(Collectors.toList()));
        this.update();
    }

    public boolean isAddressValid() {
        boolean valid = true;
        valid &= !Strings.isNullOrEmpty((String)this.getAddressCountryCode());
        valid &= !Strings.isNullOrEmpty((String)this.getAddress());
        valid &= !Strings.isNullOrEmpty((String)this.getDistrictSubdivision());
        if (TreasuryConstants.isDefaultCountry(this.getAddressCountryCode())) {
            valid &= !Strings.isNullOrEmpty((String)this.getZipCode());
            valid &= !Strings.isNullOrEmpty((String)this.getRegion());
        }
        if (TreasuryConstants.isDefaultCountry(this.getAddressCountryCode()) && !Strings.isNullOrEmpty((String)this.getZipCode())) {
            valid &= this.getZipCode().matches("\\d{4}-\\d{3}");
        }
        return valid;
    }

    public String getCode() {
        return this.code;
    }

    public String getFiscalNumber() {
        return this.fiscalNumber;
    }

    public void setFiscalNumber(String value) {
        this.fiscalNumber = value;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String value) {
        this.identificationNumber = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        this.address = value;
    }

    public String getDistrictSubdivision() {
        return this.districtSubdivision;
    }

    public void setDistrictSubdivision(String value) {
        this.districtSubdivision = value;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String value) {
        this.zipCode = value;
    }

    public String getAddressCountryCode() {
        return this.addressCountryCode;
    }

    public void setAddressCountryCode(String addressCountryCode) {
        this.addressCountryCode = addressCountryCode;
    }

    public CustomerType getCustomerType() {
        return this.customerType;
    }

    public void setCustomerType(CustomerType customerType) {
        this.customerType = customerType;
    }

    public boolean isChangeFiscalNumberConfirmed() {
        return this.changeFiscalNumberConfirmed;
    }

    public void setChangeFiscalNumberConfirmed(boolean value) {
        this.changeFiscalNumberConfirmed = value;
    }

    public void update() {
        this.addressCountryDefault = "PT".toUpperCase().equals(this.getAddressCountryCode());
    }

    public boolean isAddressCountryDefault() {
        return this.addressCountryDefault;
    }

    public List<FinantialInstitution> getFinantialInstitutions() {
        return this.finantialInstitutions;
    }

    public void setFinantialInstitutions(List<FinantialInstitution> finantialInstitutions) {
        this.finantialInstitutions = finantialInstitutions;
    }

    public List<TreasuryTupleDataSourceBean> getFinantialInstitutionsDataSource() {
        return this.finantialInstitutionsDataSource;
    }

    public void setFinantialInstitutionsDataSource(List<FinantialInstitution> finantialInstitutionsDataSource) {
        this.finantialInstitutionsDataSource = finantialInstitutionsDataSource.stream().map(x -> {
            TreasuryTupleDataSourceBean inst = new TreasuryTupleDataSourceBean();
            inst.setId(x.getExternalId());
            inst.setText(x.getName());
            return inst;
        }).collect(Collectors.toList());
    }

    public List<TreasuryTupleDataSourceBean> getCustomerTypesDataSource() {
        return this.customerTypesDataSource;
    }

    public void setCustomerTypesDataSource(List<CustomerType> customerTypesDataSource) {
        this.customerTypesDataSource = customerTypesDataSource.stream().map(customerType -> {
            TreasuryTupleDataSourceBean customerTypeDataSource = new TreasuryTupleDataSourceBean();
            customerTypeDataSource.setId(customerType.getExternalId());
            customerTypeDataSource.setText(customerType.getName().getContent());
            return customerTypeDataSource;
        }).collect(Collectors.toList());
    }

    public List<TreasuryTupleDataSourceBean> getCountryCodesDataSource() {
        return this.countryCodesDataSource;
    }

    public void setCountryCodesDataSource(List<Country> countries) {
        this.countryCodesDataSource = countries.stream().map(c -> new TreasuryTupleDataSourceBean(c.alpha2, c.getLocalizedName(I18N.getLocale()))).collect(Collectors.toList());
        Collections.sort(this.countryCodesDataSource, TreasuryTupleDataSourceBean.COMPARE_BY_TEXT);
    }
}

