/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.virtualpaymententries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementInterestEntryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class VirtualInterestHandler
implements IVirtualPaymentEntryHandler {
    @Override
    public List<ISettlementInvoiceEntryBean> createISettlementInvoiceEntryBean(SettlementNoteBean settlementNoteBean) {
        ArrayList<ISettlementInvoiceEntryBean> result = new ArrayList<ISettlementInvoiceEntryBean>();
        for (SettlementDebitEntryBean debitEntryBean : settlementNoteBean.getDebitEntriesByType(SettlementDebitEntryBean.class)) {
            if (!debitEntryBean.isIncluded() || !TreasuryConstants.isEqual(debitEntryBean.getDebitEntry().getOpenAmount(), debitEntryBean.getSettledAmount())) continue;
            List<InterestRateBean> undebitedInterestBeansList = debitEntryBean.getDebitEntry().calculateUndebitedInterestValue(settlementNoteBean.getDate().toLocalDate());
            for (InterestRateBean debitInterest : undebitedInterestBeansList) {
                if (!TreasuryConstants.isPositive(debitInterest.getInterestAmount())) continue;
                SettlementInterestEntryBean interestEntryBean = new SettlementInterestEntryBean(debitEntryBean.getDebitEntry(), debitInterest);
                interestEntryBean.setVirtualPaymentEntryHandler(this);
                interestEntryBean.setIncluded(!debitEntryBean.getDebitEntry().isExportedInERPAndInRestrictedPaymentMixingLegacyInvoices());
                interestEntryBean.setCalculationDescription(this.getCalculationDescription(settlementNoteBean, interestEntryBean));
                result.add(interestEntryBean);
            }
        }
        return result;
    }

    private Map<String, List<String>> getCalculationDescription(SettlementNoteBean settlementNoteBean, SettlementInterestEntryBean interestEntryBean) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Currency currency = settlementNoteBean.getDebtAccount().getFinantialInstitution().getCurrency();
        String title = "";
        title = interestEntryBean.getInterest().getInterestRateType() != null ? interestEntryBean.getInterest().getInterestRateType().getUiVirtualInterestHandlerCalculatedInterestsTitle().getContent() : TreasuryConstants.treasuryBundle("label.VirtualInterestHandler.Calculated_interests", new String[0]);
        ArrayList<String> lines = new ArrayList<String>();
        for (InterestRateBean.InterestInformationDetail detail : interestEntryBean.getInterest().getInterestInformationList()) {
            if (detail.getBegin() != null && detail.getEnd() != null) {
                lines.add(String.format("[%s - %s]: %s", detail.getBegin().toString("yyyy/MM/dd"), detail.getEnd().toString("yyyy/MM/dd"), currency.getValueFor(detail.getAmount())));
                lines.add(TreasuryConstants.treasuryBundle("label.InterestEntry.affectedAmount.description", currency.getValueFor(detail.getAffectedAmount()), "" + detail.getNumberOfDays(), detail.getInterestRate().toString()));
                continue;
            }
            if (detail.getBegin() == null) continue;
            lines.add(String.format("%s: %s", detail.getBegin().toString("yyyy/MM/dd"), currency.getValueFor(detail.getAmount())));
        }
        map.put(title, lines);
        if (!interestEntryBean.getInterest().getCreatedInterestEntriesList().isEmpty()) {
            title = "";
            title = interestEntryBean.getInterest().getInterestRateType() != null ? interestEntryBean.getInterest().getInterestRateType().getUiVirtualInterestHandlerCreatedInterestsTitle().getContent() : TreasuryConstants.treasuryBundle("label.VirtualInterestHandler.Created_interests", new String[0]);
            lines = new ArrayList();
            for (InterestRateBean.CreatedInterestEntry entry : interestEntryBean.getInterest().getCreatedInterestEntriesList()) {
                lines.add(String.format("[%s]: %s", entry.getEntryDate().toString("yyyy/MM/dd"), currency.getValueFor(entry.getAmount())));
            }
            map.put(title, lines);
        }
        return map;
    }

    @Override
    public void execute(SettlementNoteBean settlementNoteBean, ISettlementInvoiceEntryBean invoiceEntryBean) {
        if (!(invoiceEntryBean instanceof SettlementInterestEntryBean)) {
            return;
        }
        SettlementInterestEntryBean interestEntryBean = (SettlementInterestEntryBean)invoiceEntryBean;
        DebtAccount payorDebtAccount = null;
        if (settlementNoteBean.getReferencedCustomers().size() == 1 && settlementNoteBean.getReferencedCustomers().iterator().next() != settlementNoteBean.getDebtAccount().getCustomer()) {
            Customer payorCustomer = settlementNoteBean.getReferencedCustomers().iterator().next();
            payorDebtAccount = payorCustomer.getDebtAccountFor(settlementNoteBean.getDebtAccount().getFinantialInstitution());
        }
        DocumentNumberSeries debitNoteSeries = DocumentNumberSeries.findUniqueDefaultSeries(FinantialDocumentType.findForDebitNote(), settlementNoteBean.getFinantialEntity());
        DebitNote interestDebitNote = DebitNote.create(settlementNoteBean.getFinantialEntity(), settlementNoteBean.getDebtAccount(), payorDebtAccount, debitNoteSeries, new DateTime(), new LocalDate(), null, Collections.emptyMap(), null, null);
        DateTime whenInterestDebitEntryDateTime = interestEntryBean.getInterest().getInterestDebitEntryDateTime() != null ? interestEntryBean.getInterest().getInterestDebitEntryDateTime() : new DateTime();
        DebitEntry interestDebitEntry = interestEntryBean.getDebitEntry().createInterestRateDebitEntry(interestEntryBean.getInterest(), whenInterestDebitEntryDateTime, interestDebitNote);
        SettlementDebitEntryBean settlementDebitEntryBean = new SettlementDebitEntryBean(interestDebitEntry);
        settlementDebitEntryBean.setIncluded(true);
        settlementNoteBean.getDebitEntries().add(settlementDebitEntryBean);
        interestEntryBean.setIncluded(false);
    }
}

