/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class SettlementCreditEntryBean
implements ISettlementInvoiceEntryBean,
ITreasuryBean,
Serializable {
    private static final String CREDIT_AMOUNT = "creditAmount";
    private static final long serialVersionUID = 1L;
    private CreditEntry creditEntry;
    private boolean isIncluded;
    private boolean isNotValid;
    private BigDecimal creditAmount;

    public SettlementCreditEntryBean() {
    }

    public SettlementCreditEntryBean(CreditEntry creditEntry) {
        this.creditEntry = creditEntry;
        this.isIncluded = false;
        this.isNotValid = false;
        this.creditAmount = creditEntry.getOpenAmount();
    }

    public CreditEntry getCreditEntry() {
        return this.creditEntry;
    }

    public void setCreditEntry(CreditEntry creditEntry) {
        this.creditEntry = creditEntry;
    }

    public String getDocumentNumber() {
        return this.creditEntry.getFinantialDocument() != null ? this.creditEntry.getFinantialDocument().getDocumentNumber() : null;
    }

    @Deprecated
    public LocalDate getDocumentDueDate() {
        return this.creditEntry.getFinantialDocument() != null ? this.creditEntry.getFinantialDocument().getDocumentDueDate() : this.creditEntry.getEntryDateTime().toLocalDate();
    }

    @Deprecated
    public BigDecimal getCreditAmount() {
        if (this.creditAmount == null) {
            return null;
        }
        this.creditEntry.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(this.creditAmount);
    }

    @Deprecated
    public BigDecimal getCreditAmountWithVat() {
        if (this.creditAmount == null) {
            return null;
        }
        this.creditEntry.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(this.creditAmount);
    }

    @Deprecated
    public void setCreditAmount(BigDecimal creditAmount) {
        this.creditAmount = creditAmount;
    }

    @Override
    public InvoiceEntry getInvoiceEntry() {
        return this.creditEntry;
    }

    @Override
    public String getDescription() {
        return this.creditEntry.getDescription();
    }

    @Override
    public LocalDate getDueDate() {
        return this.creditEntry.getDueDate();
    }

    @Override
    public BigDecimal getEntryAmount() {
        return this.creditEntry.getAmount();
    }

    @Override
    public BigDecimal getEntryOpenAmount() {
        return this.creditEntry.getOpenAmount();
    }

    @Override
    public BigDecimal getSettledAmount() {
        return this.creditAmount;
    }

    @Override
    public void setSettledAmount(BigDecimal debtAmount) {
        this.creditAmount = debtAmount;
    }

    @Override
    public Vat getVat() {
        return this.creditEntry.getVat();
    }

    @Override
    public BigDecimal getVatRate() {
        return this.creditEntry.getVatRate();
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    @Override
    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
    }

    @Override
    public boolean isNotValid() {
        return this.isNotValid;
    }

    @Override
    public void setNotValid(boolean notValid) {
        this.isNotValid = notValid;
    }

    @Override
    public FinantialDocument getFinantialDocument() {
        return this.creditEntry.getFinantialDocument();
    }

    @Override
    public Set<Customer> getPaymentCustomer() {
        return this.creditEntry.getFinantialDocument() != null && ((Invoice)((Object)this.creditEntry.getFinantialDocument())).getPayorDebtAccount() != null ? Collections.singleton(((Invoice)((Object)this.creditEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer()) : Collections.singleton(this.creditEntry.getDebtAccount().getCustomer());
    }

    @Override
    public boolean isForCreditEntry() {
        return true;
    }

    @Override
    public boolean isForFinantialEntity(FinantialEntity finantialEntity) {
        return this.creditEntry.getFinantialEntity() == null || this.creditEntry.getFinantialEntity() == finantialEntity;
    }

    @Override
    public String serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(this.getClass().getName()));
        jsonObject.add(CREDIT_AMOUNT, (JsonElement)new JsonPrimitive(this.getInvoiceEntry().getExternalId()));
        jsonObject.add("included", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isIncluded)));
        jsonObject.add("notValid", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isNotValid)));
        jsonObject.add("amount", (JsonElement)new JsonPrimitive(this.getSettledAmount().toPlainString()));
        return jsonObject.toString();
    }

    @Override
    public void fillSerializable(JsonObject jsonObject) {
        this.creditEntry = (CreditEntry)FenixFramework.getDomainObject((String)jsonObject.get(CREDIT_AMOUNT).getAsString());
        this.isIncluded = jsonObject.get("included").getAsBoolean();
        this.isNotValid = jsonObject.get("notValid").getAsBoolean();
        this.creditAmount = jsonObject.get("amount").getAsBigDecimal();
    }
}

