/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.VatType$callable$create;
import org.fenixedu.treasury.domain.VatType$callable$delete;
import org.fenixedu.treasury.domain.VatType$callable$edit;
import org.fenixedu.treasury.domain.VatType_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class VatType
extends VatType_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected VatType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected VatType(String code, LocalizedString name) {
        this();
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.VatType.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.VatType.name.required", new String[0]);
        }
        VatType.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> VatType.findByName(this.getName().getContent(l)));
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new VatType$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(VatType this_, String code, LocalizedString name) {
        this_.setCode(code);
        this_.setName(name);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getProductsSet().isEmpty() && this.getVatsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new VatType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(VatType this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.VatType.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.getProductGroupsSet().clear();
        this_.deleteDomainObject();
    }

    public static Stream<VatType> findAll() {
        return FenixFramework.getDomainRoot().getVatTypesSet().stream();
    }

    public static VatType findByCode(String code) {
        VatType result = null;
        for (VatType it : VatType.findAll().collect(Collectors.toList())) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.VatType.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static VatType findByName(String name) {
        VatType result = null;
        for (VatType it : VatType.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.VatType.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static VatType create(String string, LocalizedString localizedString) {
        return (VatType)((Object)advice$create.perform((Callable)new VatType$callable$create(string, localizedString)));
    }

    static /* synthetic */ VatType advised$create(String code, LocalizedString name) {
        return new VatType(code, name);
    }
}

