/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.onlinepaymentsgateway.sibs.sdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PaymentType;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.SibsEnvironmentMode;

public class PrepareHandle {
    private String entityId;
    private String amount;
    private String currency;
    private PaymentType paymentType;
    private SibsEnvironmentMode environmentMode;

    public PrepareHandle(String entityId, String amount, String currency, String paymentType, SibsEnvironmentMode environmentMode) {
        this.entityId = entityId;
        this.amount = amount;
        this.currency = currency;
        this.paymentType = PaymentType.valueOf(paymentType);
        this.environmentMode = environmentMode;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = PaymentType.valueOf(paymentType);
    }

    public SibsEnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(SibsEnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public MultivaluedMap<String, String> asMap() {
        MultivaluedHashMap form = new MultivaluedHashMap();
        form.add((Object)"entityId", (Object)this.entityId);
        form.add((Object)"amount", (Object)this.amount.toString());
        form.add((Object)"currency", (Object)this.currency);
        form.add((Object)"paymentType", (Object)this.paymentType.toString());
        if (this.environmentMode == SibsEnvironmentMode.TEST_MODE_EXTERNAL) {
            form.add((Object)"testMode", (Object)"EXTERNAL");
            form.add((Object)"customParameters[SIBS_ENV]", (Object)"QLY");
        } else if (this.environmentMode == SibsEnvironmentMode.TEST_MODE_INTERNAL) {
            form.add((Object)"testMode", (Object)"INTERNAL");
            form.add((Object)"customParameters[SIBS_ENV]", (Object)"QLY");
        } else if (this.environmentMode != SibsEnvironmentMode.PRODUCTION) {
            throw new RuntimeException("Unknow environment mode.");
        }
        return form;
    }

    public String toString() {
        MultivaluedMap<String, String> map = this.asMap();
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }
}

